/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationResponse extends MigrationHubRefactorSpacesResponse implements
        ToCopyableBuilder<GetApplicationResponse.Builder, GetApplicationResponse> {
    private static final SdkField<ApiGatewayProxyConfig> API_GATEWAY_PROXY_FIELD = SdkField
            .<ApiGatewayProxyConfig> builder(MarshallingType.SDK_POJO).memberName("ApiGatewayProxy")
            .getter(getter(GetApplicationResponse::apiGatewayProxy)).setter(setter(Builder::apiGatewayProxy))
            .constructor(ApiGatewayProxyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiGatewayProxy").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(GetApplicationResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetApplicationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATED_BY_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedByAccountId").getter(getter(GetApplicationResponse::createdByAccountId))
            .setter(setter(Builder::createdByAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByAccountId").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(GetApplicationResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(GetApplicationResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<ErrorResponse> ERROR_FIELD = SdkField.<ErrorResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(GetApplicationResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(GetApplicationResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetApplicationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(GetApplicationResponse::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> PROXY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyType").getter(getter(GetApplicationResponse::proxyTypeAsString)).setter(setter(Builder::proxyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetApplicationResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetApplicationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(GetApplicationResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(API_GATEWAY_PROXY_FIELD, APPLICATION_ID_FIELD, ARN_FIELD,
                    CREATED_BY_ACCOUNT_ID_FIELD, CREATED_TIME_FIELD, ENVIRONMENT_ID_FIELD, ERROR_FIELD, LAST_UPDATED_TIME_FIELD,
                    NAME_FIELD, OWNER_ACCOUNT_ID_FIELD, PROXY_TYPE_FIELD, STATE_FIELD, TAGS_FIELD, VPC_ID_FIELD));

    private final ApiGatewayProxyConfig apiGatewayProxy;

    private final String applicationId;

    private final String arn;

    private final String createdByAccountId;

    private final Instant createdTime;

    private final String environmentId;

    private final ErrorResponse error;

    private final Instant lastUpdatedTime;

    private final String name;

    private final String ownerAccountId;

    private final String proxyType;

    private final String state;

    private final Map<String, String> tags;

    private final String vpcId;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.apiGatewayProxy = builder.apiGatewayProxy;
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.createdByAccountId = builder.createdByAccountId;
        this.createdTime = builder.createdTime;
        this.environmentId = builder.environmentId;
        this.error = builder.error;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.ownerAccountId = builder.ownerAccountId;
        this.proxyType = builder.proxyType;
        this.state = builder.state;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The endpoint URL of the API Gateway proxy.
     * </p>
     * 
     * @return The endpoint URL of the API Gateway proxy.
     */
    public final ApiGatewayProxyConfig apiGatewayProxy() {
        return apiGatewayProxy;
    }

    /**
     * <p>
     * The unique identifier of the application.
     * </p>
     * 
     * @return The unique identifier of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the application creator.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the application creator.
     */
    public final String createdByAccountId() {
        return createdByAccountId;
    }

    /**
     * <p>
     * A timestamp that indicates when the application is created.
     * </p>
     * 
     * @return A timestamp that indicates when the application is created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The unique identifier of the environment.
     * </p>
     * 
     * @return The unique identifier of the environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * Any error associated with the application resource.
     * </p>
     * 
     * @return Any error associated with the application resource.
     */
    public final ErrorResponse error() {
        return error;
    }

    /**
     * <p>
     * A timestamp that indicates when the application was last updated.
     * </p>
     * 
     * @return A timestamp that indicates when the application was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the application owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the application owner.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The proxy type of the proxy created within the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #proxyType} will
     * return {@link ProxyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #proxyTypeAsString}.
     * </p>
     * 
     * @return The proxy type of the proxy created within the application.
     * @see ProxyType
     */
    public final ProxyType proxyType() {
        return ProxyType.fromValue(proxyType);
    }

    /**
     * <p>
     * The proxy type of the proxy created within the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #proxyType} will
     * return {@link ProxyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #proxyTypeAsString}.
     * </p>
     * 
     * @return The proxy type of the proxy created within the application.
     * @see ProxyType
     */
    public final String proxyTypeAsString() {
        return proxyType;
    }

    /**
     * <p>
     * The current state of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ApplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the application.
     * @see ApplicationState
     */
    public final ApplicationState state() {
        return ApplicationState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ApplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the application.
     * @see ApplicationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each
     * tag consists of a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services
     *         resource. Each tag consists of a key-value pair.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the virtual private cloud (VPC).
     * </p>
     * 
     * @return The ID of the virtual private cloud (VPC).
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiGatewayProxy());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdByAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(proxyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse) obj;
        return Objects.equals(apiGatewayProxy(), other.apiGatewayProxy())
                && Objects.equals(applicationId(), other.applicationId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdByAccountId(), other.createdByAccountId())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(error(), other.error()) && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(name(), other.name()) && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(proxyTypeAsString(), other.proxyTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationResponse").add("ApiGatewayProxy", apiGatewayProxy())
                .add("ApplicationId", applicationId()).add("Arn", arn()).add("CreatedByAccountId", createdByAccountId())
                .add("CreatedTime", createdTime()).add("EnvironmentId", environmentId()).add("Error", error())
                .add("LastUpdatedTime", lastUpdatedTime()).add("Name", name()).add("OwnerAccountId", ownerAccountId())
                .add("ProxyType", proxyTypeAsString()).add("State", stateAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiGatewayProxy":
            return Optional.ofNullable(clazz.cast(apiGatewayProxy()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedByAccountId":
            return Optional.ofNullable(clazz.cast(createdByAccountId()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "ProxyType":
            return Optional.ofNullable(clazz.cast(proxyTypeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRefactorSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationResponse> {
        /**
         * <p>
         * The endpoint URL of the API Gateway proxy.
         * </p>
         * 
         * @param apiGatewayProxy
         *        The endpoint URL of the API Gateway proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiGatewayProxy(ApiGatewayProxyConfig apiGatewayProxy);

        /**
         * <p>
         * The endpoint URL of the API Gateway proxy.
         * </p>
         * This is a convenience that creates an instance of the {@link ApiGatewayProxyConfig.Builder} avoiding the need
         * to create one manually via {@link ApiGatewayProxyConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApiGatewayProxyConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #apiGatewayProxy(ApiGatewayProxyConfig)}.
         * 
         * @param apiGatewayProxy
         *        a consumer that will call methods on {@link ApiGatewayProxyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiGatewayProxy(ApiGatewayProxyConfig)
         */
        default Builder apiGatewayProxy(Consumer<ApiGatewayProxyConfig.Builder> apiGatewayProxy) {
            return apiGatewayProxy(ApiGatewayProxyConfig.builder().applyMutation(apiGatewayProxy).build());
        }

        /**
         * <p>
         * The unique identifier of the application.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Web Services account ID of the application creator.
         * </p>
         * 
         * @param createdByAccountId
         *        The Amazon Web Services account ID of the application creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByAccountId(String createdByAccountId);

        /**
         * <p>
         * A timestamp that indicates when the application is created.
         * </p>
         * 
         * @param createdTime
         *        A timestamp that indicates when the application is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The unique identifier of the environment.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * Any error associated with the application resource.
         * </p>
         * 
         * @param error
         *        Any error associated with the application resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorResponse error);

        /**
         * <p>
         * Any error associated with the application resource.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorResponse.Builder} avoiding the need to
         * create one manually via {@link ErrorResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ErrorResponse)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorResponse)
         */
        default Builder error(Consumer<ErrorResponse.Builder> error) {
            return error(ErrorResponse.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * A timestamp that indicates when the application was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        A timestamp that indicates when the application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param name
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services account ID of the application owner.
         * </p>
         * 
         * @param ownerAccountId
         *        The Amazon Web Services account ID of the application owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The proxy type of the proxy created within the application.
         * </p>
         * 
         * @param proxyType
         *        The proxy type of the proxy created within the application.
         * @see ProxyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyType
         */
        Builder proxyType(String proxyType);

        /**
         * <p>
         * The proxy type of the proxy created within the application.
         * </p>
         * 
         * @param proxyType
         *        The proxy type of the proxy created within the application.
         * @see ProxyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyType
         */
        Builder proxyType(ProxyType proxyType);

        /**
         * <p>
         * The current state of the application.
         * </p>
         * 
         * @param state
         *        The current state of the application.
         * @see ApplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the application.
         * </p>
         * 
         * @param state
         *        The current state of the application.
         * @see ApplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationState
         */
        Builder state(ApplicationState state);

        /**
         * <p>
         * The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource.
         * Each tag consists of a key-value pair.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services
         *        resource. Each tag consists of a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The ID of the virtual private cloud (VPC).
         * </p>
         * 
         * @param vpcId
         *        The ID of the virtual private cloud (VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl extends MigrationHubRefactorSpacesResponse.BuilderImpl implements Builder {
        private ApiGatewayProxyConfig apiGatewayProxy;

        private String applicationId;

        private String arn;

        private String createdByAccountId;

        private Instant createdTime;

        private String environmentId;

        private ErrorResponse error;

        private Instant lastUpdatedTime;

        private String name;

        private String ownerAccountId;

        private String proxyType;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            apiGatewayProxy(model.apiGatewayProxy);
            applicationId(model.applicationId);
            arn(model.arn);
            createdByAccountId(model.createdByAccountId);
            createdTime(model.createdTime);
            environmentId(model.environmentId);
            error(model.error);
            lastUpdatedTime(model.lastUpdatedTime);
            name(model.name);
            ownerAccountId(model.ownerAccountId);
            proxyType(model.proxyType);
            state(model.state);
            tags(model.tags);
            vpcId(model.vpcId);
        }

        public final ApiGatewayProxyConfig.Builder getApiGatewayProxy() {
            return apiGatewayProxy != null ? apiGatewayProxy.toBuilder() : null;
        }

        public final void setApiGatewayProxy(ApiGatewayProxyConfig.BuilderImpl apiGatewayProxy) {
            this.apiGatewayProxy = apiGatewayProxy != null ? apiGatewayProxy.build() : null;
        }

        @Override
        @Transient
        public final Builder apiGatewayProxy(ApiGatewayProxyConfig apiGatewayProxy) {
            this.apiGatewayProxy = apiGatewayProxy;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedByAccountId() {
            return createdByAccountId;
        }

        public final void setCreatedByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
        }

        @Override
        @Transient
        public final Builder createdByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        @Transient
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final ErrorResponse.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorResponse.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        @Transient
        public final Builder error(ErrorResponse error) {
            this.error = error;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        @Transient
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getProxyType() {
            return proxyType;
        }

        public final void setProxyType(String proxyType) {
            this.proxyType = proxyType;
        }

        @Override
        @Transient
        public final Builder proxyType(String proxyType) {
            this.proxyType = proxyType;
            return this;
        }

        @Override
        @Transient
        public final Builder proxyType(ProxyType proxyType) {
            this.proxyType(proxyType == null ? null : proxyType.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ApplicationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
