/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentVpcsResponse extends MigrationHubRefactorSpacesResponse implements
        ToCopyableBuilder<ListEnvironmentVpcsResponse.Builder, ListEnvironmentVpcsResponse> {
    private static final SdkField<List<EnvironmentVpc>> ENVIRONMENT_VPC_LIST_FIELD = SdkField
            .<List<EnvironmentVpc>> builder(MarshallingType.LIST)
            .memberName("EnvironmentVpcList")
            .getter(getter(ListEnvironmentVpcsResponse::environmentVpcList))
            .setter(setter(Builder::environmentVpcList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentVpcList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentVpc> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentVpc::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEnvironmentVpcsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_VPC_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EnvironmentVpc> environmentVpcList;

    private final String nextToken;

    private ListEnvironmentVpcsResponse(BuilderImpl builder) {
        super(builder);
        this.environmentVpcList = builder.environmentVpcList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVpcList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVpcList() {
        return environmentVpcList != null && !(environmentVpcList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>EnvironmentVpc</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVpcList} method.
     * </p>
     * 
     * @return The list of <code>EnvironmentVpc</code> objects.
     */
    public final List<EnvironmentVpc> environmentVpcList() {
        return environmentVpcList;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVpcList() ? environmentVpcList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentVpcsResponse)) {
            return false;
        }
        ListEnvironmentVpcsResponse other = (ListEnvironmentVpcsResponse) obj;
        return hasEnvironmentVpcList() == other.hasEnvironmentVpcList()
                && Objects.equals(environmentVpcList(), other.environmentVpcList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentVpcsResponse")
                .add("EnvironmentVpcList", hasEnvironmentVpcList() ? environmentVpcList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentVpcList":
            return Optional.ofNullable(clazz.cast(environmentVpcList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentVpcsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentVpcsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRefactorSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEnvironmentVpcsResponse> {
        /**
         * <p>
         * The list of <code>EnvironmentVpc</code> objects.
         * </p>
         * 
         * @param environmentVpcList
         *        The list of <code>EnvironmentVpc</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVpcList(Collection<EnvironmentVpc> environmentVpcList);

        /**
         * <p>
         * The list of <code>EnvironmentVpc</code> objects.
         * </p>
         * 
         * @param environmentVpcList
         *        The list of <code>EnvironmentVpc</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVpcList(EnvironmentVpc... environmentVpcList);

        /**
         * <p>
         * The list of <code>EnvironmentVpc</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnvironmentVpc>.Builder} avoiding the need
         * to create one manually via {@link List<EnvironmentVpc>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentVpc>.Builder#build()} is called immediately and
         * its result is passed to {@link #environmentVpcList(List<EnvironmentVpc>)}.
         * 
         * @param environmentVpcList
         *        a consumer that will call methods on {@link List<EnvironmentVpc>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentVpcList(List<EnvironmentVpc>)
         */
        Builder environmentVpcList(Consumer<EnvironmentVpc.Builder>... environmentVpcList);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MigrationHubRefactorSpacesResponse.BuilderImpl implements Builder {
        private List<EnvironmentVpc> environmentVpcList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentVpcsResponse model) {
            super(model);
            environmentVpcList(model.environmentVpcList);
            nextToken(model.nextToken);
        }

        public final List<EnvironmentVpc.Builder> getEnvironmentVpcList() {
            List<EnvironmentVpc.Builder> result = EnvironmentVpcsCopier.copyToBuilder(this.environmentVpcList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentVpcList(Collection<EnvironmentVpc.BuilderImpl> environmentVpcList) {
            this.environmentVpcList = EnvironmentVpcsCopier.copyFromBuilder(environmentVpcList);
        }

        @Override
        @Transient
        public final Builder environmentVpcList(Collection<EnvironmentVpc> environmentVpcList) {
            this.environmentVpcList = EnvironmentVpcsCopier.copy(environmentVpcList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environmentVpcList(EnvironmentVpc... environmentVpcList) {
            environmentVpcList(Arrays.asList(environmentVpcList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environmentVpcList(Consumer<EnvironmentVpc.Builder>... environmentVpcList) {
            environmentVpcList(Stream.of(environmentVpcList).map(c -> EnvironmentVpc.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnvironmentVpcsResponse build() {
            return new ListEnvironmentVpcsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
