/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentsResponse extends MigrationHubRefactorSpacesResponse implements
        ToCopyableBuilder<ListEnvironmentsResponse.Builder, ListEnvironmentsResponse> {
    private static final SdkField<List<EnvironmentSummary>> ENVIRONMENT_SUMMARY_LIST_FIELD = SdkField
            .<List<EnvironmentSummary>> builder(MarshallingType.LIST)
            .memberName("EnvironmentSummaryList")
            .getter(getter(ListEnvironmentsResponse::environmentSummaryList))
            .setter(setter(Builder::environmentSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEnvironmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENVIRONMENT_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<EnvironmentSummary> environmentSummaryList;

    private final String nextToken;

    private ListEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environmentSummaryList = builder.environmentSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnvironmentSummaryList() {
        return environmentSummaryList != null && !(environmentSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>EnvironmentSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentSummaryList} method.
     * </p>
     * 
     * @return The list of <code>EnvironmentSummary</code> objects.
     */
    public final List<EnvironmentSummary> environmentSummaryList() {
        return environmentSummaryList;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentSummaryList() ? environmentSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsResponse)) {
            return false;
        }
        ListEnvironmentsResponse other = (ListEnvironmentsResponse) obj;
        return hasEnvironmentSummaryList() == other.hasEnvironmentSummaryList()
                && Objects.equals(environmentSummaryList(), other.environmentSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentsResponse")
                .add("EnvironmentSummaryList", hasEnvironmentSummaryList() ? environmentSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentSummaryList":
            return Optional.ofNullable(clazz.cast(environmentSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRefactorSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEnvironmentsResponse> {
        /**
         * <p>
         * The list of <code>EnvironmentSummary</code> objects.
         * </p>
         * 
         * @param environmentSummaryList
         *        The list of <code>EnvironmentSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentSummaryList(Collection<EnvironmentSummary> environmentSummaryList);

        /**
         * <p>
         * The list of <code>EnvironmentSummary</code> objects.
         * </p>
         * 
         * @param environmentSummaryList
         *        The list of <code>EnvironmentSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentSummaryList(EnvironmentSummary... environmentSummaryList);

        /**
         * <p>
         * The list of <code>EnvironmentSummary</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnvironmentSummary>.Builder} avoiding the
         * need to create one manually via {@link List<EnvironmentSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentSummaryList(List<EnvironmentSummary>)}.
         * 
         * @param environmentSummaryList
         *        a consumer that will call methods on {@link List<EnvironmentSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentSummaryList(List<EnvironmentSummary>)
         */
        Builder environmentSummaryList(Consumer<EnvironmentSummary.Builder>... environmentSummaryList);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MigrationHubRefactorSpacesResponse.BuilderImpl implements Builder {
        private List<EnvironmentSummary> environmentSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsResponse model) {
            super(model);
            environmentSummaryList(model.environmentSummaryList);
            nextToken(model.nextToken);
        }

        public final List<EnvironmentSummary.Builder> getEnvironmentSummaryList() {
            List<EnvironmentSummary.Builder> result = EnvironmentSummariesCopier.copyToBuilder(this.environmentSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentSummaryList(Collection<EnvironmentSummary.BuilderImpl> environmentSummaryList) {
            this.environmentSummaryList = EnvironmentSummariesCopier.copyFromBuilder(environmentSummaryList);
        }

        @Override
        @Transient
        public final Builder environmentSummaryList(Collection<EnvironmentSummary> environmentSummaryList) {
            this.environmentSummaryList = EnvironmentSummariesCopier.copy(environmentSummaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environmentSummaryList(EnvironmentSummary... environmentSummaryList) {
            environmentSummaryList(Arrays.asList(environmentSummaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environmentSummaryList(Consumer<EnvironmentSummary.Builder>... environmentSummaryList) {
            environmentSummaryList(Stream.of(environmentSummaryList)
                    .map(c -> EnvironmentSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnvironmentsResponse build() {
            return new ListEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
