/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary information for the routes as a response to <code>ListRoutes</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteSummary implements SdkPojo, Serializable, ToCopyableBuilder<RouteSummary.Builder, RouteSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(RouteSummary::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RouteSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATED_BY_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedByAccountId").getter(getter(RouteSummary::createdByAccountId))
            .setter(setter(Builder::createdByAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByAccountId").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(RouteSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(RouteSummary::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<ErrorResponse> ERROR_FIELD = SdkField.<ErrorResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(RouteSummary::error)).setter(setter(Builder::error))
            .constructor(ErrorResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<Boolean> INCLUDE_CHILD_PATHS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeChildPaths").getter(getter(RouteSummary::includeChildPaths))
            .setter(setter(Builder::includeChildPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeChildPaths").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(RouteSummary::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<List<String>> METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Methods")
            .getter(getter(RouteSummary::methodsAsStrings))
            .setter(setter(Builder::methodsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Methods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(RouteSummary::ownerAccountId)).setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<Map<String, String>> PATH_RESOURCE_TO_ID_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("PathResourceToId")
            .getter(getter(RouteSummary::pathResourceToId))
            .setter(setter(Builder::pathResourceToId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathResourceToId").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteId").getter(getter(RouteSummary::routeId)).setter(setter(Builder::routeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteId").build()).build();

    private static final SdkField<String> ROUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteType").getter(getter(RouteSummary::routeTypeAsString)).setter(setter(Builder::routeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteType").build()).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceId").getter(getter(RouteSummary::serviceId)).setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()).build();

    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePath").getter(getter(RouteSummary::sourcePath)).setter(setter(Builder::sourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(RouteSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(RouteSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ARN_FIELD, CREATED_BY_ACCOUNT_ID_FIELD, CREATED_TIME_FIELD, ENVIRONMENT_ID_FIELD, ERROR_FIELD,
            INCLUDE_CHILD_PATHS_FIELD, LAST_UPDATED_TIME_FIELD, METHODS_FIELD, OWNER_ACCOUNT_ID_FIELD, PATH_RESOURCE_TO_ID_FIELD,
            ROUTE_ID_FIELD, ROUTE_TYPE_FIELD, SERVICE_ID_FIELD, SOURCE_PATH_FIELD, STATE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String arn;

    private final String createdByAccountId;

    private final Instant createdTime;

    private final String environmentId;

    private final ErrorResponse error;

    private final Boolean includeChildPaths;

    private final Instant lastUpdatedTime;

    private final List<String> methods;

    private final String ownerAccountId;

    private final Map<String, String> pathResourceToId;

    private final String routeId;

    private final String routeType;

    private final String serviceId;

    private final String sourcePath;

    private final String state;

    private final Map<String, String> tags;

    private RouteSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.createdByAccountId = builder.createdByAccountId;
        this.createdTime = builder.createdTime;
        this.environmentId = builder.environmentId;
        this.error = builder.error;
        this.includeChildPaths = builder.includeChildPaths;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.methods = builder.methods;
        this.ownerAccountId = builder.ownerAccountId;
        this.pathResourceToId = builder.pathResourceToId;
        this.routeId = builder.routeId;
        this.routeType = builder.routeType;
        this.serviceId = builder.serviceId;
        this.sourcePath = builder.sourcePath;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the application.
     * </p>
     * 
     * @return The unique identifier of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the route.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the route.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the route creator.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the route creator.
     */
    public final String createdByAccountId() {
        return createdByAccountId;
    }

    /**
     * <p>
     * A timestamp that indicates when the route is created.
     * </p>
     * 
     * @return A timestamp that indicates when the route is created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The unique identifier of the environment.
     * </p>
     * 
     * @return The unique identifier of the environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * Any error associated with the route resource.
     * </p>
     * 
     * @return Any error associated with the route resource.
     */
    public final ErrorResponse error() {
        return error;
    }

    /**
     * <p>
     * Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests
     * must match the source path exactly before they are forwarded to this route's service.
     * </p>
     * 
     * @return Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>,
     *         requests must match the source path exactly before they are forwarded to this route's service.
     */
    public final Boolean includeChildPaths() {
        return includeChildPaths;
    }

    /**
     * <p>
     * A timestamp that indicates when the route was last updated.
     * </p>
     * 
     * @return A timestamp that indicates when the route was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
     * using that method are forwarded to this route’s service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMethods} method.
     * </p>
     * 
     * @return A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
     *         requests using that method are forwarded to this route’s service.
     */
    public final List<HttpMethod> methods() {
        return HttpMethodsCopier.copyStringToEnum(methods);
    }

    /**
     * For responses, this returns true if the service returned a value for the Methods property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMethods() {
        return methods != null && !(methods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
     * using that method are forwarded to this route’s service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMethods} method.
     * </p>
     * 
     * @return A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
     *         requests using that method are forwarded to this route’s service.
     */
    public final List<String> methodsAsStrings() {
        return methods;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the route owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the route owner.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PathResourceToId property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPathResourceToId() {
        return pathResourceToId != null && !(pathResourceToId instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping of Amazon API Gateway path resources to resource IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPathResourceToId} method.
     * </p>
     * 
     * @return A mapping of Amazon API Gateway path resources to resource IDs.
     */
    public final Map<String, String> pathResourceToId() {
        return pathResourceToId;
    }

    /**
     * <p>
     * The unique identifier of the route.
     * </p>
     * 
     * @return The unique identifier of the route.
     */
    public final String routeId() {
        return routeId;
    }

    /**
     * <p>
     * The route type of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routeType} will
     * return {@link RouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routeTypeAsString}.
     * </p>
     * 
     * @return The route type of the route.
     * @see RouteType
     */
    public final RouteType routeType() {
        return RouteType.fromValue(routeType);
    }

    /**
     * <p>
     * The route type of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routeType} will
     * return {@link RouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routeTypeAsString}.
     * </p>
     * 
     * @return The route type of the route.
     * @see RouteType
     */
    public final String routeTypeAsString() {
        return routeType;
    }

    /**
     * <p>
     * The unique identifier of the service.
     * </p>
     * 
     * @return The unique identifier of the service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the
     * application.
     * </p>
     * 
     * @return The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of
     *         the application.
     */
    public final String sourcePath() {
        return sourcePath;
    }

    /**
     * <p>
     * The current state of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the route.
     * @see RouteState
     */
    public final RouteState state() {
        return RouteState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the route.
     * @see RouteState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the route.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdByAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(includeChildPaths());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasMethods() ? methodsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPathResourceToId() ? pathResourceToId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routeId());
        hashCode = 31 * hashCode + Objects.hashCode(routeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSummary)) {
            return false;
        }
        RouteSummary other = (RouteSummary) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdByAccountId(), other.createdByAccountId())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(error(), other.error()) && Objects.equals(includeChildPaths(), other.includeChildPaths())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && hasMethods() == other.hasMethods()
                && Objects.equals(methodsAsStrings(), other.methodsAsStrings())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && hasPathResourceToId() == other.hasPathResourceToId()
                && Objects.equals(pathResourceToId(), other.pathResourceToId()) && Objects.equals(routeId(), other.routeId())
                && Objects.equals(routeTypeAsString(), other.routeTypeAsString())
                && Objects.equals(serviceId(), other.serviceId()) && Objects.equals(sourcePath(), other.sourcePath())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteSummary").add("ApplicationId", applicationId()).add("Arn", arn())
                .add("CreatedByAccountId", createdByAccountId()).add("CreatedTime", createdTime())
                .add("EnvironmentId", environmentId()).add("Error", error()).add("IncludeChildPaths", includeChildPaths())
                .add("LastUpdatedTime", lastUpdatedTime()).add("Methods", hasMethods() ? methodsAsStrings() : null)
                .add("OwnerAccountId", ownerAccountId())
                .add("PathResourceToId", hasPathResourceToId() ? pathResourceToId() : null).add("RouteId", routeId())
                .add("RouteType", routeTypeAsString()).add("ServiceId", serviceId()).add("SourcePath", sourcePath())
                .add("State", stateAsString()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedByAccountId":
            return Optional.ofNullable(clazz.cast(createdByAccountId()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "IncludeChildPaths":
            return Optional.ofNullable(clazz.cast(includeChildPaths()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Methods":
            return Optional.ofNullable(clazz.cast(methodsAsStrings()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "PathResourceToId":
            return Optional.ofNullable(clazz.cast(pathResourceToId()));
        case "RouteId":
            return Optional.ofNullable(clazz.cast(routeId()));
        case "RouteType":
            return Optional.ofNullable(clazz.cast(routeTypeAsString()));
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "SourcePath":
            return Optional.ofNullable(clazz.cast(sourcePath()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteSummary, T> g) {
        return obj -> g.apply((RouteSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteSummary> {
        /**
         * <p>
         * The unique identifier of the application.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the route.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Web Services account ID of the route creator.
         * </p>
         * 
         * @param createdByAccountId
         *        The Amazon Web Services account ID of the route creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByAccountId(String createdByAccountId);

        /**
         * <p>
         * A timestamp that indicates when the route is created.
         * </p>
         * 
         * @param createdTime
         *        A timestamp that indicates when the route is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The unique identifier of the environment.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * Any error associated with the route resource.
         * </p>
         * 
         * @param error
         *        Any error associated with the route resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorResponse error);

        /**
         * <p>
         * Any error associated with the route resource.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorResponse.Builder} avoiding the need to
         * create one manually via {@link ErrorResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ErrorResponse)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorResponse)
         */
        default Builder error(Consumer<ErrorResponse.Builder> error) {
            return error(ErrorResponse.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>,
         * requests must match the source path exactly before they are forwarded to this route's service.
         * </p>
         * 
         * @param includeChildPaths
         *        Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>,
         *        requests must match the source path exactly before they are forwarded to this route's service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeChildPaths(Boolean includeChildPaths);

        /**
         * <p>
         * A timestamp that indicates when the route was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        A timestamp that indicates when the route was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
         * using that method are forwarded to this route’s service.
         * </p>
         * 
         * @param methods
         *        A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
         *        requests using that method are forwarded to this route’s service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methodsWithStrings(Collection<String> methods);

        /**
         * <p>
         * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
         * using that method are forwarded to this route’s service.
         * </p>
         * 
         * @param methods
         *        A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
         *        requests using that method are forwarded to this route’s service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methodsWithStrings(String... methods);

        /**
         * <p>
         * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
         * using that method are forwarded to this route’s service.
         * </p>
         * 
         * @param methods
         *        A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
         *        requests using that method are forwarded to this route’s service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methods(Collection<HttpMethod> methods);

        /**
         * <p>
         * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
         * using that method are forwarded to this route’s service.
         * </p>
         * 
         * @param methods
         *        A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
         *        requests using that method are forwarded to this route’s service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methods(HttpMethod... methods);

        /**
         * <p>
         * The Amazon Web Services account ID of the route owner.
         * </p>
         * 
         * @param ownerAccountId
         *        The Amazon Web Services account ID of the route owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * A mapping of Amazon API Gateway path resources to resource IDs.
         * </p>
         * 
         * @param pathResourceToId
         *        A mapping of Amazon API Gateway path resources to resource IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathResourceToId(Map<String, String> pathResourceToId);

        /**
         * <p>
         * The unique identifier of the route.
         * </p>
         * 
         * @param routeId
         *        The unique identifier of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeId(String routeId);

        /**
         * <p>
         * The route type of the route.
         * </p>
         * 
         * @param routeType
         *        The route type of the route.
         * @see RouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteType
         */
        Builder routeType(String routeType);

        /**
         * <p>
         * The route type of the route.
         * </p>
         * 
         * @param routeType
         *        The route type of the route.
         * @see RouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteType
         */
        Builder routeType(RouteType routeType);

        /**
         * <p>
         * The unique identifier of the service.
         * </p>
         * 
         * @param serviceId
         *        The unique identifier of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the
         * application.
         * </p>
         * 
         * @param sourcePath
         *        The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of
         *        the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String sourcePath);

        /**
         * <p>
         * The current state of the route.
         * </p>
         * 
         * @param state
         *        The current state of the route.
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the route.
         * </p>
         * 
         * @param state
         *        The current state of the route.
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(RouteState state);

        /**
         * <p>
         * The tags assigned to the route.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String arn;

        private String createdByAccountId;

        private Instant createdTime;

        private String environmentId;

        private ErrorResponse error;

        private Boolean includeChildPaths;

        private Instant lastUpdatedTime;

        private List<String> methods = DefaultSdkAutoConstructList.getInstance();

        private String ownerAccountId;

        private Map<String, String> pathResourceToId = DefaultSdkAutoConstructMap.getInstance();

        private String routeId;

        private String routeType;

        private String serviceId;

        private String sourcePath;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSummary model) {
            applicationId(model.applicationId);
            arn(model.arn);
            createdByAccountId(model.createdByAccountId);
            createdTime(model.createdTime);
            environmentId(model.environmentId);
            error(model.error);
            includeChildPaths(model.includeChildPaths);
            lastUpdatedTime(model.lastUpdatedTime);
            methodsWithStrings(model.methods);
            ownerAccountId(model.ownerAccountId);
            pathResourceToId(model.pathResourceToId);
            routeId(model.routeId);
            routeType(model.routeType);
            serviceId(model.serviceId);
            sourcePath(model.sourcePath);
            state(model.state);
            tags(model.tags);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedByAccountId() {
            return createdByAccountId;
        }

        public final void setCreatedByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
        }

        @Override
        @Transient
        public final Builder createdByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        @Transient
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final ErrorResponse.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorResponse.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        @Transient
        public final Builder error(ErrorResponse error) {
            this.error = error;
            return this;
        }

        public final Boolean getIncludeChildPaths() {
            return includeChildPaths;
        }

        public final void setIncludeChildPaths(Boolean includeChildPaths) {
            this.includeChildPaths = includeChildPaths;
        }

        @Override
        @Transient
        public final Builder includeChildPaths(Boolean includeChildPaths) {
            this.includeChildPaths = includeChildPaths;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Collection<String> getMethods() {
            if (methods instanceof SdkAutoConstructList) {
                return null;
            }
            return methods;
        }

        public final void setMethods(Collection<String> methods) {
            this.methods = HttpMethodsCopier.copy(methods);
        }

        @Override
        @Transient
        public final Builder methodsWithStrings(Collection<String> methods) {
            this.methods = HttpMethodsCopier.copy(methods);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder methodsWithStrings(String... methods) {
            methodsWithStrings(Arrays.asList(methods));
            return this;
        }

        @Override
        @Transient
        public final Builder methods(Collection<HttpMethod> methods) {
            this.methods = HttpMethodsCopier.copyEnumToString(methods);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder methods(HttpMethod... methods) {
            methods(Arrays.asList(methods));
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        @Transient
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final Map<String, String> getPathResourceToId() {
            if (pathResourceToId instanceof SdkAutoConstructMap) {
                return null;
            }
            return pathResourceToId;
        }

        public final void setPathResourceToId(Map<String, String> pathResourceToId) {
            this.pathResourceToId = PathResourceToIdCopier.copy(pathResourceToId);
        }

        @Override
        @Transient
        public final Builder pathResourceToId(Map<String, String> pathResourceToId) {
            this.pathResourceToId = PathResourceToIdCopier.copy(pathResourceToId);
            return this;
        }

        public final String getRouteId() {
            return routeId;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        @Transient
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final String getRouteType() {
            return routeType;
        }

        public final void setRouteType(String routeType) {
            this.routeType = routeType;
        }

        @Override
        @Transient
        public final Builder routeType(String routeType) {
            this.routeType = routeType;
            return this;
        }

        @Override
        @Transient
        public final Builder routeType(RouteType routeType) {
            this.routeType(routeType == null ? null : routeType.toString());
            return this;
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        @Transient
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getSourcePath() {
            return sourcePath;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        @Transient
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(RouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public RouteSummary build() {
            return new RouteSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
