/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the URI path route type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UriPathRouteInput implements SdkPojo, Serializable,
        ToCopyableBuilder<UriPathRouteInput.Builder, UriPathRouteInput> {
    private static final SdkField<String> ACTIVATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationState").getter(getter(UriPathRouteInput::activationStateAsString))
            .setter(setter(Builder::activationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationState").build()).build();

    private static final SdkField<Boolean> INCLUDE_CHILD_PATHS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeChildPaths").getter(getter(UriPathRouteInput::includeChildPaths))
            .setter(setter(Builder::includeChildPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeChildPaths").build()).build();

    private static final SdkField<List<String>> METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Methods")
            .getter(getter(UriPathRouteInput::methodsAsStrings))
            .setter(setter(Builder::methodsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Methods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePath").getter(getter(UriPathRouteInput::sourcePath)).setter(setter(Builder::sourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_STATE_FIELD,
            INCLUDE_CHILD_PATHS_FIELD, METHODS_FIELD, SOURCE_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activationState;

    private final Boolean includeChildPaths;

    private final List<String> methods;

    private final String sourcePath;

    private UriPathRouteInput(BuilderImpl builder) {
        this.activationState = builder.activationState;
        this.includeChildPaths = builder.includeChildPaths;
        this.methods = builder.methods;
        this.sourcePath = builder.sourcePath;
    }

    /**
     * <p>
     * Indicates whether traffic is forwarded to this route’s service after the route is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationState}
     * will return {@link RouteActivationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #activationStateAsString}.
     * </p>
     * 
     * @return Indicates whether traffic is forwarded to this route’s service after the route is created.
     * @see RouteActivationState
     */
    public final RouteActivationState activationState() {
        return RouteActivationState.fromValue(activationState);
    }

    /**
     * <p>
     * Indicates whether traffic is forwarded to this route’s service after the route is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationState}
     * will return {@link RouteActivationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #activationStateAsString}.
     * </p>
     * 
     * @return Indicates whether traffic is forwarded to this route’s service after the route is created.
     * @see RouteActivationState
     */
    public final String activationStateAsString() {
        return activationState;
    }

    /**
     * <p>
     * Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests
     * must match the source path exactly before they are forwarded to this route's service.
     * </p>
     * 
     * @return Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>,
     *         requests must match the source path exactly before they are forwarded to this route's service.
     */
    public final Boolean includeChildPaths() {
        return includeChildPaths;
    }

    /**
     * <p>
     * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
     * using that method are forwarded to this route’s service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMethods} method.
     * </p>
     * 
     * @return A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
     *         requests using that method are forwarded to this route’s service.
     */
    public final List<HttpMethod> methods() {
        return HttpMethodsCopier.copyStringToEnum(methods);
    }

    /**
     * For responses, this returns true if the service returned a value for the Methods property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMethods() {
        return methods != null && !(methods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
     * using that method are forwarded to this route’s service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMethods} method.
     * </p>
     * 
     * @return A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
     *         requests using that method are forwarded to this route’s service.
     */
    public final List<String> methodsAsStrings() {
        return methods;
    }

    /**
     * <p>
     * The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the
     * application.
     * </p>
     * 
     * @return The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of
     *         the application.
     */
    public final String sourcePath() {
        return sourcePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeChildPaths());
        hashCode = 31 * hashCode + Objects.hashCode(hasMethods() ? methodsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourcePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UriPathRouteInput)) {
            return false;
        }
        UriPathRouteInput other = (UriPathRouteInput) obj;
        return Objects.equals(activationStateAsString(), other.activationStateAsString())
                && Objects.equals(includeChildPaths(), other.includeChildPaths()) && hasMethods() == other.hasMethods()
                && Objects.equals(methodsAsStrings(), other.methodsAsStrings())
                && Objects.equals(sourcePath(), other.sourcePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UriPathRouteInput").add("ActivationState", activationStateAsString())
                .add("IncludeChildPaths", includeChildPaths()).add("Methods", hasMethods() ? methodsAsStrings() : null)
                .add("SourcePath", sourcePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationState":
            return Optional.ofNullable(clazz.cast(activationStateAsString()));
        case "IncludeChildPaths":
            return Optional.ofNullable(clazz.cast(includeChildPaths()));
        case "Methods":
            return Optional.ofNullable(clazz.cast(methodsAsStrings()));
        case "SourcePath":
            return Optional.ofNullable(clazz.cast(sourcePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UriPathRouteInput, T> g) {
        return obj -> g.apply((UriPathRouteInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UriPathRouteInput> {
        /**
         * <p>
         * Indicates whether traffic is forwarded to this route’s service after the route is created.
         * </p>
         * 
         * @param activationState
         *        Indicates whether traffic is forwarded to this route’s service after the route is created.
         * @see RouteActivationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteActivationState
         */
        Builder activationState(String activationState);

        /**
         * <p>
         * Indicates whether traffic is forwarded to this route’s service after the route is created.
         * </p>
         * 
         * @param activationState
         *        Indicates whether traffic is forwarded to this route’s service after the route is created.
         * @see RouteActivationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteActivationState
         */
        Builder activationState(RouteActivationState activationState);

        /**
         * <p>
         * Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>,
         * requests must match the source path exactly before they are forwarded to this route's service.
         * </p>
         * 
         * @param includeChildPaths
         *        Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>,
         *        requests must match the source path exactly before they are forwarded to this route's service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeChildPaths(Boolean includeChildPaths);

        /**
         * <p>
         * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
         * using that method are forwarded to this route’s service.
         * </p>
         * 
         * @param methods
         *        A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
         *        requests using that method are forwarded to this route’s service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methodsWithStrings(Collection<String> methods);

        /**
         * <p>
         * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
         * using that method are forwarded to this route’s service.
         * </p>
         * 
         * @param methods
         *        A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
         *        requests using that method are forwarded to this route’s service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methodsWithStrings(String... methods);

        /**
         * <p>
         * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
         * using that method are forwarded to this route’s service.
         * </p>
         * 
         * @param methods
         *        A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
         *        requests using that method are forwarded to this route’s service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methods(Collection<HttpMethod> methods);

        /**
         * <p>
         * A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests
         * using that method are forwarded to this route’s service.
         * </p>
         * 
         * @param methods
         *        A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP
         *        requests using that method are forwarded to this route’s service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methods(HttpMethod... methods);

        /**
         * <p>
         * The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the
         * application.
         * </p>
         * 
         * @param sourcePath
         *        The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of
         *        the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String sourcePath);
    }

    static final class BuilderImpl implements Builder {
        private String activationState;

        private Boolean includeChildPaths;

        private List<String> methods = DefaultSdkAutoConstructList.getInstance();

        private String sourcePath;

        private BuilderImpl() {
        }

        private BuilderImpl(UriPathRouteInput model) {
            activationState(model.activationState);
            includeChildPaths(model.includeChildPaths);
            methodsWithStrings(model.methods);
            sourcePath(model.sourcePath);
        }

        public final String getActivationState() {
            return activationState;
        }

        public final void setActivationState(String activationState) {
            this.activationState = activationState;
        }

        @Override
        @Transient
        public final Builder activationState(String activationState) {
            this.activationState = activationState;
            return this;
        }

        @Override
        @Transient
        public final Builder activationState(RouteActivationState activationState) {
            this.activationState(activationState == null ? null : activationState.toString());
            return this;
        }

        public final Boolean getIncludeChildPaths() {
            return includeChildPaths;
        }

        public final void setIncludeChildPaths(Boolean includeChildPaths) {
            this.includeChildPaths = includeChildPaths;
        }

        @Override
        @Transient
        public final Builder includeChildPaths(Boolean includeChildPaths) {
            this.includeChildPaths = includeChildPaths;
            return this;
        }

        public final Collection<String> getMethods() {
            if (methods instanceof SdkAutoConstructList) {
                return null;
            }
            return methods;
        }

        public final void setMethods(Collection<String> methods) {
            this.methods = HttpMethodsCopier.copy(methods);
        }

        @Override
        @Transient
        public final Builder methodsWithStrings(Collection<String> methods) {
            this.methods = HttpMethodsCopier.copy(methods);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder methodsWithStrings(String... methods) {
            methodsWithStrings(Arrays.asList(methods));
            return this;
        }

        @Override
        @Transient
        public final Builder methods(Collection<HttpMethod> methods) {
            this.methods = HttpMethodsCopier.copyEnumToString(methods);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder methods(HttpMethod... methods) {
            methods(Arrays.asList(methods));
            return this;
        }

        public final String getSourcePath() {
            return sourcePath;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        @Transient
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        @Override
        public UriPathRouteInput build() {
            return new UriPathRouteInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
