/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorResponse;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointConfig;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesResponse;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagMapCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceResponse
extends MigrationHubRefactorSpacesResponse
implements ToCopyableBuilder<Builder, GetServiceResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(GetServiceResponse.getter(GetServiceResponse::applicationId)).setter(GetServiceResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetServiceResponse.getter(GetServiceResponse::arn)).setter(GetServiceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATED_BY_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedByAccountId").getter(GetServiceResponse.getter(GetServiceResponse::createdByAccountId)).setter(GetServiceResponse.setter(Builder::createdByAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByAccountId").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(GetServiceResponse.getter(GetServiceResponse::createdTime)).setter(GetServiceResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetServiceResponse.getter(GetServiceResponse::description)).setter(GetServiceResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(GetServiceResponse.getter(GetServiceResponse::endpointTypeAsString)).setter(GetServiceResponse.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(GetServiceResponse.getter(GetServiceResponse::environmentId)).setter(GetServiceResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<ErrorResponse> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(GetServiceResponse.getter(GetServiceResponse::error)).setter(GetServiceResponse.setter(Builder::error)).constructor(ErrorResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<LambdaEndpointConfig> LAMBDA_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaEndpoint").getter(GetServiceResponse.getter(GetServiceResponse::lambdaEndpoint)).setter(GetServiceResponse.setter(Builder::lambdaEndpoint)).constructor(LambdaEndpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaEndpoint").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(GetServiceResponse.getter(GetServiceResponse::lastUpdatedTime)).setter(GetServiceResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetServiceResponse.getter(GetServiceResponse::name)).setter(GetServiceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(GetServiceResponse.getter(GetServiceResponse::ownerAccountId)).setter(GetServiceResponse.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(GetServiceResponse.getter(GetServiceResponse::serviceId)).setter(GetServiceResponse.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetServiceResponse.getter(GetServiceResponse::stateAsString)).setter(GetServiceResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetServiceResponse.getter(GetServiceResponse::tags)).setter(GetServiceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<UrlEndpointConfig> URL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UrlEndpoint").getter(GetServiceResponse.getter(GetServiceResponse::urlEndpoint)).setter(GetServiceResponse.setter(Builder::urlEndpoint)).constructor(UrlEndpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlEndpoint").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(GetServiceResponse.getter(GetServiceResponse::vpcId)).setter(GetServiceResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ARN_FIELD, CREATED_BY_ACCOUNT_ID_FIELD, CREATED_TIME_FIELD, DESCRIPTION_FIELD, ENDPOINT_TYPE_FIELD, ENVIRONMENT_ID_FIELD, ERROR_FIELD, LAMBDA_ENDPOINT_FIELD, LAST_UPDATED_TIME_FIELD, NAME_FIELD, OWNER_ACCOUNT_ID_FIELD, SERVICE_ID_FIELD, STATE_FIELD, TAGS_FIELD, URL_ENDPOINT_FIELD, VPC_ID_FIELD));
    private final String applicationId;
    private final String arn;
    private final String createdByAccountId;
    private final Instant createdTime;
    private final String description;
    private final String endpointType;
    private final String environmentId;
    private final ErrorResponse error;
    private final LambdaEndpointConfig lambdaEndpoint;
    private final Instant lastUpdatedTime;
    private final String name;
    private final String ownerAccountId;
    private final String serviceId;
    private final String state;
    private final Map<String, String> tags;
    private final UrlEndpointConfig urlEndpoint;
    private final String vpcId;

    private GetServiceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.createdByAccountId = builder.createdByAccountId;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.endpointType = builder.endpointType;
        this.environmentId = builder.environmentId;
        this.error = builder.error;
        this.lambdaEndpoint = builder.lambdaEndpoint;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.ownerAccountId = builder.ownerAccountId;
        this.serviceId = builder.serviceId;
        this.state = builder.state;
        this.tags = builder.tags;
        this.urlEndpoint = builder.urlEndpoint;
        this.vpcId = builder.vpcId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdByAccountId() {
        return this.createdByAccountId;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String description() {
        return this.description;
    }

    public final ServiceEndpointType endpointType() {
        return ServiceEndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final ErrorResponse error() {
        return this.error;
    }

    public final LambdaEndpointConfig lambdaEndpoint() {
        return this.lambdaEndpoint;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final ServiceState state() {
        return ServiceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final UrlEndpointConfig urlEndpoint() {
        return this.urlEndpoint;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdByAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.urlEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceResponse)) {
            return false;
        }
        GetServiceResponse other = (GetServiceResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdByAccountId(), other.createdByAccountId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.lambdaEndpoint(), other.lambdaEndpoint()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.urlEndpoint(), other.urlEndpoint()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"GetServiceResponse").add("ApplicationId", (Object)this.applicationId()).add("Arn", (Object)this.arn()).add("CreatedByAccountId", (Object)this.createdByAccountId()).add("CreatedTime", (Object)this.createdTime()).add("Description", (Object)this.description()).add("EndpointType", (Object)this.endpointTypeAsString()).add("EnvironmentId", (Object)this.environmentId()).add("Error", (Object)this.error()).add("LambdaEndpoint", (Object)this.lambdaEndpoint()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Name", (Object)this.name()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("ServiceId", (Object)this.serviceId()).add("State", (Object)this.stateAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("UrlEndpoint", (Object)this.urlEndpoint()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedByAccountId": {
                return Optional.ofNullable(clazz.cast(this.createdByAccountId()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "LambdaEndpoint": {
                return Optional.ofNullable(clazz.cast(this.lambdaEndpoint()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UrlEndpoint": {
                return Optional.ofNullable(clazz.cast(this.urlEndpoint()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceResponse, T> g) {
        return obj -> g.apply((GetServiceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String arn;
        private String createdByAccountId;
        private Instant createdTime;
        private String description;
        private String endpointType;
        private String environmentId;
        private ErrorResponse error;
        private LambdaEndpointConfig lambdaEndpoint;
        private Instant lastUpdatedTime;
        private String name;
        private String ownerAccountId;
        private String serviceId;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private UrlEndpointConfig urlEndpoint;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.arn(model.arn);
            this.createdByAccountId(model.createdByAccountId);
            this.createdTime(model.createdTime);
            this.description(model.description);
            this.endpointType(model.endpointType);
            this.environmentId(model.environmentId);
            this.error(model.error);
            this.lambdaEndpoint(model.lambdaEndpoint);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.name(model.name);
            this.ownerAccountId(model.ownerAccountId);
            this.serviceId(model.serviceId);
            this.state(model.state);
            this.tags(model.tags);
            this.urlEndpoint(model.urlEndpoint);
            this.vpcId(model.vpcId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedByAccountId() {
            return this.createdByAccountId;
        }

        public final void setCreatedByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
        }

        @Override
        @Transient
        public final Builder createdByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        @Transient
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        @Transient
        public final Builder endpointType(ServiceEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        @Transient
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final ErrorResponse.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorResponse.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        @Transient
        public final Builder error(ErrorResponse error) {
            this.error = error;
            return this;
        }

        public final LambdaEndpointConfig.Builder getLambdaEndpoint() {
            return this.lambdaEndpoint != null ? this.lambdaEndpoint.toBuilder() : null;
        }

        public final void setLambdaEndpoint(LambdaEndpointConfig.BuilderImpl lambdaEndpoint) {
            this.lambdaEndpoint = lambdaEndpoint != null ? lambdaEndpoint.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaEndpoint(LambdaEndpointConfig lambdaEndpoint) {
            this.lambdaEndpoint = lambdaEndpoint;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        @Transient
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        @Transient
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ServiceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UrlEndpointConfig.Builder getUrlEndpoint() {
            return this.urlEndpoint != null ? this.urlEndpoint.toBuilder() : null;
        }

        public final void setUrlEndpoint(UrlEndpointConfig.BuilderImpl urlEndpoint) {
            this.urlEndpoint = urlEndpoint != null ? urlEndpoint.build() : null;
        }

        @Override
        @Transient
        public final Builder urlEndpoint(UrlEndpointConfig urlEndpoint) {
            this.urlEndpoint = urlEndpoint;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public GetServiceResponse build() {
            return new GetServiceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubRefactorSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceResponse> {
        public Builder applicationId(String var1);

        public Builder arn(String var1);

        public Builder createdByAccountId(String var1);

        public Builder createdTime(Instant var1);

        public Builder description(String var1);

        public Builder endpointType(String var1);

        public Builder endpointType(ServiceEndpointType var1);

        public Builder environmentId(String var1);

        public Builder error(ErrorResponse var1);

        default public Builder error(Consumer<ErrorResponse.Builder> error) {
            return this.error((ErrorResponse)((ErrorResponse.Builder)ErrorResponse.builder().applyMutation(error)).build());
        }

        public Builder lambdaEndpoint(LambdaEndpointConfig var1);

        default public Builder lambdaEndpoint(Consumer<LambdaEndpointConfig.Builder> lambdaEndpoint) {
            return this.lambdaEndpoint((LambdaEndpointConfig)((LambdaEndpointConfig.Builder)LambdaEndpointConfig.builder().applyMutation(lambdaEndpoint)).build());
        }

        public Builder lastUpdatedTime(Instant var1);

        public Builder name(String var1);

        public Builder ownerAccountId(String var1);

        public Builder serviceId(String var1);

        public Builder state(String var1);

        public Builder state(ServiceState var1);

        public Builder tags(Map<String, String> var1);

        public Builder urlEndpoint(UrlEndpointConfig var1);

        default public Builder urlEndpoint(Consumer<UrlEndpointConfig.Builder> urlEndpoint) {
            return this.urlEndpoint((UrlEndpointConfig)((UrlEndpointConfig.Builder)UrlEndpointConfig.builder().applyMutation(urlEndpoint)).build());
        }

        public Builder vpcId(String var1);
    }
}

