/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointInput;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesRequest;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagMapCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceRequest
extends MigrationHubRefactorSpacesRequest
implements ToCopyableBuilder<Builder, CreateServiceRequest> {
    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationIdentifier").getter(CreateServiceRequest.getter(CreateServiceRequest::applicationIdentifier)).setter(CreateServiceRequest.setter(Builder::applicationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationIdentifier").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateServiceRequest.getter(CreateServiceRequest::clientToken)).setter(CreateServiceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateServiceRequest.getter(CreateServiceRequest::description)).setter(CreateServiceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(CreateServiceRequest.getter(CreateServiceRequest::endpointTypeAsString)).setter(CreateServiceRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentIdentifier").getter(CreateServiceRequest.getter(CreateServiceRequest::environmentIdentifier)).setter(CreateServiceRequest.setter(Builder::environmentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentIdentifier").build()}).build();
    private static final SdkField<LambdaEndpointInput> LAMBDA_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaEndpoint").getter(CreateServiceRequest.getter(CreateServiceRequest::lambdaEndpoint)).setter(CreateServiceRequest.setter(Builder::lambdaEndpoint)).constructor(LambdaEndpointInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaEndpoint").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateServiceRequest.getter(CreateServiceRequest::name)).setter(CreateServiceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateServiceRequest.getter(CreateServiceRequest::tags)).setter(CreateServiceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<UrlEndpointInput> URL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UrlEndpoint").getter(CreateServiceRequest.getter(CreateServiceRequest::urlEndpoint)).setter(CreateServiceRequest.setter(Builder::urlEndpoint)).constructor(UrlEndpointInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlEndpoint").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateServiceRequest.getter(CreateServiceRequest::vpcId)).setter(CreateServiceRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_IDENTIFIER_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, ENDPOINT_TYPE_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, LAMBDA_ENDPOINT_FIELD, NAME_FIELD, TAGS_FIELD, URL_ENDPOINT_FIELD, VPC_ID_FIELD));
    private final String applicationIdentifier;
    private final String clientToken;
    private final String description;
    private final String endpointType;
    private final String environmentIdentifier;
    private final LambdaEndpointInput lambdaEndpoint;
    private final String name;
    private final Map<String, String> tags;
    private final UrlEndpointInput urlEndpoint;
    private final String vpcId;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationIdentifier = builder.applicationIdentifier;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.endpointType = builder.endpointType;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.lambdaEndpoint = builder.lambdaEndpoint;
        this.name = builder.name;
        this.tags = builder.tags;
        this.urlEndpoint = builder.urlEndpoint;
        this.vpcId = builder.vpcId;
    }

    public final String applicationIdentifier() {
        return this.applicationIdentifier;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final ServiceEndpointType endpointType() {
        return ServiceEndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final String environmentIdentifier() {
        return this.environmentIdentifier;
    }

    public final LambdaEndpointInput lambdaEndpoint() {
        return this.lambdaEndpoint;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final UrlEndpointInput urlEndpoint() {
        return this.urlEndpoint;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.urlEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest)((Object)obj);
        return Objects.equals(this.applicationIdentifier(), other.applicationIdentifier()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(this.lambdaEndpoint(), other.lambdaEndpoint()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.urlEndpoint(), other.urlEndpoint()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceRequest").add("ApplicationIdentifier", (Object)this.applicationIdentifier()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("EndpointType", (Object)this.endpointTypeAsString()).add("EnvironmentIdentifier", (Object)this.environmentIdentifier()).add("LambdaEndpoint", (Object)this.lambdaEndpoint()).add("Name", (Object)this.name()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("UrlEndpoint", (Object)this.urlEndpoint()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.applicationIdentifier()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "EnvironmentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentIdentifier()));
            }
            case "LambdaEndpoint": {
                return Optional.ofNullable(clazz.cast(this.lambdaEndpoint()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UrlEndpoint": {
                return Optional.ofNullable(clazz.cast(this.urlEndpoint()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesRequest.BuilderImpl
    implements Builder {
        private String applicationIdentifier;
        private String clientToken;
        private String description;
        private String endpointType;
        private String environmentIdentifier;
        private LambdaEndpointInput lambdaEndpoint;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private UrlEndpointInput urlEndpoint;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            this.applicationIdentifier(model.applicationIdentifier);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.endpointType(model.endpointType);
            this.environmentIdentifier(model.environmentIdentifier);
            this.lambdaEndpoint(model.lambdaEndpoint);
            this.name(model.name);
            this.tags(model.tags);
            this.urlEndpoint(model.urlEndpoint);
            this.vpcId(model.vpcId);
        }

        public final String getApplicationIdentifier() {
            return this.applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        @Transient
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        @Transient
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        @Transient
        public final Builder endpointType(ServiceEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        @Transient
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final LambdaEndpointInput.Builder getLambdaEndpoint() {
            return this.lambdaEndpoint != null ? this.lambdaEndpoint.toBuilder() : null;
        }

        public final void setLambdaEndpoint(LambdaEndpointInput.BuilderImpl lambdaEndpoint) {
            this.lambdaEndpoint = lambdaEndpoint != null ? lambdaEndpoint.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaEndpoint(LambdaEndpointInput lambdaEndpoint) {
            this.lambdaEndpoint = lambdaEndpoint;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UrlEndpointInput.Builder getUrlEndpoint() {
            return this.urlEndpoint != null ? this.urlEndpoint.toBuilder() : null;
        }

        public final void setUrlEndpoint(UrlEndpointInput.BuilderImpl urlEndpoint) {
            this.urlEndpoint = urlEndpoint != null ? urlEndpoint.build() : null;
        }

        @Override
        @Transient
        public final Builder urlEndpoint(UrlEndpointInput urlEndpoint) {
            this.urlEndpoint = urlEndpoint;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubRefactorSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceRequest> {
        public Builder applicationIdentifier(String var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder endpointType(String var1);

        public Builder endpointType(ServiceEndpointType var1);

        public Builder environmentIdentifier(String var1);

        public Builder lambdaEndpoint(LambdaEndpointInput var1);

        default public Builder lambdaEndpoint(Consumer<LambdaEndpointInput.Builder> lambdaEndpoint) {
            return this.lambdaEndpoint((LambdaEndpointInput)((LambdaEndpointInput.Builder)LambdaEndpointInput.builder().applyMutation(lambdaEndpoint)).build());
        }

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder urlEndpoint(UrlEndpointInput var1);

        default public Builder urlEndpoint(Consumer<UrlEndpointInput.Builder> urlEndpoint) {
            return this.urlEndpoint((UrlEndpointInput)((UrlEndpointInput.Builder)UrlEndpointInput.builder().applyMutation(urlEndpoint)).build());
        }

        public Builder vpcId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

