/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummariesCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationsResponse
extends MigrationHubRefactorSpacesResponse
implements ToCopyableBuilder<Builder, ListApplicationsResponse> {
    private static final SdkField<List<ApplicationSummary>> APPLICATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationSummaryList").getter(ListApplicationsResponse.getter(ListApplicationsResponse::applicationSummaryList)).setter(ListApplicationsResponse.setter(Builder::applicationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationsResponse.getter(ListApplicationsResponse::nextToken)).setter(ListApplicationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ApplicationSummary> applicationSummaryList;
    private final String nextToken;

    private ListApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationSummaryList = builder.applicationSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationSummaryList() {
        return this.applicationSummaryList != null && !(this.applicationSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ApplicationSummary> applicationSummaryList() {
        return this.applicationSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationSummaryList() ? this.applicationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse)((Object)obj);
        return this.hasApplicationSummaryList() == other.hasApplicationSummaryList() && Objects.equals(this.applicationSummaryList(), other.applicationSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationsResponse").add("ApplicationSummaryList", this.hasApplicationSummaryList() ? this.applicationSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.applicationSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationsResponse, T> g) {
        return obj -> g.apply((ListApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesResponse.BuilderImpl
    implements Builder {
        private List<ApplicationSummary> applicationSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            super(model);
            this.applicationSummaryList(model.applicationSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationSummary.Builder> getApplicationSummaryList() {
            List<ApplicationSummary.Builder> result = ApplicationSummariesCopier.copyToBuilder(this.applicationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationSummaryList(Collection<ApplicationSummary.BuilderImpl> applicationSummaryList) {
            this.applicationSummaryList = ApplicationSummariesCopier.copyFromBuilder(applicationSummaryList);
        }

        @Override
        @Transient
        public final Builder applicationSummaryList(Collection<ApplicationSummary> applicationSummaryList) {
            this.applicationSummaryList = ApplicationSummariesCopier.copy(applicationSummaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applicationSummaryList(ApplicationSummary ... applicationSummaryList) {
            this.applicationSummaryList(Arrays.asList(applicationSummaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applicationSummaryList(Consumer<ApplicationSummary.Builder> ... applicationSummaryList) {
            this.applicationSummaryList(Stream.of(applicationSummaryList).map(c -> (ApplicationSummary)((ApplicationSummary.Builder)ApplicationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubRefactorSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationsResponse> {
        public Builder applicationSummaryList(Collection<ApplicationSummary> var1);

        public Builder applicationSummaryList(ApplicationSummary ... var1);

        public Builder applicationSummaryList(Consumer<ApplicationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

