/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the configuration for the URL endpoint type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UrlEndpointSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<UrlEndpointSummary.Builder, UrlEndpointSummary> {
    private static final SdkField<String> HEALTH_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthUrl").getter(getter(UrlEndpointSummary::healthUrl)).setter(setter(Builder::healthUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthUrl").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(UrlEndpointSummary::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_URL_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String healthUrl;

    private final String url;

    private UrlEndpointSummary(BuilderImpl builder) {
        this.healthUrl = builder.healthUrl;
        this.url = builder.url;
    }

    /**
     * <p>
     * The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must
     * also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL
     * must also be a private endpoint, and the host must be the same as the URL.
     * </p>
     * 
     * @return The health check URL of the URL endpoint type. If the URL is a public endpoint, the
     *         <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual
     *         private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the
     *         URL.
     */
    public final String healthUrl() {
        return healthUrl;
    }

    /**
     * <p>
     * The URL to route traffic to. The URL must be an <a
     * href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the
     * name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of
     * the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>.
     * </p>
     * 
     * @return The URL to route traffic to. The URL must be an <a
     *         href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain
     *         name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top
     *         level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root
     *         zone database</a>.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthUrl());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UrlEndpointSummary)) {
            return false;
        }
        UrlEndpointSummary other = (UrlEndpointSummary) obj;
        return Objects.equals(healthUrl(), other.healthUrl()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UrlEndpointSummary").add("HealthUrl", healthUrl()).add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthUrl":
            return Optional.ofNullable(clazz.cast(healthUrl()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UrlEndpointSummary, T> g) {
        return obj -> g.apply((UrlEndpointSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UrlEndpointSummary> {
        /**
         * <p>
         * The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code>
         * must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the
         * health URL must also be a private endpoint, and the host must be the same as the URL.
         * </p>
         * 
         * @param healthUrl
         *        The health check URL of the URL endpoint type. If the URL is a public endpoint, the
         *        <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a
         *        virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the
         *        same as the URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthUrl(String healthUrl);

        /**
         * <p>
         * The URL to route traffic to. The URL must be an <a
         * href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name,
         * the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level
         * domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone
         * database</a>.
         * </p>
         * 
         * @param url
         *        The URL to route traffic to. The URL must be an <a
         *        href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a
         *        domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>
         *        , the top level domain of the host must be listed in the <a
         *        href="https://www.iana.org/domains/root/db">IANA root zone database</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String healthUrl;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(UrlEndpointSummary model) {
            healthUrl(model.healthUrl);
            url(model.url);
        }

        public final String getHealthUrl() {
            return healthUrl;
        }

        public final void setHealthUrl(String healthUrl) {
            this.healthUrl = healthUrl;
        }

        @Override
        public final Builder healthUrl(String healthUrl) {
            this.healthUrl = healthUrl;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public UrlEndpointSummary build() {
            return new UrlEndpointSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
