/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesResponse;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteState;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteType;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagMapCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.UriPathRouteInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouteResponse
extends MigrationHubRefactorSpacesResponse
implements ToCopyableBuilder<Builder, CreateRouteResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateRouteResponse.getter(CreateRouteResponse::applicationId)).setter(CreateRouteResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateRouteResponse.getter(CreateRouteResponse::arn)).setter(CreateRouteResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATED_BY_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedByAccountId").getter(CreateRouteResponse.getter(CreateRouteResponse::createdByAccountId)).setter(CreateRouteResponse.setter(Builder::createdByAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByAccountId").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(CreateRouteResponse.getter(CreateRouteResponse::createdTime)).setter(CreateRouteResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(CreateRouteResponse.getter(CreateRouteResponse::lastUpdatedTime)).setter(CreateRouteResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(CreateRouteResponse.getter(CreateRouteResponse::ownerAccountId)).setter(CreateRouteResponse.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteId").getter(CreateRouteResponse.getter(CreateRouteResponse::routeId)).setter(CreateRouteResponse.setter(Builder::routeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteId").build()}).build();
    private static final SdkField<String> ROUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteType").getter(CreateRouteResponse.getter(CreateRouteResponse::routeTypeAsString)).setter(CreateRouteResponse.setter(Builder::routeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteType").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(CreateRouteResponse.getter(CreateRouteResponse::serviceId)).setter(CreateRouteResponse.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateRouteResponse.getter(CreateRouteResponse::stateAsString)).setter(CreateRouteResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateRouteResponse.getter(CreateRouteResponse::tags)).setter(CreateRouteResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<UriPathRouteInput> URI_PATH_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UriPathRoute").getter(CreateRouteResponse.getter(CreateRouteResponse::uriPathRoute)).setter(CreateRouteResponse.setter(Builder::uriPathRoute)).constructor(UriPathRouteInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriPathRoute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ARN_FIELD, CREATED_BY_ACCOUNT_ID_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, OWNER_ACCOUNT_ID_FIELD, ROUTE_ID_FIELD, ROUTE_TYPE_FIELD, SERVICE_ID_FIELD, STATE_FIELD, TAGS_FIELD, URI_PATH_ROUTE_FIELD));
    private final String applicationId;
    private final String arn;
    private final String createdByAccountId;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final String ownerAccountId;
    private final String routeId;
    private final String routeType;
    private final String serviceId;
    private final String state;
    private final Map<String, String> tags;
    private final UriPathRouteInput uriPathRoute;

    private CreateRouteResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.createdByAccountId = builder.createdByAccountId;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.ownerAccountId = builder.ownerAccountId;
        this.routeId = builder.routeId;
        this.routeType = builder.routeType;
        this.serviceId = builder.serviceId;
        this.state = builder.state;
        this.tags = builder.tags;
        this.uriPathRoute = builder.uriPathRoute;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdByAccountId() {
        return this.createdByAccountId;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final String routeId() {
        return this.routeId;
    }

    public final RouteType routeType() {
        return RouteType.fromValue(this.routeType);
    }

    public final String routeTypeAsString() {
        return this.routeType;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final RouteState state() {
        return RouteState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final UriPathRouteInput uriPathRoute() {
        return this.uriPathRoute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdByAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uriPathRoute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteResponse)) {
            return false;
        }
        CreateRouteResponse other = (CreateRouteResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdByAccountId(), other.createdByAccountId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.routeId(), other.routeId()) && Objects.equals(this.routeTypeAsString(), other.routeTypeAsString()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.uriPathRoute(), other.uriPathRoute());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRouteResponse").add("ApplicationId", (Object)this.applicationId()).add("Arn", (Object)this.arn()).add("CreatedByAccountId", (Object)this.createdByAccountId()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("RouteId", (Object)this.routeId()).add("RouteType", (Object)this.routeTypeAsString()).add("ServiceId", (Object)this.serviceId()).add("State", (Object)this.stateAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("UriPathRoute", (Object)this.uriPathRoute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedByAccountId": {
                return Optional.ofNullable(clazz.cast(this.createdByAccountId()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "RouteId": {
                return Optional.ofNullable(clazz.cast(this.routeId()));
            }
            case "RouteType": {
                return Optional.ofNullable(clazz.cast(this.routeTypeAsString()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UriPathRoute": {
                return Optional.ofNullable(clazz.cast(this.uriPathRoute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteResponse, T> g) {
        return obj -> g.apply((CreateRouteResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String arn;
        private String createdByAccountId;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private String ownerAccountId;
        private String routeId;
        private String routeType;
        private String serviceId;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private UriPathRouteInput uriPathRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.arn(model.arn);
            this.createdByAccountId(model.createdByAccountId);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.ownerAccountId(model.ownerAccountId);
            this.routeId(model.routeId);
            this.routeType(model.routeType);
            this.serviceId(model.serviceId);
            this.state(model.state);
            this.tags(model.tags);
            this.uriPathRoute(model.uriPathRoute);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedByAccountId() {
            return this.createdByAccountId;
        }

        public final void setCreatedByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
        }

        @Override
        public final Builder createdByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getRouteId() {
            return this.routeId;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final String getRouteType() {
            return this.routeType;
        }

        public final void setRouteType(String routeType) {
            this.routeType = routeType;
        }

        @Override
        public final Builder routeType(String routeType) {
            this.routeType = routeType;
            return this;
        }

        @Override
        public final Builder routeType(RouteType routeType) {
            this.routeType(routeType == null ? null : routeType.toString());
            return this;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UriPathRouteInput.Builder getUriPathRoute() {
            return this.uriPathRoute != null ? this.uriPathRoute.toBuilder() : null;
        }

        public final void setUriPathRoute(UriPathRouteInput.BuilderImpl uriPathRoute) {
            this.uriPathRoute = uriPathRoute != null ? uriPathRoute.build() : null;
        }

        @Override
        public final Builder uriPathRoute(UriPathRouteInput uriPathRoute) {
            this.uriPathRoute = uriPathRoute;
            return this;
        }

        @Override
        public CreateRouteResponse build() {
            return new CreateRouteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubRefactorSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouteResponse> {
        public Builder applicationId(String var1);

        public Builder arn(String var1);

        public Builder createdByAccountId(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder ownerAccountId(String var1);

        public Builder routeId(String var1);

        public Builder routeType(String var1);

        public Builder routeType(RouteType var1);

        public Builder serviceId(String var1);

        public Builder state(String var1);

        public Builder state(RouteState var1);

        public Builder tags(Map<String, String> var1);

        public Builder uriPathRoute(UriPathRouteInput var1);

        default public Builder uriPathRoute(Consumer<UriPathRouteInput.Builder> uriPathRoute) {
            return this.uriPathRoute((UriPathRouteInput)((UriPathRouteInput.Builder)UriPathRouteInput.builder().applyMutation(uriPathRoute)).build());
        }
    }
}

