/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A wrapper object holding the Amazon API Gateway endpoint input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiGatewayProxyInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ApiGatewayProxyInput.Builder, ApiGatewayProxyInput> {
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(ApiGatewayProxyInput::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(ApiGatewayProxyInput::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_TYPE_FIELD,
            STAGE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointType;

    private final String stageName;

    private ApiGatewayProxyInput(BuilderImpl builder) {
        this.endpointType = builder.endpointType;
        this.stageName = builder.stageName;
    }

    /**
     * <p>
     * The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set
     * to <code>REGIONAL</code> by default.
     * </p>
     * <p>
     * If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is isolated
     * from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon
     * VPC) interface endpoints for the Amazon API Gateway that has been granted access. For more information about
     * creating a private connection with Refactor Spaces and interface endpoint (Amazon Web Services PrivateLink)
     * availability, see <a
     * href="https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html"
     * >Access Refactor Spaces using an interface endpoint (Amazon Web Services PrivateLink)</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ApiGatewayEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value
     *         is set to <code>REGIONAL</code> by default.</p>
     *         <p>
     *         If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is
     *         isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual
     *         Private Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been granted access.
     *         For more information about creating a private connection with Refactor Spaces and interface endpoint
     *         (Amazon Web Services PrivateLink) availability, see <a href=
     *         "https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html"
     *         >Access Refactor Spaces using an interface endpoint (Amazon Web Services PrivateLink)</a>.
     * @see ApiGatewayEndpointType
     */
    public final ApiGatewayEndpointType endpointType() {
        return ApiGatewayEndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set
     * to <code>REGIONAL</code> by default.
     * </p>
     * <p>
     * If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is isolated
     * from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon
     * VPC) interface endpoints for the Amazon API Gateway that has been granted access. For more information about
     * creating a private connection with Refactor Spaces and interface endpoint (Amazon Web Services PrivateLink)
     * availability, see <a
     * href="https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html"
     * >Access Refactor Spaces using an interface endpoint (Amazon Web Services PrivateLink)</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ApiGatewayEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value
     *         is set to <code>REGIONAL</code> by default.</p>
     *         <p>
     *         If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is
     *         isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual
     *         Private Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been granted access.
     *         For more information about creating a private connection with Refactor Spaces and interface endpoint
     *         (Amazon Web Services PrivateLink) availability, see <a href=
     *         "https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html"
     *         >Access Refactor Spaces using an interface endpoint (Amazon Web Services PrivateLink)</a>.
     * @see ApiGatewayEndpointType
     */
    public final String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The name of the API Gateway stage. The name defaults to <code>prod</code>.
     * </p>
     * 
     * @return The name of the API Gateway stage. The name defaults to <code>prod</code>.
     */
    public final String stageName() {
        return stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiGatewayProxyInput)) {
            return false;
        }
        ApiGatewayProxyInput other = (ApiGatewayProxyInput) obj;
        return Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(stageName(), other.stageName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiGatewayProxyInput").add("EndpointType", endpointTypeAsString()).add("StageName", stageName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointType", ENDPOINT_TYPE_FIELD);
        map.put("StageName", STAGE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiGatewayProxyInput, T> g) {
        return obj -> g.apply((ApiGatewayProxyInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiGatewayProxyInput> {
        /**
         * <p>
         * The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is
         * set to <code>REGIONAL</code> by default.
         * </p>
         * <p>
         * If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is
         * isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private
         * Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been granted access. For more
         * information about creating a private connection with Refactor Spaces and interface endpoint (Amazon Web
         * Services PrivateLink) availability, see <a href=
         * "https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html"
         * >Access Refactor Spaces using an interface endpoint (Amazon Web Services PrivateLink)</a>.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the
         *        value is set to <code>REGIONAL</code> by default.</p>
         *        <p>
         *        If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that
         *        is isolated from the public internet. The private endpoint can only be accessed by using Amazon
         *        Virtual Private Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been
         *        granted access. For more information about creating a private connection with Refactor Spaces and
         *        interface endpoint (Amazon Web Services PrivateLink) availability, see <a href=
         *        "https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html"
         *        >Access Refactor Spaces using an interface endpoint (Amazon Web Services PrivateLink)</a>.
         * @see ApiGatewayEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiGatewayEndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is
         * set to <code>REGIONAL</code> by default.
         * </p>
         * <p>
         * If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is
         * isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private
         * Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been granted access. For more
         * information about creating a private connection with Refactor Spaces and interface endpoint (Amazon Web
         * Services PrivateLink) availability, see <a href=
         * "https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html"
         * >Access Refactor Spaces using an interface endpoint (Amazon Web Services PrivateLink)</a>.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the
         *        value is set to <code>REGIONAL</code> by default.</p>
         *        <p>
         *        If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that
         *        is isolated from the public internet. The private endpoint can only be accessed by using Amazon
         *        Virtual Private Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been
         *        granted access. For more information about creating a private connection with Refactor Spaces and
         *        interface endpoint (Amazon Web Services PrivateLink) availability, see <a href=
         *        "https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html"
         *        >Access Refactor Spaces using an interface endpoint (Amazon Web Services PrivateLink)</a>.
         * @see ApiGatewayEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiGatewayEndpointType
         */
        Builder endpointType(ApiGatewayEndpointType endpointType);

        /**
         * <p>
         * The name of the API Gateway stage. The name defaults to <code>prod</code>.
         * </p>
         * 
         * @param stageName
         *        The name of the API Gateway stage. The name defaults to <code>prod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);
    }

    static final class BuilderImpl implements Builder {
        private String endpointType;

        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiGatewayProxyInput model) {
            endpointType(model.endpointType);
            stageName(model.stageName);
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ApiGatewayEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        @Override
        public ApiGatewayProxyInput build() {
            return new ApiGatewayProxyInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
