/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouteResponse extends MigrationHubRefactorSpacesResponse implements
        ToCopyableBuilder<CreateRouteResponse.Builder, CreateRouteResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(CreateRouteResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateRouteResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATED_BY_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedByAccountId").getter(getter(CreateRouteResponse::createdByAccountId))
            .setter(setter(Builder::createdByAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByAccountId").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(CreateRouteResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(CreateRouteResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(CreateRouteResponse::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteId").getter(getter(CreateRouteResponse::routeId)).setter(setter(Builder::routeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteId").build()).build();

    private static final SdkField<String> ROUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteType").getter(getter(CreateRouteResponse::routeTypeAsString)).setter(setter(Builder::routeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteType").build()).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceId").getter(getter(CreateRouteResponse::serviceId)).setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CreateRouteResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateRouteResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<UriPathRouteInput> URI_PATH_ROUTE_FIELD = SdkField
            .<UriPathRouteInput> builder(MarshallingType.SDK_POJO).memberName("UriPathRoute")
            .getter(getter(CreateRouteResponse::uriPathRoute)).setter(setter(Builder::uriPathRoute))
            .constructor(UriPathRouteInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriPathRoute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ARN_FIELD, CREATED_BY_ACCOUNT_ID_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, OWNER_ACCOUNT_ID_FIELD,
            ROUTE_ID_FIELD, ROUTE_TYPE_FIELD, SERVICE_ID_FIELD, STATE_FIELD, TAGS_FIELD, URI_PATH_ROUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String arn;

    private final String createdByAccountId;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String ownerAccountId;

    private final String routeId;

    private final String routeType;

    private final String serviceId;

    private final String state;

    private final Map<String, String> tags;

    private final UriPathRouteInput uriPathRoute;

    private CreateRouteResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.createdByAccountId = builder.createdByAccountId;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.ownerAccountId = builder.ownerAccountId;
        this.routeId = builder.routeId;
        this.routeType = builder.routeType;
        this.serviceId = builder.serviceId;
        this.state = builder.state;
        this.tags = builder.tags;
        this.uriPathRoute = builder.uriPathRoute;
    }

    /**
     * <p>
     * The ID of the application in which the route is created.
     * </p>
     * 
     * @return The ID of the application in which the route is created.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the route. The format for this ARN is
     * <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the route. The format for this ARN is
     *         <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the route creator.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the route creator.
     */
    public final String createdByAccountId() {
        return createdByAccountId;
    }

    /**
     * <p>
     * A timestamp that indicates when the route is created.
     * </p>
     * 
     * @return A timestamp that indicates when the route is created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * A timestamp that indicates when the route was last updated.
     * </p>
     * 
     * @return A timestamp that indicates when the route was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the route owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the route owner.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The unique identifier of the route.
     * </p>
     * 
     * @return The unique identifier of the route.
     */
    public final String routeId() {
        return routeId;
    }

    /**
     * <p>
     * The route type of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routeType} will
     * return {@link RouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routeTypeAsString}.
     * </p>
     * 
     * @return The route type of the route.
     * @see RouteType
     */
    public final RouteType routeType() {
        return RouteType.fromValue(routeType);
    }

    /**
     * <p>
     * The route type of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routeType} will
     * return {@link RouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routeTypeAsString}.
     * </p>
     * 
     * @return The route type of the route.
     * @see RouteType
     */
    public final String routeTypeAsString() {
        return routeType;
    }

    /**
     * <p>
     * The ID of service in which the route is created. Traffic that matches this route is forwarded to this service.
     * </p>
     * 
     * @return The ID of service in which the route is created. Traffic that matches this route is forwarded to this
     *         service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The current state of the route. Activation state only allows <code>ACTIVE</code> or <code>INACTIVE</code> as user
     * inputs. <code>FAILED</code> is a route state that is system generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the route. Activation state only allows <code>ACTIVE</code> or <code>INACTIVE</code>
     *         as user inputs. <code>FAILED</code> is a route state that is system generated.
     * @see RouteState
     */
    public final RouteState state() {
        return RouteState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the route. Activation state only allows <code>ACTIVE</code> or <code>INACTIVE</code> as user
     * inputs. <code>FAILED</code> is a route state that is system generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the route. Activation state only allows <code>ACTIVE</code> or <code>INACTIVE</code>
     *         as user inputs. <code>FAILED</code> is a route state that is system generated.
     * @see RouteState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services resource. Each
     * tag consists of a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services
     *         resource. Each tag consists of a key-value pair.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Configuration for the URI path route type.
     * </p>
     * 
     * @return Configuration for the URI path route type.
     */
    public final UriPathRouteInput uriPathRoute() {
        return uriPathRoute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdByAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(routeId());
        hashCode = 31 * hashCode + Objects.hashCode(routeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uriPathRoute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteResponse)) {
            return false;
        }
        CreateRouteResponse other = (CreateRouteResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdByAccountId(), other.createdByAccountId())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(ownerAccountId(), other.ownerAccountId()) && Objects.equals(routeId(), other.routeId())
                && Objects.equals(routeTypeAsString(), other.routeTypeAsString())
                && Objects.equals(serviceId(), other.serviceId()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(uriPathRoute(), other.uriPathRoute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRouteResponse").add("ApplicationId", applicationId()).add("Arn", arn())
                .add("CreatedByAccountId", createdByAccountId()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("OwnerAccountId", ownerAccountId()).add("RouteId", routeId())
                .add("RouteType", routeTypeAsString()).add("ServiceId", serviceId()).add("State", stateAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("UriPathRoute", uriPathRoute())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedByAccountId":
            return Optional.ofNullable(clazz.cast(createdByAccountId()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "RouteId":
            return Optional.ofNullable(clazz.cast(routeId()));
        case "RouteType":
            return Optional.ofNullable(clazz.cast(routeTypeAsString()));
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UriPathRoute":
            return Optional.ofNullable(clazz.cast(uriPathRoute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreatedByAccountId", CREATED_BY_ACCOUNT_ID_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("RouteId", ROUTE_ID_FIELD);
        map.put("RouteType", ROUTE_TYPE_FIELD);
        map.put("ServiceId", SERVICE_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("UriPathRoute", URI_PATH_ROUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteResponse, T> g) {
        return obj -> g.apply((CreateRouteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRefactorSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRouteResponse> {
        /**
         * <p>
         * The ID of the application in which the route is created.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application in which the route is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the route. The format for this ARN is
         * <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the route. The format for this ARN is
         *        <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>
         *        . For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Web Services account ID of the route creator.
         * </p>
         * 
         * @param createdByAccountId
         *        The Amazon Web Services account ID of the route creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByAccountId(String createdByAccountId);

        /**
         * <p>
         * A timestamp that indicates when the route is created.
         * </p>
         * 
         * @param createdTime
         *        A timestamp that indicates when the route is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * A timestamp that indicates when the route was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        A timestamp that indicates when the route was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The Amazon Web Services account ID of the route owner.
         * </p>
         * 
         * @param ownerAccountId
         *        The Amazon Web Services account ID of the route owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The unique identifier of the route.
         * </p>
         * 
         * @param routeId
         *        The unique identifier of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeId(String routeId);

        /**
         * <p>
         * The route type of the route.
         * </p>
         * 
         * @param routeType
         *        The route type of the route.
         * @see RouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteType
         */
        Builder routeType(String routeType);

        /**
         * <p>
         * The route type of the route.
         * </p>
         * 
         * @param routeType
         *        The route type of the route.
         * @see RouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteType
         */
        Builder routeType(RouteType routeType);

        /**
         * <p>
         * The ID of service in which the route is created. Traffic that matches this route is forwarded to this
         * service.
         * </p>
         * 
         * @param serviceId
         *        The ID of service in which the route is created. Traffic that matches this route is forwarded to this
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The current state of the route. Activation state only allows <code>ACTIVE</code> or <code>INACTIVE</code> as
         * user inputs. <code>FAILED</code> is a route state that is system generated.
         * </p>
         * 
         * @param state
         *        The current state of the route. Activation state only allows <code>ACTIVE</code> or
         *        <code>INACTIVE</code> as user inputs. <code>FAILED</code> is a route state that is system generated.
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the route. Activation state only allows <code>ACTIVE</code> or <code>INACTIVE</code> as
         * user inputs. <code>FAILED</code> is a route state that is system generated.
         * </p>
         * 
         * @param state
         *        The current state of the route. Activation state only allows <code>ACTIVE</code> or
         *        <code>INACTIVE</code> as user inputs. <code>FAILED</code> is a route state that is system generated.
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(RouteState state);

        /**
         * <p>
         * The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services resource.
         * Each tag consists of a key-value pair.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services
         *        resource. Each tag consists of a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Configuration for the URI path route type.
         * </p>
         * 
         * @param uriPathRoute
         *        Configuration for the URI path route type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uriPathRoute(UriPathRouteInput uriPathRoute);

        /**
         * <p>
         * Configuration for the URI path route type.
         * </p>
         * This is a convenience method that creates an instance of the {@link UriPathRouteInput.Builder} avoiding the
         * need to create one manually via {@link UriPathRouteInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UriPathRouteInput.Builder#build()} is called immediately and its
         * result is passed to {@link #uriPathRoute(UriPathRouteInput)}.
         * 
         * @param uriPathRoute
         *        a consumer that will call methods on {@link UriPathRouteInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uriPathRoute(UriPathRouteInput)
         */
        default Builder uriPathRoute(Consumer<UriPathRouteInput.Builder> uriPathRoute) {
            return uriPathRoute(UriPathRouteInput.builder().applyMutation(uriPathRoute).build());
        }
    }

    static final class BuilderImpl extends MigrationHubRefactorSpacesResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String arn;

        private String createdByAccountId;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String ownerAccountId;

        private String routeId;

        private String routeType;

        private String serviceId;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private UriPathRouteInput uriPathRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteResponse model) {
            super(model);
            applicationId(model.applicationId);
            arn(model.arn);
            createdByAccountId(model.createdByAccountId);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            ownerAccountId(model.ownerAccountId);
            routeId(model.routeId);
            routeType(model.routeType);
            serviceId(model.serviceId);
            state(model.state);
            tags(model.tags);
            uriPathRoute(model.uriPathRoute);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedByAccountId() {
            return createdByAccountId;
        }

        public final void setCreatedByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
        }

        @Override
        public final Builder createdByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getRouteId() {
            return routeId;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final String getRouteType() {
            return routeType;
        }

        public final void setRouteType(String routeType) {
            this.routeType = routeType;
        }

        @Override
        public final Builder routeType(String routeType) {
            this.routeType = routeType;
            return this;
        }

        @Override
        public final Builder routeType(RouteType routeType) {
            this.routeType(routeType == null ? null : routeType.toString());
            return this;
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UriPathRouteInput.Builder getUriPathRoute() {
            return uriPathRoute != null ? uriPathRoute.toBuilder() : null;
        }

        public final void setUriPathRoute(UriPathRouteInput.BuilderImpl uriPathRoute) {
            this.uriPathRoute = uriPathRoute != null ? uriPathRoute.build() : null;
        }

        @Override
        public final Builder uriPathRoute(UriPathRouteInput uriPathRoute) {
            this.uriPathRoute = uriPathRoute;
            return this;
        }

        @Override
        public CreateRouteResponse build() {
            return new CreateRouteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
