/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information for the <code>EnvironmentVpc</code> resource as a response to
 * <code>ListEnvironmentVpc</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentVpc implements SdkPojo, Serializable, ToCopyableBuilder<EnvironmentVpc.Builder, EnvironmentVpc> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(EnvironmentVpc::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<List<String>> CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CidrBlocks")
            .getter(getter(EnvironmentVpc::cidrBlocks))
            .setter(setter(Builder::cidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(EnvironmentVpc::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(EnvironmentVpc::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(EnvironmentVpc::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(EnvironmentVpc::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> VPC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcName").getter(getter(EnvironmentVpc::vpcName)).setter(setter(Builder::vpcName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CIDR_BLOCKS_FIELD, CREATED_TIME_FIELD, ENVIRONMENT_ID_FIELD, LAST_UPDATED_TIME_FIELD, VPC_ID_FIELD, VPC_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final List<String> cidrBlocks;

    private final Instant createdTime;

    private final String environmentId;

    private final Instant lastUpdatedTime;

    private final String vpcId;

    private final String vpcName;

    private EnvironmentVpc(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.cidrBlocks = builder.cidrBlocks;
        this.createdTime = builder.createdTime;
        this.environmentId = builder.environmentId;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.vpcId = builder.vpcId;
        this.vpcName = builder.vpcName;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the virtual private cloud (VPC) owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the virtual private cloud (VPC) owner.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrBlocks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCidrBlocks() {
        return cidrBlocks != null && !(cidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrBlocks} method.
     * </p>
     * 
     * @return The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks.
     */
    public final List<String> cidrBlocks() {
        return cidrBlocks;
    }

    /**
     * <p>
     * A timestamp that indicates when the VPC is first added to the environment.
     * </p>
     * 
     * @return A timestamp that indicates when the VPC is first added to the environment.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The unique identifier of the environment.
     * </p>
     * 
     * @return The unique identifier of the environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * A timestamp that indicates when the VPC was last updated by the environment.
     * </p>
     * 
     * @return A timestamp that indicates when the VPC was last updated by the environment.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The name of the VPC at the time it is added to the environment.
     * </p>
     * 
     * @return The name of the VPC at the time it is added to the environment.
     */
    public final String vpcName() {
        return vpcName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrBlocks() ? cidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentVpc)) {
            return false;
        }
        EnvironmentVpc other = (EnvironmentVpc) obj;
        return Objects.equals(accountId(), other.accountId()) && hasCidrBlocks() == other.hasCidrBlocks()
                && Objects.equals(cidrBlocks(), other.cidrBlocks()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(vpcName(), other.vpcName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentVpc").add("AccountId", accountId())
                .add("CidrBlocks", hasCidrBlocks() ? cidrBlocks() : null).add("CreatedTime", createdTime())
                .add("EnvironmentId", environmentId()).add("LastUpdatedTime", lastUpdatedTime()).add("VpcId", vpcId())
                .add("VpcName", vpcName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "CidrBlocks":
            return Optional.ofNullable(clazz.cast(cidrBlocks()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "VpcName":
            return Optional.ofNullable(clazz.cast(vpcName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("CidrBlocks", CIDR_BLOCKS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("VpcName", VPC_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentVpc, T> g) {
        return obj -> g.apply((EnvironmentVpc) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentVpc> {
        /**
         * <p>
         * The Amazon Web Services account ID of the virtual private cloud (VPC) owner.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the virtual private cloud (VPC) owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks.
         * </p>
         * 
         * @param cidrBlocks
         *        The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlocks(Collection<String> cidrBlocks);

        /**
         * <p>
         * The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks.
         * </p>
         * 
         * @param cidrBlocks
         *        The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlocks(String... cidrBlocks);

        /**
         * <p>
         * A timestamp that indicates when the VPC is first added to the environment.
         * </p>
         * 
         * @param createdTime
         *        A timestamp that indicates when the VPC is first added to the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The unique identifier of the environment.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * A timestamp that indicates when the VPC was last updated by the environment.
         * </p>
         * 
         * @param lastUpdatedTime
         *        A timestamp that indicates when the VPC was last updated by the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The name of the VPC at the time it is added to the environment.
         * </p>
         * 
         * @param vpcName
         *        The name of the VPC at the time it is added to the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcName(String vpcName);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private List<String> cidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTime;

        private String environmentId;

        private Instant lastUpdatedTime;

        private String vpcId;

        private String vpcName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentVpc model) {
            accountId(model.accountId);
            cidrBlocks(model.cidrBlocks);
            createdTime(model.createdTime);
            environmentId(model.environmentId);
            lastUpdatedTime(model.lastUpdatedTime);
            vpcId(model.vpcId);
            vpcName(model.vpcName);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Collection<String> getCidrBlocks() {
            if (cidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrBlocks;
        }

        public final void setCidrBlocks(Collection<String> cidrBlocks) {
            this.cidrBlocks = CidrBlocksCopier.copy(cidrBlocks);
        }

        @Override
        public final Builder cidrBlocks(Collection<String> cidrBlocks) {
            this.cidrBlocks = CidrBlocksCopier.copy(cidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlocks(String... cidrBlocks) {
            cidrBlocks(Arrays.asList(cidrBlocks));
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcName() {
            return vpcName;
        }

        public final void setVpcName(String vpcName) {
            this.vpcName = vpcName;
        }

        @Override
        public final Builder vpcName(String vpcName) {
            this.vpcName = vpcName;
            return this;
        }

        @Override
        public EnvironmentVpc build() {
            return new EnvironmentVpc(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
