/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary for the service as a response to <code>ListServices</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceSummary implements SdkPojo, Serializable, ToCopyableBuilder<ServiceSummary.Builder, ServiceSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(ServiceSummary::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ServiceSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATED_BY_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedByAccountId").getter(getter(ServiceSummary::createdByAccountId))
            .setter(setter(Builder::createdByAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByAccountId").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(ServiceSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ServiceSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(ServiceSummary::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(ServiceSummary::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<ErrorResponse> ERROR_FIELD = SdkField.<ErrorResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(ServiceSummary::error)).setter(setter(Builder::error))
            .constructor(ErrorResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<LambdaEndpointSummary> LAMBDA_ENDPOINT_FIELD = SdkField
            .<LambdaEndpointSummary> builder(MarshallingType.SDK_POJO).memberName("LambdaEndpoint")
            .getter(getter(ServiceSummary::lambdaEndpoint)).setter(setter(Builder::lambdaEndpoint))
            .constructor(LambdaEndpointSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaEndpoint").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(ServiceSummary::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ServiceSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(ServiceSummary::ownerAccountId)).setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceId").getter(getter(ServiceSummary::serviceId)).setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ServiceSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(ServiceSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<UrlEndpointSummary> URL_ENDPOINT_FIELD = SdkField
            .<UrlEndpointSummary> builder(MarshallingType.SDK_POJO).memberName("UrlEndpoint")
            .getter(getter(ServiceSummary::urlEndpoint)).setter(setter(Builder::urlEndpoint))
            .constructor(UrlEndpointSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlEndpoint").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(ServiceSummary::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ARN_FIELD, CREATED_BY_ACCOUNT_ID_FIELD, CREATED_TIME_FIELD, DESCRIPTION_FIELD, ENDPOINT_TYPE_FIELD,
            ENVIRONMENT_ID_FIELD, ERROR_FIELD, LAMBDA_ENDPOINT_FIELD, LAST_UPDATED_TIME_FIELD, NAME_FIELD,
            OWNER_ACCOUNT_ID_FIELD, SERVICE_ID_FIELD, STATE_FIELD, TAGS_FIELD, URL_ENDPOINT_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String arn;

    private final String createdByAccountId;

    private final Instant createdTime;

    private final String description;

    private final String endpointType;

    private final String environmentId;

    private final ErrorResponse error;

    private final LambdaEndpointSummary lambdaEndpoint;

    private final Instant lastUpdatedTime;

    private final String name;

    private final String ownerAccountId;

    private final String serviceId;

    private final String state;

    private final Map<String, String> tags;

    private final UrlEndpointSummary urlEndpoint;

    private final String vpcId;

    private ServiceSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.createdByAccountId = builder.createdByAccountId;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.endpointType = builder.endpointType;
        this.environmentId = builder.environmentId;
        this.error = builder.error;
        this.lambdaEndpoint = builder.lambdaEndpoint;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.ownerAccountId = builder.ownerAccountId;
        this.serviceId = builder.serviceId;
        this.state = builder.state;
        this.tags = builder.tags;
        this.urlEndpoint = builder.urlEndpoint;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The unique identifier of the application.
     * </p>
     * 
     * @return The unique identifier of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the service creator.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the service creator.
     */
    public final String createdByAccountId() {
        return createdByAccountId;
    }

    /**
     * <p>
     * A timestamp that indicates when the service is created.
     * </p>
     * 
     * @return A timestamp that indicates when the service is created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * A description of the service.
     * </p>
     * 
     * @return A description of the service.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The endpoint type of the service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ServiceEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The endpoint type of the service.
     * @see ServiceEndpointType
     */
    public final ServiceEndpointType endpointType() {
        return ServiceEndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The endpoint type of the service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ServiceEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The endpoint type of the service.
     * @see ServiceEndpointType
     */
    public final String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The unique identifier of the environment.
     * </p>
     * 
     * @return The unique identifier of the environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * Any error associated with the service resource.
     * </p>
     * 
     * @return Any error associated with the service resource.
     */
    public final ErrorResponse error() {
        return error;
    }

    /**
     * <p>
     * A summary of the configuration for the Lambda endpoint type.
     * </p>
     * 
     * @return A summary of the configuration for the Lambda endpoint type.
     */
    public final LambdaEndpointSummary lambdaEndpoint() {
        return lambdaEndpoint;
    }

    /**
     * <p>
     * A timestamp that indicates when the service was last updated.
     * </p>
     * 
     * @return A timestamp that indicates when the service was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the service owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the service owner.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The unique identifier of the service.
     * </p>
     * 
     * @return The unique identifier of the service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The current state of the service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ServiceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the service.
     * @see ServiceState
     */
    public final ServiceState state() {
        return ServiceState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ServiceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the service.
     * @see ServiceState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the service.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The summary of the configuration for the URL endpoint type.
     * </p>
     * 
     * @return The summary of the configuration for the URL endpoint type.
     */
    public final UrlEndpointSummary urlEndpoint() {
        return urlEndpoint;
    }

    /**
     * <p>
     * The ID of the virtual private cloud (VPC).
     * </p>
     * 
     * @return The ID of the virtual private cloud (VPC).
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdByAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(urlEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSummary)) {
            return false;
        }
        ServiceSummary other = (ServiceSummary) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdByAccountId(), other.createdByAccountId())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(description(), other.description())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(environmentId(), other.environmentId()) && Objects.equals(error(), other.error())
                && Objects.equals(lambdaEndpoint(), other.lambdaEndpoint())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerAccountId(), other.ownerAccountId()) && Objects.equals(serviceId(), other.serviceId())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(urlEndpoint(), other.urlEndpoint())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceSummary").add("ApplicationId", applicationId()).add("Arn", arn())
                .add("CreatedByAccountId", createdByAccountId()).add("CreatedTime", createdTime())
                .add("Description", description()).add("EndpointType", endpointTypeAsString())
                .add("EnvironmentId", environmentId()).add("Error", error()).add("LambdaEndpoint", lambdaEndpoint())
                .add("LastUpdatedTime", lastUpdatedTime()).add("Name", name()).add("OwnerAccountId", ownerAccountId())
                .add("ServiceId", serviceId()).add("State", stateAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("UrlEndpoint", urlEndpoint())
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedByAccountId":
            return Optional.ofNullable(clazz.cast(createdByAccountId()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "LambdaEndpoint":
            return Optional.ofNullable(clazz.cast(lambdaEndpoint()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UrlEndpoint":
            return Optional.ofNullable(clazz.cast(urlEndpoint()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreatedByAccountId", CREATED_BY_ACCOUNT_ID_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EndpointType", ENDPOINT_TYPE_FIELD);
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("LambdaEndpoint", LAMBDA_ENDPOINT_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("ServiceId", SERVICE_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("UrlEndpoint", URL_ENDPOINT_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceSummary, T> g) {
        return obj -> g.apply((ServiceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceSummary> {
        /**
         * <p>
         * The unique identifier of the application.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Web Services account ID of the service creator.
         * </p>
         * 
         * @param createdByAccountId
         *        The Amazon Web Services account ID of the service creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByAccountId(String createdByAccountId);

        /**
         * <p>
         * A timestamp that indicates when the service is created.
         * </p>
         * 
         * @param createdTime
         *        A timestamp that indicates when the service is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * A description of the service.
         * </p>
         * 
         * @param description
         *        A description of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The endpoint type of the service.
         * </p>
         * 
         * @param endpointType
         *        The endpoint type of the service.
         * @see ServiceEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceEndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The endpoint type of the service.
         * </p>
         * 
         * @param endpointType
         *        The endpoint type of the service.
         * @see ServiceEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceEndpointType
         */
        Builder endpointType(ServiceEndpointType endpointType);

        /**
         * <p>
         * The unique identifier of the environment.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * Any error associated with the service resource.
         * </p>
         * 
         * @param error
         *        Any error associated with the service resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorResponse error);

        /**
         * <p>
         * Any error associated with the service resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorResponse.Builder} avoiding the need
         * to create one manually via {@link ErrorResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ErrorResponse)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorResponse)
         */
        default Builder error(Consumer<ErrorResponse.Builder> error) {
            return error(ErrorResponse.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * A summary of the configuration for the Lambda endpoint type.
         * </p>
         * 
         * @param lambdaEndpoint
         *        A summary of the configuration for the Lambda endpoint type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaEndpoint(LambdaEndpointSummary lambdaEndpoint);

        /**
         * <p>
         * A summary of the configuration for the Lambda endpoint type.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaEndpointSummary.Builder} avoiding
         * the need to create one manually via {@link LambdaEndpointSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaEndpointSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaEndpoint(LambdaEndpointSummary)}.
         * 
         * @param lambdaEndpoint
         *        a consumer that will call methods on {@link LambdaEndpointSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaEndpoint(LambdaEndpointSummary)
         */
        default Builder lambdaEndpoint(Consumer<LambdaEndpointSummary.Builder> lambdaEndpoint) {
            return lambdaEndpoint(LambdaEndpointSummary.builder().applyMutation(lambdaEndpoint).build());
        }

        /**
         * <p>
         * A timestamp that indicates when the service was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        A timestamp that indicates when the service was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param name
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services account ID of the service owner.
         * </p>
         * 
         * @param ownerAccountId
         *        The Amazon Web Services account ID of the service owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The unique identifier of the service.
         * </p>
         * 
         * @param serviceId
         *        The unique identifier of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The current state of the service.
         * </p>
         * 
         * @param state
         *        The current state of the service.
         * @see ServiceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the service.
         * </p>
         * 
         * @param state
         *        The current state of the service.
         * @see ServiceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceState
         */
        Builder state(ServiceState state);

        /**
         * <p>
         * The tags assigned to the service.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The summary of the configuration for the URL endpoint type.
         * </p>
         * 
         * @param urlEndpoint
         *        The summary of the configuration for the URL endpoint type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlEndpoint(UrlEndpointSummary urlEndpoint);

        /**
         * <p>
         * The summary of the configuration for the URL endpoint type.
         * </p>
         * This is a convenience method that creates an instance of the {@link UrlEndpointSummary.Builder} avoiding the
         * need to create one manually via {@link UrlEndpointSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UrlEndpointSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #urlEndpoint(UrlEndpointSummary)}.
         * 
         * @param urlEndpoint
         *        a consumer that will call methods on {@link UrlEndpointSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #urlEndpoint(UrlEndpointSummary)
         */
        default Builder urlEndpoint(Consumer<UrlEndpointSummary.Builder> urlEndpoint) {
            return urlEndpoint(UrlEndpointSummary.builder().applyMutation(urlEndpoint).build());
        }

        /**
         * <p>
         * The ID of the virtual private cloud (VPC).
         * </p>
         * 
         * @param vpcId
         *        The ID of the virtual private cloud (VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String arn;

        private String createdByAccountId;

        private Instant createdTime;

        private String description;

        private String endpointType;

        private String environmentId;

        private ErrorResponse error;

        private LambdaEndpointSummary lambdaEndpoint;

        private Instant lastUpdatedTime;

        private String name;

        private String ownerAccountId;

        private String serviceId;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private UrlEndpointSummary urlEndpoint;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSummary model) {
            applicationId(model.applicationId);
            arn(model.arn);
            createdByAccountId(model.createdByAccountId);
            createdTime(model.createdTime);
            description(model.description);
            endpointType(model.endpointType);
            environmentId(model.environmentId);
            error(model.error);
            lambdaEndpoint(model.lambdaEndpoint);
            lastUpdatedTime(model.lastUpdatedTime);
            name(model.name);
            ownerAccountId(model.ownerAccountId);
            serviceId(model.serviceId);
            state(model.state);
            tags(model.tags);
            urlEndpoint(model.urlEndpoint);
            vpcId(model.vpcId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedByAccountId() {
            return createdByAccountId;
        }

        public final void setCreatedByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
        }

        @Override
        public final Builder createdByAccountId(String createdByAccountId) {
            this.createdByAccountId = createdByAccountId;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ServiceEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final ErrorResponse.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorResponse.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorResponse error) {
            this.error = error;
            return this;
        }

        public final LambdaEndpointSummary.Builder getLambdaEndpoint() {
            return lambdaEndpoint != null ? lambdaEndpoint.toBuilder() : null;
        }

        public final void setLambdaEndpoint(LambdaEndpointSummary.BuilderImpl lambdaEndpoint) {
            this.lambdaEndpoint = lambdaEndpoint != null ? lambdaEndpoint.build() : null;
        }

        @Override
        public final Builder lambdaEndpoint(LambdaEndpointSummary lambdaEndpoint) {
            this.lambdaEndpoint = lambdaEndpoint;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ServiceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UrlEndpointSummary.Builder getUrlEndpoint() {
            return urlEndpoint != null ? urlEndpoint.toBuilder() : null;
        }

        public final void setUrlEndpoint(UrlEndpointSummary.BuilderImpl urlEndpoint) {
            this.urlEndpoint = urlEndpoint != null ? urlEndpoint.build() : null;
        }

        @Override
        public final Builder urlEndpoint(UrlEndpointSummary urlEndpoint) {
            this.urlEndpoint = urlEndpoint;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public ServiceSummary build() {
            return new ServiceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
