/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the default route type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultRouteInput implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultRouteInput.Builder, DefaultRouteInput> {
    private static final SdkField<String> ACTIVATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationState").getter(getter(DefaultRouteInput::activationStateAsString))
            .setter(setter(Builder::activationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String activationState;

    private DefaultRouteInput(BuilderImpl builder) {
        this.activationState = builder.activationState;
    }

    /**
     * <p>
     * If set to <code>ACTIVE</code>, traffic is forwarded to this route’s service after the route is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationState}
     * will return {@link RouteActivationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #activationStateAsString}.
     * </p>
     * 
     * @return If set to <code>ACTIVE</code>, traffic is forwarded to this route’s service after the route is created.
     * @see RouteActivationState
     */
    public final RouteActivationState activationState() {
        return RouteActivationState.fromValue(activationState);
    }

    /**
     * <p>
     * If set to <code>ACTIVE</code>, traffic is forwarded to this route’s service after the route is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationState}
     * will return {@link RouteActivationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #activationStateAsString}.
     * </p>
     * 
     * @return If set to <code>ACTIVE</code>, traffic is forwarded to this route’s service after the route is created.
     * @see RouteActivationState
     */
    public final String activationStateAsString() {
        return activationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activationStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultRouteInput)) {
            return false;
        }
        DefaultRouteInput other = (DefaultRouteInput) obj;
        return Objects.equals(activationStateAsString(), other.activationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultRouteInput").add("ActivationState", activationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationState":
            return Optional.ofNullable(clazz.cast(activationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActivationState", ACTIVATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultRouteInput, T> g) {
        return obj -> g.apply((DefaultRouteInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultRouteInput> {
        /**
         * <p>
         * If set to <code>ACTIVE</code>, traffic is forwarded to this route’s service after the route is created.
         * </p>
         * 
         * @param activationState
         *        If set to <code>ACTIVE</code>, traffic is forwarded to this route’s service after the route is
         *        created.
         * @see RouteActivationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteActivationState
         */
        Builder activationState(String activationState);

        /**
         * <p>
         * If set to <code>ACTIVE</code>, traffic is forwarded to this route’s service after the route is created.
         * </p>
         * 
         * @param activationState
         *        If set to <code>ACTIVE</code>, traffic is forwarded to this route’s service after the route is
         *        created.
         * @see RouteActivationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteActivationState
         */
        Builder activationState(RouteActivationState activationState);
    }

    static final class BuilderImpl implements Builder {
        private String activationState;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultRouteInput model) {
            activationState(model.activationState);
        }

        public final String getActivationState() {
            return activationState;
        }

        public final void setActivationState(String activationState) {
            this.activationState = activationState;
        }

        @Override
        public final Builder activationState(String activationState) {
            this.activationState = activationState;
            return this;
        }

        @Override
        public final Builder activationState(RouteActivationState activationState) {
            this.activationState(activationState == null ? null : activationState.toString());
            return this;
        }

        @Override
        public DefaultRouteInput build() {
            return new DefaultRouteInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
