/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteServiceRequest extends MigrationHubRefactorSpacesRequest implements
        ToCopyableBuilder<DeleteServiceRequest.Builder, DeleteServiceRequest> {
    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationIdentifier").getter(getter(DeleteServiceRequest::applicationIdentifier))
            .setter(setter(Builder::applicationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationIdentifier").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentIdentifier").getter(getter(DeleteServiceRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentIdentifier").build())
            .build();

    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceIdentifier").getter(getter(DeleteServiceRequest::serviceIdentifier))
            .setter(setter(Builder::serviceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ServiceIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_IDENTIFIER_FIELD,
            ENVIRONMENT_IDENTIFIER_FIELD, SERVICE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationIdentifier;

    private final String environmentIdentifier;

    private final String serviceIdentifier;

    private DeleteServiceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationIdentifier = builder.applicationIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.serviceIdentifier = builder.serviceIdentifier;
    }

    /**
     * <p>
     * Deletes a Refactor Spaces service.
     * </p>
     * <note>
     * <p>
     * The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services
     * resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.
     * </p>
     * </note>
     * 
     * @return Deletes a Refactor Spaces service.</p> <note>
     *         <p>
     *         The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services
     *         resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.
     *         </p>
     */
    public final String applicationIdentifier() {
        return applicationIdentifier;
    }

    /**
     * <p>
     * The ID of the environment that the service is in.
     * </p>
     * 
     * @return The ID of the environment that the service is in.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The ID of the service to delete.
     * </p>
     * 
     * @return The ID of the service to delete.
     */
    public final String serviceIdentifier() {
        return serviceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(serviceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceRequest)) {
            return false;
        }
        DeleteServiceRequest other = (DeleteServiceRequest) obj;
        return Objects.equals(applicationIdentifier(), other.applicationIdentifier())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier())
                && Objects.equals(serviceIdentifier(), other.serviceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteServiceRequest").add("ApplicationIdentifier", applicationIdentifier())
                .add("EnvironmentIdentifier", environmentIdentifier()).add("ServiceIdentifier", serviceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationIdentifier":
            return Optional.ofNullable(clazz.cast(applicationIdentifier()));
        case "EnvironmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "ServiceIdentifier":
            return Optional.ofNullable(clazz.cast(serviceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationIdentifier", APPLICATION_IDENTIFIER_FIELD);
        map.put("EnvironmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
        map.put("ServiceIdentifier", SERVICE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteServiceRequest, T> g) {
        return obj -> g.apply((DeleteServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubRefactorSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteServiceRequest> {
        /**
         * <p>
         * Deletes a Refactor Spaces service.
         * </p>
         * <note>
         * <p>
         * The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services
         * resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.
         * </p>
         * </note>
         * 
         * @param applicationIdentifier
         *        Deletes a Refactor Spaces service.</p> <note>
         *        <p>
         *        The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web
         *        Services resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint
         *        in a VPC.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIdentifier(String applicationIdentifier);

        /**
         * <p>
         * The ID of the environment that the service is in.
         * </p>
         * 
         * @param environmentIdentifier
         *        The ID of the environment that the service is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The ID of the service to delete.
         * </p>
         * 
         * @param serviceIdentifier
         *        The ID of the service to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIdentifier(String serviceIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRefactorSpacesRequest.BuilderImpl implements Builder {
        private String applicationIdentifier;

        private String environmentIdentifier;

        private String serviceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceRequest model) {
            super(model);
            applicationIdentifier(model.applicationIdentifier);
            environmentIdentifier(model.environmentIdentifier);
            serviceIdentifier(model.serviceIdentifier);
        }

        public final String getApplicationIdentifier() {
            return applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getServiceIdentifier() {
            return serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteServiceRequest build() {
            return new DeleteServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
