/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error associated with a resource returned for a Get or List resource response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorResponse implements SdkPojo, Serializable, ToCopyableBuilder<ErrorResponse.Builder, ErrorResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ErrorResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalDetails")
            .getter(getter(ErrorResponse::additionalDetails))
            .setter(setter(Builder::additionalDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(ErrorResponse::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ErrorResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(ErrorResponse::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ErrorResponse::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ADDITIONAL_DETAILS_FIELD, CODE_FIELD, MESSAGE_FIELD, RESOURCE_IDENTIFIER_FIELD, RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Map<String, String> additionalDetails;

    private final String code;

    private final String message;

    private final String resourceIdentifier;

    private final String resourceType;

    private ErrorResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.additionalDetails = builder.additionalDetails;
        this.code = builder.code;
        this.message = builder.message;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the resource owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the resource owner.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalDetails() {
        return additionalDetails != null && !(additionalDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional details about the error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalDetails} method.
     * </p>
     * 
     * @return Additional details about the error.
     */
    public final Map<String, String> additionalDetails() {
        return additionalDetails;
    }

    /**
     * <p>
     * The error code associated with the error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The error code associated with the error.
     * @see ErrorCode
     */
    public final ErrorCode code() {
        return ErrorCode.fromValue(code);
    }

    /**
     * <p>
     * The error code associated with the error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The error code associated with the error.
     * @see ErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * The message associated with the error.
     * </p>
     * 
     * @return The message associated with the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ErrorResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource.
     * @see ErrorResourceType
     */
    public final ErrorResourceType resourceType() {
        return ErrorResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ErrorResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource.
     * @see ErrorResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalDetails() ? additionalDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorResponse)) {
            return false;
        }
        ErrorResponse other = (ErrorResponse) obj;
        return Objects.equals(accountId(), other.accountId()) && hasAdditionalDetails() == other.hasAdditionalDetails()
                && Objects.equals(additionalDetails(), other.additionalDetails())
                && Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorResponse").add("AccountId", accountId())
                .add("AdditionalDetails", hasAdditionalDetails() ? additionalDetails() : null).add("Code", codeAsString())
                .add("Message", message()).add("ResourceIdentifier", resourceIdentifier())
                .add("ResourceType", resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AdditionalDetails":
            return Optional.ofNullable(clazz.cast(additionalDetails()));
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AdditionalDetails", ADDITIONAL_DETAILS_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ErrorResponse, T> g) {
        return obj -> g.apply((ErrorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorResponse> {
        /**
         * <p>
         * The Amazon Web Services account ID of the resource owner.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the resource owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Additional details about the error.
         * </p>
         * 
         * @param additionalDetails
         *        Additional details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDetails(Map<String, String> additionalDetails);

        /**
         * <p>
         * The error code associated with the error.
         * </p>
         * 
         * @param code
         *        The error code associated with the error.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * The error code associated with the error.
         * </p>
         * 
         * @param code
         *        The error code associated with the error.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder code(ErrorCode code);

        /**
         * <p>
         * The message associated with the error.
         * </p>
         * 
         * @param message
         *        The message associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceIdentifier
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resourceType
         *        The type of resource.
         * @see ErrorResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resourceType
         *        The type of resource.
         * @see ErrorResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorResourceType
         */
        Builder resourceType(ErrorResourceType resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Map<String, String> additionalDetails = DefaultSdkAutoConstructMap.getInstance();

        private String code;

        private String message;

        private String resourceIdentifier;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorResponse model) {
            accountId(model.accountId);
            additionalDetails(model.additionalDetails);
            code(model.code);
            message(model.message);
            resourceIdentifier(model.resourceIdentifier);
            resourceType(model.resourceType);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Map<String, String> getAdditionalDetails() {
            if (additionalDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalDetails;
        }

        public final void setAdditionalDetails(Map<String, String> additionalDetails) {
            this.additionalDetails = AdditionalDetailsCopier.copy(additionalDetails);
        }

        @Override
        public final Builder additionalDetails(Map<String, String> additionalDetails) {
            this.additionalDetails = AdditionalDetailsCopier.copy(additionalDetails);
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ErrorResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public ErrorResponse build() {
            return new ErrorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
