/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServicesResponse extends MigrationHubRefactorSpacesResponse implements
        ToCopyableBuilder<ListServicesResponse.Builder, ListServicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ServiceSummary>> SERVICE_SUMMARY_LIST_FIELD = SdkField
            .<List<ServiceSummary>> builder(MarshallingType.LIST)
            .memberName("ServiceSummaryList")
            .getter(getter(ListServicesResponse::serviceSummaryList))
            .setter(setter(Builder::serviceSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVICE_SUMMARY_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ServiceSummary> serviceSummaryList;

    private ListServicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceSummaryList = builder.serviceSummaryList;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceSummaryList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceSummaryList() {
        return serviceSummaryList != null && !(serviceSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>ServiceSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceSummaryList} method.
     * </p>
     * 
     * @return The list of <code>ServiceSummary</code> objects.
     */
    public final List<ServiceSummary> serviceSummaryList() {
        return serviceSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceSummaryList() ? serviceSummaryList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResponse)) {
            return false;
        }
        ListServicesResponse other = (ListServicesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasServiceSummaryList() == other.hasServiceSummaryList()
                && Objects.equals(serviceSummaryList(), other.serviceSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServicesResponse").add("NextToken", nextToken())
                .add("ServiceSummaryList", hasServiceSummaryList() ? serviceSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ServiceSummaryList":
            return Optional.ofNullable(clazz.cast(serviceSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ServiceSummaryList", SERVICE_SUMMARY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServicesResponse, T> g) {
        return obj -> g.apply((ListServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubRefactorSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServicesResponse> {
        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of <code>ServiceSummary</code> objects.
         * </p>
         * 
         * @param serviceSummaryList
         *        The list of <code>ServiceSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSummaryList(Collection<ServiceSummary> serviceSummaryList);

        /**
         * <p>
         * The list of <code>ServiceSummary</code> objects.
         * </p>
         * 
         * @param serviceSummaryList
         *        The list of <code>ServiceSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSummaryList(ServiceSummary... serviceSummaryList);

        /**
         * <p>
         * The list of <code>ServiceSummary</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #serviceSummaryList(List<ServiceSummary>)}.
         * 
         * @param serviceSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSummaryList(java.util.Collection<ServiceSummary>)
         */
        Builder serviceSummaryList(Consumer<ServiceSummary.Builder>... serviceSummaryList);
    }

    static final class BuilderImpl extends MigrationHubRefactorSpacesResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ServiceSummary> serviceSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesResponse model) {
            super(model);
            nextToken(model.nextToken);
            serviceSummaryList(model.serviceSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceSummary.Builder> getServiceSummaryList() {
            List<ServiceSummary.Builder> result = ServiceSummariesCopier.copyToBuilder(this.serviceSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceSummaryList(Collection<ServiceSummary.BuilderImpl> serviceSummaryList) {
            this.serviceSummaryList = ServiceSummariesCopier.copyFromBuilder(serviceSummaryList);
        }

        @Override
        public final Builder serviceSummaryList(Collection<ServiceSummary> serviceSummaryList) {
            this.serviceSummaryList = ServiceSummariesCopier.copy(serviceSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSummaryList(ServiceSummary... serviceSummaryList) {
            serviceSummaryList(Arrays.asList(serviceSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSummaryList(Consumer<ServiceSummary.Builder>... serviceSummaryList) {
            serviceSummaryList(Stream.of(serviceSummaryList).map(c -> ServiceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServicesResponse build() {
            return new ListServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
