/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about an application component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationComponentDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationComponentDetail.Builder, ApplicationComponentDetail> {
    private static final SdkField<String> ANALYSIS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisStatus").getter(getter(ApplicationComponentDetail::analysisStatusAsString))
            .setter(setter(Builder::analysisStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisStatus").build()).build();

    private static final SdkField<S3Object> ANTIPATTERN_REPORT_S3_OBJECT_FIELD = SdkField
            .<S3Object> builder(MarshallingType.SDK_POJO).memberName("antipatternReportS3Object")
            .getter(getter(ApplicationComponentDetail::antipatternReportS3Object))
            .setter(setter(Builder::antipatternReportS3Object)).constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportS3Object").build())
            .build();

    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("antipatternReportStatus").getter(getter(ApplicationComponentDetail::antipatternReportStatusAsString))
            .setter(setter(Builder::antipatternReportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatus").build())
            .build();

    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("antipatternReportStatusMessage")
            .getter(getter(ApplicationComponentDetail::antipatternReportStatusMessage))
            .setter(setter(Builder::antipatternReportStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatusMessage")
                    .build()).build();

    private static final SdkField<String> APP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appType").getter(getter(ApplicationComponentDetail::appTypeAsString)).setter(setter(Builder::appType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appType").build()).build();

    private static final SdkField<String> ASSOCIATED_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associatedServerId").getter(getter(ApplicationComponentDetail::associatedServerId))
            .setter(setter(Builder::associatedServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedServerId").build())
            .build();

    private static final SdkField<DatabaseConfigDetail> DATABASE_CONFIG_DETAIL_FIELD = SdkField
            .<DatabaseConfigDetail> builder(MarshallingType.SDK_POJO).memberName("databaseConfigDetail")
            .getter(getter(ApplicationComponentDetail::databaseConfigDetail)).setter(setter(Builder::databaseConfigDetail))
            .constructor(DatabaseConfigDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseConfigDetail").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ApplicationComponentDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> INCLUSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inclusionStatus").getter(getter(ApplicationComponentDetail::inclusionStatusAsString))
            .setter(setter(Builder::inclusionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusionStatus").build()).build();

    private static final SdkField<Instant> LAST_ANALYZED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastAnalyzedTimestamp").getter(getter(ApplicationComponentDetail::lastAnalyzedTimestamp))
            .setter(setter(Builder::lastAnalyzedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAnalyzedTimestamp").build())
            .build();

    private static final SdkField<List<AntipatternSeveritySummary>> LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD = SdkField
            .<List<AntipatternSeveritySummary>> builder(MarshallingType.LIST)
            .memberName("listAntipatternSeveritySummary")
            .getter(getter(ApplicationComponentDetail::listAntipatternSeveritySummary))
            .setter(setter(Builder::listAntipatternSeveritySummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listAntipatternSeveritySummary")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AntipatternSeveritySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AntipatternSeveritySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> MORE_SERVER_ASSOCIATION_EXISTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("moreServerAssociationExists")
            .getter(getter(ApplicationComponentDetail::moreServerAssociationExists))
            .setter(setter(Builder::moreServerAssociationExists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moreServerAssociationExists")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ApplicationComponentDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OS_DRIVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osDriver").getter(getter(ApplicationComponentDetail::osDriver)).setter(setter(Builder::osDriver))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osDriver").build()).build();

    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osVersion").getter(getter(ApplicationComponentDetail::osVersion)).setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()).build();

    private static final SdkField<RecommendationSet> RECOMMENDATION_SET_FIELD = SdkField
            .<RecommendationSet> builder(MarshallingType.SDK_POJO).memberName("recommendationSet")
            .getter(getter(ApplicationComponentDetail::recommendationSet)).setter(setter(Builder::recommendationSet))
            .constructor(RecommendationSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSet").build()).build();

    private static final SdkField<String> RESOURCE_SUB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceSubType").getter(getter(ApplicationComponentDetail::resourceSubTypeAsString))
            .setter(setter(Builder::resourceSubType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSubType").build()).build();

    private static final SdkField<List<SourceCodeRepository>> SOURCE_CODE_REPOSITORIES_FIELD = SdkField
            .<List<SourceCodeRepository>> builder(MarshallingType.LIST)
            .memberName("sourceCodeRepositories")
            .getter(getter(ApplicationComponentDetail::sourceCodeRepositories))
            .setter(setter(Builder::sourceCodeRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceCodeRepository> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceCodeRepository::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ApplicationComponentDetail::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_STATUS_FIELD,
            ANTIPATTERN_REPORT_S3_OBJECT_FIELD, ANTIPATTERN_REPORT_STATUS_FIELD, ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD,
            APP_TYPE_FIELD, ASSOCIATED_SERVER_ID_FIELD, DATABASE_CONFIG_DETAIL_FIELD, ID_FIELD, INCLUSION_STATUS_FIELD,
            LAST_ANALYZED_TIMESTAMP_FIELD, LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD, MORE_SERVER_ASSOCIATION_EXISTS_FIELD,
            NAME_FIELD, OS_DRIVER_FIELD, OS_VERSION_FIELD, RECOMMENDATION_SET_FIELD, RESOURCE_SUB_TYPE_FIELD,
            SOURCE_CODE_REPOSITORIES_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String analysisStatus;

    private final S3Object antipatternReportS3Object;

    private final String antipatternReportStatus;

    private final String antipatternReportStatusMessage;

    private final String appType;

    private final String associatedServerId;

    private final DatabaseConfigDetail databaseConfigDetail;

    private final String id;

    private final String inclusionStatus;

    private final Instant lastAnalyzedTimestamp;

    private final List<AntipatternSeveritySummary> listAntipatternSeveritySummary;

    private final Boolean moreServerAssociationExists;

    private final String name;

    private final String osDriver;

    private final String osVersion;

    private final RecommendationSet recommendationSet;

    private final String resourceSubType;

    private final List<SourceCodeRepository> sourceCodeRepositories;

    private final String statusMessage;

    private ApplicationComponentDetail(BuilderImpl builder) {
        this.analysisStatus = builder.analysisStatus;
        this.antipatternReportS3Object = builder.antipatternReportS3Object;
        this.antipatternReportStatus = builder.antipatternReportStatus;
        this.antipatternReportStatusMessage = builder.antipatternReportStatusMessage;
        this.appType = builder.appType;
        this.associatedServerId = builder.associatedServerId;
        this.databaseConfigDetail = builder.databaseConfigDetail;
        this.id = builder.id;
        this.inclusionStatus = builder.inclusionStatus;
        this.lastAnalyzedTimestamp = builder.lastAnalyzedTimestamp;
        this.listAntipatternSeveritySummary = builder.listAntipatternSeveritySummary;
        this.moreServerAssociationExists = builder.moreServerAssociationExists;
        this.name = builder.name;
        this.osDriver = builder.osDriver;
        this.osVersion = builder.osVersion;
        this.recommendationSet = builder.recommendationSet;
        this.resourceSubType = builder.resourceSubType;
        this.sourceCodeRepositories = builder.sourceCodeRepositories;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The status of analysis, if the application component has source code or an associated database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisStatus}
     * will return {@link SrcCodeOrDbAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #analysisStatusAsString}.
     * </p>
     * 
     * @return The status of analysis, if the application component has source code or an associated database.
     * @see SrcCodeOrDbAnalysisStatus
     */
    public final SrcCodeOrDbAnalysisStatus analysisStatus() {
        return SrcCodeOrDbAnalysisStatus.fromValue(analysisStatus);
    }

    /**
     * <p>
     * The status of analysis, if the application component has source code or an associated database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisStatus}
     * will return {@link SrcCodeOrDbAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #analysisStatusAsString}.
     * </p>
     * 
     * @return The status of analysis, if the application component has source code or an associated database.
     * @see SrcCodeOrDbAnalysisStatus
     */
    public final String analysisStatusAsString() {
        return analysisStatus;
    }

    /**
     * <p>
     * The S3 bucket name and the Amazon S3 key name for the anti-pattern report.
     * </p>
     * 
     * @return The S3 bucket name and the Amazon S3 key name for the anti-pattern report.
     */
    public final S3Object antipatternReportS3Object() {
        return antipatternReportS3Object;
    }

    /**
     * <p>
     * The status of the anti-pattern report generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #antipatternReportStatus} will return {@link AntipatternReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #antipatternReportStatusAsString}.
     * </p>
     * 
     * @return The status of the anti-pattern report generation.
     * @see AntipatternReportStatus
     */
    public final AntipatternReportStatus antipatternReportStatus() {
        return AntipatternReportStatus.fromValue(antipatternReportStatus);
    }

    /**
     * <p>
     * The status of the anti-pattern report generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #antipatternReportStatus} will return {@link AntipatternReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #antipatternReportStatusAsString}.
     * </p>
     * 
     * @return The status of the anti-pattern report generation.
     * @see AntipatternReportStatus
     */
    public final String antipatternReportStatusAsString() {
        return antipatternReportStatus;
    }

    /**
     * <p>
     * The status message for the anti-pattern.
     * </p>
     * 
     * @return The status message for the anti-pattern.
     */
    public final String antipatternReportStatusMessage() {
        return antipatternReportStatusMessage;
    }

    /**
     * <p>
     * The type of application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of application component.
     * @see AppType
     */
    public final AppType appType() {
        return AppType.fromValue(appType);
    }

    /**
     * <p>
     * The type of application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of application component.
     * @see AppType
     */
    public final String appTypeAsString() {
        return appType;
    }

    /**
     * <p>
     * The ID of the server that the application component is running on.
     * </p>
     * 
     * @return The ID of the server that the application component is running on.
     */
    public final String associatedServerId() {
        return associatedServerId;
    }

    /**
     * <p>
     * Configuration details for the database associated with the application component.
     * </p>
     * 
     * @return Configuration details for the database associated with the application component.
     */
    public final DatabaseConfigDetail databaseConfigDetail() {
        return databaseConfigDetail;
    }

    /**
     * <p>
     * The ID of the application component.
     * </p>
     * 
     * @return The ID of the application component.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Indicates whether the application component has been included for server recommendation or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inclusionStatus}
     * will return {@link InclusionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inclusionStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the application component has been included for server recommendation or not.
     * @see InclusionStatus
     */
    public final InclusionStatus inclusionStatus() {
        return InclusionStatus.fromValue(inclusionStatus);
    }

    /**
     * <p>
     * Indicates whether the application component has been included for server recommendation or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inclusionStatus}
     * will return {@link InclusionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inclusionStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the application component has been included for server recommendation or not.
     * @see InclusionStatus
     */
    public final String inclusionStatusAsString() {
        return inclusionStatus;
    }

    /**
     * <p>
     * The timestamp of when the application component was assessed.
     * </p>
     * 
     * @return The timestamp of when the application component was assessed.
     */
    public final Instant lastAnalyzedTimestamp() {
        return lastAnalyzedTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListAntipatternSeveritySummary property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasListAntipatternSeveritySummary() {
        return listAntipatternSeveritySummary != null && !(listAntipatternSeveritySummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of anti-pattern severity summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListAntipatternSeveritySummary} method.
     * </p>
     * 
     * @return A list of anti-pattern severity summaries.
     */
    public final List<AntipatternSeveritySummary> listAntipatternSeveritySummary() {
        return listAntipatternSeveritySummary;
    }

    /**
     * <p>
     * Set to true if the application component is running on multiple servers.
     * </p>
     * 
     * @return Set to true if the application component is running on multiple servers.
     */
    public final Boolean moreServerAssociationExists() {
        return moreServerAssociationExists;
    }

    /**
     * <p>
     * The name of application component.
     * </p>
     * 
     * @return The name of application component.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * OS driver.
     * </p>
     * 
     * @return OS driver.
     */
    public final String osDriver() {
        return osDriver;
    }

    /**
     * <p>
     * OS version.
     * </p>
     * 
     * @return OS version.
     */
    public final String osVersion() {
        return osVersion;
    }

    /**
     * <p>
     * The top recommendation set for the application component.
     * </p>
     * 
     * @return The top recommendation set for the application component.
     */
    public final RecommendationSet recommendationSet() {
        return recommendationSet;
    }

    /**
     * <p>
     * The application component subtype.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceSubType}
     * will return {@link ResourceSubType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceSubTypeAsString}.
     * </p>
     * 
     * @return The application component subtype.
     * @see ResourceSubType
     */
    public final ResourceSubType resourceSubType() {
        return ResourceSubType.fromValue(resourceSubType);
    }

    /**
     * <p>
     * The application component subtype.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceSubType}
     * will return {@link ResourceSubType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceSubTypeAsString}.
     * </p>
     * 
     * @return The application component subtype.
     * @see ResourceSubType
     */
    public final String resourceSubTypeAsString() {
        return resourceSubType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceCodeRepositories property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSourceCodeRepositories() {
        return sourceCodeRepositories != null && !(sourceCodeRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the source code repository associated with the application component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceCodeRepositories} method.
     * </p>
     * 
     * @return Details about the source code repository associated with the application component.
     */
    public final List<SourceCodeRepository> sourceCodeRepositories() {
        return sourceCodeRepositories;
    }

    /**
     * <p>
     * A detailed description of the analysis status and any failure message.
     * </p>
     * 
     * @return A detailed description of the analysis status and any failure message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analysisStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associatedServerId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseConfigDetail());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(inclusionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastAnalyzedTimestamp());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasListAntipatternSeveritySummary() ? listAntipatternSeveritySummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(moreServerAssociationExists());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(osDriver());
        hashCode = 31 * hashCode + Objects.hashCode(osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationSet());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSubTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceCodeRepositories() ? sourceCodeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationComponentDetail)) {
            return false;
        }
        ApplicationComponentDetail other = (ApplicationComponentDetail) obj;
        return Objects.equals(analysisStatusAsString(), other.analysisStatusAsString())
                && Objects.equals(antipatternReportS3Object(), other.antipatternReportS3Object())
                && Objects.equals(antipatternReportStatusAsString(), other.antipatternReportStatusAsString())
                && Objects.equals(antipatternReportStatusMessage(), other.antipatternReportStatusMessage())
                && Objects.equals(appTypeAsString(), other.appTypeAsString())
                && Objects.equals(associatedServerId(), other.associatedServerId())
                && Objects.equals(databaseConfigDetail(), other.databaseConfigDetail()) && Objects.equals(id(), other.id())
                && Objects.equals(inclusionStatusAsString(), other.inclusionStatusAsString())
                && Objects.equals(lastAnalyzedTimestamp(), other.lastAnalyzedTimestamp())
                && hasListAntipatternSeveritySummary() == other.hasListAntipatternSeveritySummary()
                && Objects.equals(listAntipatternSeveritySummary(), other.listAntipatternSeveritySummary())
                && Objects.equals(moreServerAssociationExists(), other.moreServerAssociationExists())
                && Objects.equals(name(), other.name()) && Objects.equals(osDriver(), other.osDriver())
                && Objects.equals(osVersion(), other.osVersion())
                && Objects.equals(recommendationSet(), other.recommendationSet())
                && Objects.equals(resourceSubTypeAsString(), other.resourceSubTypeAsString())
                && hasSourceCodeRepositories() == other.hasSourceCodeRepositories()
                && Objects.equals(sourceCodeRepositories(), other.sourceCodeRepositories())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ApplicationComponentDetail")
                .add("AnalysisStatus", analysisStatusAsString())
                .add("AntipatternReportS3Object", antipatternReportS3Object())
                .add("AntipatternReportStatus", antipatternReportStatusAsString())
                .add("AntipatternReportStatusMessage", antipatternReportStatusMessage())
                .add("AppType", appTypeAsString())
                .add("AssociatedServerId", associatedServerId())
                .add("DatabaseConfigDetail", databaseConfigDetail())
                .add("Id", id())
                .add("InclusionStatus", inclusionStatusAsString())
                .add("LastAnalyzedTimestamp", lastAnalyzedTimestamp())
                .add("ListAntipatternSeveritySummary",
                        hasListAntipatternSeveritySummary() ? listAntipatternSeveritySummary() : null)
                .add("MoreServerAssociationExists", moreServerAssociationExists()).add("Name", name())
                .add("OsDriver", osDriver()).add("OsVersion", osVersion()).add("RecommendationSet", recommendationSet())
                .add("ResourceSubType", resourceSubTypeAsString())
                .add("SourceCodeRepositories", hasSourceCodeRepositories() ? sourceCodeRepositories() : null)
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analysisStatus":
            return Optional.ofNullable(clazz.cast(analysisStatusAsString()));
        case "antipatternReportS3Object":
            return Optional.ofNullable(clazz.cast(antipatternReportS3Object()));
        case "antipatternReportStatus":
            return Optional.ofNullable(clazz.cast(antipatternReportStatusAsString()));
        case "antipatternReportStatusMessage":
            return Optional.ofNullable(clazz.cast(antipatternReportStatusMessage()));
        case "appType":
            return Optional.ofNullable(clazz.cast(appTypeAsString()));
        case "associatedServerId":
            return Optional.ofNullable(clazz.cast(associatedServerId()));
        case "databaseConfigDetail":
            return Optional.ofNullable(clazz.cast(databaseConfigDetail()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "inclusionStatus":
            return Optional.ofNullable(clazz.cast(inclusionStatusAsString()));
        case "lastAnalyzedTimestamp":
            return Optional.ofNullable(clazz.cast(lastAnalyzedTimestamp()));
        case "listAntipatternSeveritySummary":
            return Optional.ofNullable(clazz.cast(listAntipatternSeveritySummary()));
        case "moreServerAssociationExists":
            return Optional.ofNullable(clazz.cast(moreServerAssociationExists()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "osDriver":
            return Optional.ofNullable(clazz.cast(osDriver()));
        case "osVersion":
            return Optional.ofNullable(clazz.cast(osVersion()));
        case "recommendationSet":
            return Optional.ofNullable(clazz.cast(recommendationSet()));
        case "resourceSubType":
            return Optional.ofNullable(clazz.cast(resourceSubTypeAsString()));
        case "sourceCodeRepositories":
            return Optional.ofNullable(clazz.cast(sourceCodeRepositories()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationComponentDetail, T> g) {
        return obj -> g.apply((ApplicationComponentDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationComponentDetail> {
        /**
         * <p>
         * The status of analysis, if the application component has source code or an associated database.
         * </p>
         * 
         * @param analysisStatus
         *        The status of analysis, if the application component has source code or an associated database.
         * @see SrcCodeOrDbAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SrcCodeOrDbAnalysisStatus
         */
        Builder analysisStatus(String analysisStatus);

        /**
         * <p>
         * The status of analysis, if the application component has source code or an associated database.
         * </p>
         * 
         * @param analysisStatus
         *        The status of analysis, if the application component has source code or an associated database.
         * @see SrcCodeOrDbAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SrcCodeOrDbAnalysisStatus
         */
        Builder analysisStatus(SrcCodeOrDbAnalysisStatus analysisStatus);

        /**
         * <p>
         * The S3 bucket name and the Amazon S3 key name for the anti-pattern report.
         * </p>
         * 
         * @param antipatternReportS3Object
         *        The S3 bucket name and the Amazon S3 key name for the anti-pattern report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antipatternReportS3Object(S3Object antipatternReportS3Object);

        /**
         * <p>
         * The S3 bucket name and the Amazon S3 key name for the anti-pattern report.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Object.Builder} avoiding the need to create
         * one manually via {@link S3Object#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #antipatternReportS3Object(S3Object)}.
         * 
         * @param antipatternReportS3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #antipatternReportS3Object(S3Object)
         */
        default Builder antipatternReportS3Object(Consumer<S3Object.Builder> antipatternReportS3Object) {
            return antipatternReportS3Object(S3Object.builder().applyMutation(antipatternReportS3Object).build());
        }

        /**
         * <p>
         * The status of the anti-pattern report generation.
         * </p>
         * 
         * @param antipatternReportStatus
         *        The status of the anti-pattern report generation.
         * @see AntipatternReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AntipatternReportStatus
         */
        Builder antipatternReportStatus(String antipatternReportStatus);

        /**
         * <p>
         * The status of the anti-pattern report generation.
         * </p>
         * 
         * @param antipatternReportStatus
         *        The status of the anti-pattern report generation.
         * @see AntipatternReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AntipatternReportStatus
         */
        Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus);

        /**
         * <p>
         * The status message for the anti-pattern.
         * </p>
         * 
         * @param antipatternReportStatusMessage
         *        The status message for the anti-pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antipatternReportStatusMessage(String antipatternReportStatusMessage);

        /**
         * <p>
         * The type of application component.
         * </p>
         * 
         * @param appType
         *        The type of application component.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(String appType);

        /**
         * <p>
         * The type of application component.
         * </p>
         * 
         * @param appType
         *        The type of application component.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(AppType appType);

        /**
         * <p>
         * The ID of the server that the application component is running on.
         * </p>
         * 
         * @param associatedServerId
         *        The ID of the server that the application component is running on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedServerId(String associatedServerId);

        /**
         * <p>
         * Configuration details for the database associated with the application component.
         * </p>
         * 
         * @param databaseConfigDetail
         *        Configuration details for the database associated with the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseConfigDetail(DatabaseConfigDetail databaseConfigDetail);

        /**
         * <p>
         * Configuration details for the database associated with the application component.
         * </p>
         * This is a convenience that creates an instance of the {@link DatabaseConfigDetail.Builder} avoiding the need
         * to create one manually via {@link DatabaseConfigDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatabaseConfigDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #databaseConfigDetail(DatabaseConfigDetail)}.
         * 
         * @param databaseConfigDetail
         *        a consumer that will call methods on {@link DatabaseConfigDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseConfigDetail(DatabaseConfigDetail)
         */
        default Builder databaseConfigDetail(Consumer<DatabaseConfigDetail.Builder> databaseConfigDetail) {
            return databaseConfigDetail(DatabaseConfigDetail.builder().applyMutation(databaseConfigDetail).build());
        }

        /**
         * <p>
         * The ID of the application component.
         * </p>
         * 
         * @param id
         *        The ID of the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Indicates whether the application component has been included for server recommendation or not.
         * </p>
         * 
         * @param inclusionStatus
         *        Indicates whether the application component has been included for server recommendation or not.
         * @see InclusionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InclusionStatus
         */
        Builder inclusionStatus(String inclusionStatus);

        /**
         * <p>
         * Indicates whether the application component has been included for server recommendation or not.
         * </p>
         * 
         * @param inclusionStatus
         *        Indicates whether the application component has been included for server recommendation or not.
         * @see InclusionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InclusionStatus
         */
        Builder inclusionStatus(InclusionStatus inclusionStatus);

        /**
         * <p>
         * The timestamp of when the application component was assessed.
         * </p>
         * 
         * @param lastAnalyzedTimestamp
         *        The timestamp of when the application component was assessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAnalyzedTimestamp(Instant lastAnalyzedTimestamp);

        /**
         * <p>
         * A list of anti-pattern severity summaries.
         * </p>
         * 
         * @param listAntipatternSeveritySummary
         *        A list of anti-pattern severity summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> listAntipatternSeveritySummary);

        /**
         * <p>
         * A list of anti-pattern severity summaries.
         * </p>
         * 
         * @param listAntipatternSeveritySummary
         *        A list of anti-pattern severity summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listAntipatternSeveritySummary(AntipatternSeveritySummary... listAntipatternSeveritySummary);

        /**
         * <p>
         * A list of anti-pattern severity summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AntipatternSeveritySummary>.Builder}
         * avoiding the need to create one manually via {@link List<AntipatternSeveritySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AntipatternSeveritySummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #listAntipatternSeveritySummary(List<AntipatternSeveritySummary>)}.
         * 
         * @param listAntipatternSeveritySummary
         *        a consumer that will call methods on {@link List<AntipatternSeveritySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listAntipatternSeveritySummary(List<AntipatternSeveritySummary>)
         */
        Builder listAntipatternSeveritySummary(Consumer<AntipatternSeveritySummary.Builder>... listAntipatternSeveritySummary);

        /**
         * <p>
         * Set to true if the application component is running on multiple servers.
         * </p>
         * 
         * @param moreServerAssociationExists
         *        Set to true if the application component is running on multiple servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moreServerAssociationExists(Boolean moreServerAssociationExists);

        /**
         * <p>
         * The name of application component.
         * </p>
         * 
         * @param name
         *        The name of application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * OS driver.
         * </p>
         * 
         * @param osDriver
         *        OS driver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osDriver(String osDriver);

        /**
         * <p>
         * OS version.
         * </p>
         * 
         * @param osVersion
         *        OS version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osVersion(String osVersion);

        /**
         * <p>
         * The top recommendation set for the application component.
         * </p>
         * 
         * @param recommendationSet
         *        The top recommendation set for the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationSet(RecommendationSet recommendationSet);

        /**
         * <p>
         * The top recommendation set for the application component.
         * </p>
         * This is a convenience that creates an instance of the {@link RecommendationSet.Builder} avoiding the need to
         * create one manually via {@link RecommendationSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommendationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #recommendationSet(RecommendationSet)}.
         * 
         * @param recommendationSet
         *        a consumer that will call methods on {@link RecommendationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationSet(RecommendationSet)
         */
        default Builder recommendationSet(Consumer<RecommendationSet.Builder> recommendationSet) {
            return recommendationSet(RecommendationSet.builder().applyMutation(recommendationSet).build());
        }

        /**
         * <p>
         * The application component subtype.
         * </p>
         * 
         * @param resourceSubType
         *        The application component subtype.
         * @see ResourceSubType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSubType
         */
        Builder resourceSubType(String resourceSubType);

        /**
         * <p>
         * The application component subtype.
         * </p>
         * 
         * @param resourceSubType
         *        The application component subtype.
         * @see ResourceSubType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSubType
         */
        Builder resourceSubType(ResourceSubType resourceSubType);

        /**
         * <p>
         * Details about the source code repository associated with the application component.
         * </p>
         * 
         * @param sourceCodeRepositories
         *        Details about the source code repository associated with the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeRepositories(Collection<SourceCodeRepository> sourceCodeRepositories);

        /**
         * <p>
         * Details about the source code repository associated with the application component.
         * </p>
         * 
         * @param sourceCodeRepositories
         *        Details about the source code repository associated with the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeRepositories(SourceCodeRepository... sourceCodeRepositories);

        /**
         * <p>
         * Details about the source code repository associated with the application component.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SourceCodeRepository>.Builder} avoiding the
         * need to create one manually via {@link List<SourceCodeRepository>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SourceCodeRepository>.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceCodeRepositories(List<SourceCodeRepository>)}.
         * 
         * @param sourceCodeRepositories
         *        a consumer that will call methods on {@link List<SourceCodeRepository>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceCodeRepositories(List<SourceCodeRepository>)
         */
        Builder sourceCodeRepositories(Consumer<SourceCodeRepository.Builder>... sourceCodeRepositories);

        /**
         * <p>
         * A detailed description of the analysis status and any failure message.
         * </p>
         * 
         * @param statusMessage
         *        A detailed description of the analysis status and any failure message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String analysisStatus;

        private S3Object antipatternReportS3Object;

        private String antipatternReportStatus;

        private String antipatternReportStatusMessage;

        private String appType;

        private String associatedServerId;

        private DatabaseConfigDetail databaseConfigDetail;

        private String id;

        private String inclusionStatus;

        private Instant lastAnalyzedTimestamp;

        private List<AntipatternSeveritySummary> listAntipatternSeveritySummary = DefaultSdkAutoConstructList.getInstance();

        private Boolean moreServerAssociationExists;

        private String name;

        private String osDriver;

        private String osVersion;

        private RecommendationSet recommendationSet;

        private String resourceSubType;

        private List<SourceCodeRepository> sourceCodeRepositories = DefaultSdkAutoConstructList.getInstance();

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationComponentDetail model) {
            analysisStatus(model.analysisStatus);
            antipatternReportS3Object(model.antipatternReportS3Object);
            antipatternReportStatus(model.antipatternReportStatus);
            antipatternReportStatusMessage(model.antipatternReportStatusMessage);
            appType(model.appType);
            associatedServerId(model.associatedServerId);
            databaseConfigDetail(model.databaseConfigDetail);
            id(model.id);
            inclusionStatus(model.inclusionStatus);
            lastAnalyzedTimestamp(model.lastAnalyzedTimestamp);
            listAntipatternSeveritySummary(model.listAntipatternSeveritySummary);
            moreServerAssociationExists(model.moreServerAssociationExists);
            name(model.name);
            osDriver(model.osDriver);
            osVersion(model.osVersion);
            recommendationSet(model.recommendationSet);
            resourceSubType(model.resourceSubType);
            sourceCodeRepositories(model.sourceCodeRepositories);
            statusMessage(model.statusMessage);
        }

        public final String getAnalysisStatus() {
            return analysisStatus;
        }

        public final void setAnalysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
        }

        @Override
        @Transient
        public final Builder analysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder analysisStatus(SrcCodeOrDbAnalysisStatus analysisStatus) {
            this.analysisStatus(analysisStatus == null ? null : analysisStatus.toString());
            return this;
        }

        public final S3Object.Builder getAntipatternReportS3Object() {
            return antipatternReportS3Object != null ? antipatternReportS3Object.toBuilder() : null;
        }

        public final void setAntipatternReportS3Object(S3Object.BuilderImpl antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object != null ? antipatternReportS3Object.build() : null;
        }

        @Override
        @Transient
        public final Builder antipatternReportS3Object(S3Object antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object;
            return this;
        }

        public final String getAntipatternReportStatus() {
            return antipatternReportStatus;
        }

        public final void setAntipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
        }

        @Override
        @Transient
        public final Builder antipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus) {
            this.antipatternReportStatus(antipatternReportStatus == null ? null : antipatternReportStatus.toString());
            return this;
        }

        public final String getAntipatternReportStatusMessage() {
            return antipatternReportStatusMessage;
        }

        public final void setAntipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
        }

        @Override
        @Transient
        public final Builder antipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
            return this;
        }

        public final String getAppType() {
            return appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        @Transient
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        @Transient
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final String getAssociatedServerId() {
            return associatedServerId;
        }

        public final void setAssociatedServerId(String associatedServerId) {
            this.associatedServerId = associatedServerId;
        }

        @Override
        @Transient
        public final Builder associatedServerId(String associatedServerId) {
            this.associatedServerId = associatedServerId;
            return this;
        }

        public final DatabaseConfigDetail.Builder getDatabaseConfigDetail() {
            return databaseConfigDetail != null ? databaseConfigDetail.toBuilder() : null;
        }

        public final void setDatabaseConfigDetail(DatabaseConfigDetail.BuilderImpl databaseConfigDetail) {
            this.databaseConfigDetail = databaseConfigDetail != null ? databaseConfigDetail.build() : null;
        }

        @Override
        @Transient
        public final Builder databaseConfigDetail(DatabaseConfigDetail databaseConfigDetail) {
            this.databaseConfigDetail = databaseConfigDetail;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInclusionStatus() {
            return inclusionStatus;
        }

        public final void setInclusionStatus(String inclusionStatus) {
            this.inclusionStatus = inclusionStatus;
        }

        @Override
        @Transient
        public final Builder inclusionStatus(String inclusionStatus) {
            this.inclusionStatus = inclusionStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder inclusionStatus(InclusionStatus inclusionStatus) {
            this.inclusionStatus(inclusionStatus == null ? null : inclusionStatus.toString());
            return this;
        }

        public final Instant getLastAnalyzedTimestamp() {
            return lastAnalyzedTimestamp;
        }

        public final void setLastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
            return this;
        }

        public final List<AntipatternSeveritySummary.Builder> getListAntipatternSeveritySummary() {
            List<AntipatternSeveritySummary.Builder> result = ListAntipatternSeveritySummaryCopier
                    .copyToBuilder(this.listAntipatternSeveritySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListAntipatternSeveritySummary(
                Collection<AntipatternSeveritySummary.BuilderImpl> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier
                    .copyFromBuilder(listAntipatternSeveritySummary);
        }

        @Override
        @Transient
        public final Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier.copy(listAntipatternSeveritySummary);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(AntipatternSeveritySummary... listAntipatternSeveritySummary) {
            listAntipatternSeveritySummary(Arrays.asList(listAntipatternSeveritySummary));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(
                Consumer<AntipatternSeveritySummary.Builder>... listAntipatternSeveritySummary) {
            listAntipatternSeveritySummary(Stream.of(listAntipatternSeveritySummary)
                    .map(c -> AntipatternSeveritySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMoreServerAssociationExists() {
            return moreServerAssociationExists;
        }

        public final void setMoreServerAssociationExists(Boolean moreServerAssociationExists) {
            this.moreServerAssociationExists = moreServerAssociationExists;
        }

        @Override
        @Transient
        public final Builder moreServerAssociationExists(Boolean moreServerAssociationExists) {
            this.moreServerAssociationExists = moreServerAssociationExists;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOsDriver() {
            return osDriver;
        }

        public final void setOsDriver(String osDriver) {
            this.osDriver = osDriver;
        }

        @Override
        @Transient
        public final Builder osDriver(String osDriver) {
            this.osDriver = osDriver;
            return this;
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        @Transient
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final RecommendationSet.Builder getRecommendationSet() {
            return recommendationSet != null ? recommendationSet.toBuilder() : null;
        }

        public final void setRecommendationSet(RecommendationSet.BuilderImpl recommendationSet) {
            this.recommendationSet = recommendationSet != null ? recommendationSet.build() : null;
        }

        @Override
        @Transient
        public final Builder recommendationSet(RecommendationSet recommendationSet) {
            this.recommendationSet = recommendationSet;
            return this;
        }

        public final String getResourceSubType() {
            return resourceSubType;
        }

        public final void setResourceSubType(String resourceSubType) {
            this.resourceSubType = resourceSubType;
        }

        @Override
        @Transient
        public final Builder resourceSubType(String resourceSubType) {
            this.resourceSubType = resourceSubType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceSubType(ResourceSubType resourceSubType) {
            this.resourceSubType(resourceSubType == null ? null : resourceSubType.toString());
            return this;
        }

        public final List<SourceCodeRepository.Builder> getSourceCodeRepositories() {
            List<SourceCodeRepository.Builder> result = SourceCodeRepositoriesCopier.copyToBuilder(this.sourceCodeRepositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceCodeRepositories(Collection<SourceCodeRepository.BuilderImpl> sourceCodeRepositories) {
            this.sourceCodeRepositories = SourceCodeRepositoriesCopier.copyFromBuilder(sourceCodeRepositories);
        }

        @Override
        @Transient
        public final Builder sourceCodeRepositories(Collection<SourceCodeRepository> sourceCodeRepositories) {
            this.sourceCodeRepositories = SourceCodeRepositoriesCopier.copy(sourceCodeRepositories);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceCodeRepositories(SourceCodeRepository... sourceCodeRepositories) {
            sourceCodeRepositories(Arrays.asList(sourceCodeRepositories));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceCodeRepositories(Consumer<SourceCodeRepository.Builder>... sourceCodeRepositories) {
            sourceCodeRepositories(Stream.of(sourceCodeRepositories)
                    .map(c -> SourceCodeRepository.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public ApplicationComponentDetail build() {
            return new ApplicationComponentDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
