/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssessmentResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<GetAssessmentResponse.Builder, GetAssessmentResponse> {
    private static final SdkField<DataCollectionDetails> DATA_COLLECTION_DETAILS_FIELD = SdkField
            .<DataCollectionDetails> builder(MarshallingType.SDK_POJO).memberName("dataCollectionDetails")
            .getter(getter(GetAssessmentResponse::dataCollectionDetails)).setter(setter(Builder::dataCollectionDetails))
            .constructor(DataCollectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCollectionDetails").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetAssessmentResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_COLLECTION_DETAILS_FIELD,
            ID_FIELD));

    private final DataCollectionDetails dataCollectionDetails;

    private final String id;

    private GetAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.dataCollectionDetails = builder.dataCollectionDetails;
        this.id = builder.id;
    }

    /**
     * <p>
     * Detailed information about the assessment.
     * </p>
     * 
     * @return Detailed information about the assessment.
     */
    public final DataCollectionDetails dataCollectionDetails() {
        return dataCollectionDetails;
    }

    /**
     * <p>
     * The ID for the specific assessment task.
     * </p>
     * 
     * @return The ID for the specific assessment task.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataCollectionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssessmentResponse)) {
            return false;
        }
        GetAssessmentResponse other = (GetAssessmentResponse) obj;
        return Objects.equals(dataCollectionDetails(), other.dataCollectionDetails()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssessmentResponse").add("DataCollectionDetails", dataCollectionDetails()).add("Id", id())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataCollectionDetails":
            return Optional.ofNullable(clazz.cast(dataCollectionDetails()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssessmentResponse, T> g) {
        return obj -> g.apply((GetAssessmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssessmentResponse> {
        /**
         * <p>
         * Detailed information about the assessment.
         * </p>
         * 
         * @param dataCollectionDetails
         *        Detailed information about the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCollectionDetails(DataCollectionDetails dataCollectionDetails);

        /**
         * <p>
         * Detailed information about the assessment.
         * </p>
         * This is a convenience that creates an instance of the {@link DataCollectionDetails.Builder} avoiding the need
         * to create one manually via {@link DataCollectionDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataCollectionDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #dataCollectionDetails(DataCollectionDetails)}.
         * 
         * @param dataCollectionDetails
         *        a consumer that will call methods on {@link DataCollectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCollectionDetails(DataCollectionDetails)
         */
        default Builder dataCollectionDetails(Consumer<DataCollectionDetails.Builder> dataCollectionDetails) {
            return dataCollectionDetails(DataCollectionDetails.builder().applyMutation(dataCollectionDetails).build());
        }

        /**
         * <p>
         * The ID for the specific assessment task.
         * </p>
         * 
         * @param id
         *        The ID for the specific assessment task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private DataCollectionDetails dataCollectionDetails;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssessmentResponse model) {
            super(model);
            dataCollectionDetails(model.dataCollectionDetails);
            id(model.id);
        }

        public final DataCollectionDetails.Builder getDataCollectionDetails() {
            return dataCollectionDetails != null ? dataCollectionDetails.toBuilder() : null;
        }

        public final void setDataCollectionDetails(DataCollectionDetails.BuilderImpl dataCollectionDetails) {
            this.dataCollectionDetails = dataCollectionDetails != null ? dataCollectionDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder dataCollectionDetails(DataCollectionDetails dataCollectionDetails) {
            this.dataCollectionDetails = dataCollectionDetails;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public GetAssessmentResponse build() {
            return new GetAssessmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
