/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing details about the servers imported by Application Discovery Service
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerSummary implements SdkPojo, Serializable, ToCopyableBuilder<ServerSummary.Builder, ServerSummary> {
    private static final SdkField<String> SERVER_OS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerOsType").getter(getter(ServerSummary::serverOsTypeAsString)).setter(setter(Builder::serverOsType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerOsType").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(ServerSummary::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_OS_TYPE_FIELD,
            COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverOsType;

    private final Integer count;

    private ServerSummary(BuilderImpl builder) {
        this.serverOsType = builder.serverOsType;
        this.count = builder.count;
    }

    /**
     * <p>
     * Type of operating system for the servers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverOsType} will
     * return {@link ServerOsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverOsTypeAsString}.
     * </p>
     * 
     * @return Type of operating system for the servers.
     * @see ServerOsType
     */
    public final ServerOsType serverOsType() {
        return ServerOsType.fromValue(serverOsType);
    }

    /**
     * <p>
     * Type of operating system for the servers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverOsType} will
     * return {@link ServerOsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverOsTypeAsString}.
     * </p>
     * 
     * @return Type of operating system for the servers.
     * @see ServerOsType
     */
    public final String serverOsTypeAsString() {
        return serverOsType;
    }

    /**
     * <p>
     * Number of servers.
     * </p>
     * 
     * @return Number of servers.
     */
    public final Integer count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverOsTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerSummary)) {
            return false;
        }
        ServerSummary other = (ServerSummary) obj;
        return Objects.equals(serverOsTypeAsString(), other.serverOsTypeAsString()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerSummary").add("ServerOsType", serverOsTypeAsString()).add("Count", count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerOsType":
            return Optional.ofNullable(clazz.cast(serverOsTypeAsString()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerSummary, T> g) {
        return obj -> g.apply((ServerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerSummary> {
        /**
         * <p>
         * Type of operating system for the servers.
         * </p>
         * 
         * @param serverOsType
         *        Type of operating system for the servers.
         * @see ServerOsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerOsType
         */
        Builder serverOsType(String serverOsType);

        /**
         * <p>
         * Type of operating system for the servers.
         * </p>
         * 
         * @param serverOsType
         *        Type of operating system for the servers.
         * @see ServerOsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerOsType
         */
        Builder serverOsType(ServerOsType serverOsType);

        /**
         * <p>
         * Number of servers.
         * </p>
         * 
         * @param count
         *        Number of servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);
    }

    static final class BuilderImpl implements Builder {
        private String serverOsType;

        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerSummary model) {
            serverOsType(model.serverOsType);
            count(model.count);
        }

        public final String getServerOsType() {
            return serverOsType;
        }

        public final void setServerOsType(String serverOsType) {
            this.serverOsType = serverOsType;
        }

        @Override
        @Transient
        public final Builder serverOsType(String serverOsType) {
            this.serverOsType = serverOsType;
            return this;
        }

        @Override
        @Transient
        public final Builder serverOsType(ServerOsType serverOsType) {
            this.serverOsType(serverOsType == null ? null : serverOsType.toString());
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        @Override
        public ServerSummary build() {
            return new ServerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
