/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information of the transformation tool that can be used to migrate and modernize the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformationTool implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformationTool.Builder, TransformationTool> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TransformationTool::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TransformationTool::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TRANFORMATION_TOOL_INSTALLATION_LINK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("tranformationToolInstallationLink")
            .getter(getter(TransformationTool::tranformationToolInstallationLink))
            .setter(setter(Builder::tranformationToolInstallationLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tranformationToolInstallationLink")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, NAME_FIELD,
            TRANFORMATION_TOOL_INSTALLATION_LINK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String name;

    private final String tranformationToolInstallationLink;

    private TransformationTool(BuilderImpl builder) {
        this.description = builder.description;
        this.name = builder.name;
        this.tranformationToolInstallationLink = builder.tranformationToolInstallationLink;
    }

    /**
     * <p>
     * Description of the tool.
     * </p>
     * 
     * @return Description of the tool.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Name of the tool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link TransformationToolName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Name of the tool.
     * @see TransformationToolName
     */
    public final TransformationToolName name() {
        return TransformationToolName.fromValue(name);
    }

    /**
     * <p>
     * Name of the tool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link TransformationToolName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Name of the tool.
     * @see TransformationToolName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * URL for installing the tool.
     * </p>
     * 
     * @return URL for installing the tool.
     */
    public final String tranformationToolInstallationLink() {
        return tranformationToolInstallationLink;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tranformationToolInstallationLink());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformationTool)) {
            return false;
        }
        TransformationTool other = (TransformationTool) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(tranformationToolInstallationLink(), other.tranformationToolInstallationLink());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformationTool").add("Description", description()).add("Name", nameAsString())
                .add("TranformationToolInstallationLink", tranformationToolInstallationLink()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "tranformationToolInstallationLink":
            return Optional.ofNullable(clazz.cast(tranformationToolInstallationLink()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformationTool, T> g) {
        return obj -> g.apply((TransformationTool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformationTool> {
        /**
         * <p>
         * Description of the tool.
         * </p>
         * 
         * @param description
         *        Description of the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Name of the tool.
         * </p>
         * 
         * @param name
         *        Name of the tool.
         * @see TransformationToolName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformationToolName
         */
        Builder name(String name);

        /**
         * <p>
         * Name of the tool.
         * </p>
         * 
         * @param name
         *        Name of the tool.
         * @see TransformationToolName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformationToolName
         */
        Builder name(TransformationToolName name);

        /**
         * <p>
         * URL for installing the tool.
         * </p>
         * 
         * @param tranformationToolInstallationLink
         *        URL for installing the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tranformationToolInstallationLink(String tranformationToolInstallationLink);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String name;

        private String tranformationToolInstallationLink;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformationTool model) {
            description(model.description);
            name(model.name);
            tranformationToolInstallationLink(model.tranformationToolInstallationLink);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Transient
        public final Builder name(TransformationToolName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getTranformationToolInstallationLink() {
            return tranformationToolInstallationLink;
        }

        public final void setTranformationToolInstallationLink(String tranformationToolInstallationLink) {
            this.tranformationToolInstallationLink = tranformationToolInstallationLink;
        }

        @Override
        @Transient
        public final Builder tranformationToolInstallationLink(String tranformationToolInstallationLink) {
            this.tranformationToolInstallationLink = tranformationToolInstallationLink;
            return this;
        }

        @Override
        public TransformationTool build() {
            return new TransformationTool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
