/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationComponentDetailsResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<GetApplicationComponentDetailsResponse.Builder, GetApplicationComponentDetailsResponse> {
    private static final SdkField<ApplicationComponentDetail> APPLICATION_COMPONENT_DETAIL_FIELD = SdkField
            .<ApplicationComponentDetail> builder(MarshallingType.SDK_POJO)
            .memberName("applicationComponentDetail")
            .getter(getter(GetApplicationComponentDetailsResponse::applicationComponentDetail))
            .setter(setter(Builder::applicationComponentDetail))
            .constructor(ApplicationComponentDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationComponentDetail").build())
            .build();

    private static final SdkField<List<AssociatedApplication>> ASSOCIATED_APPLICATIONS_FIELD = SdkField
            .<List<AssociatedApplication>> builder(MarshallingType.LIST)
            .memberName("associatedApplications")
            .getter(getter(GetApplicationComponentDetailsResponse::associatedApplications))
            .setter(setter(Builder::associatedApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociatedApplication> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedApplication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ASSOCIATED_SERVER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedServerIds")
            .getter(getter(GetApplicationComponentDetailsResponse::associatedServerIds))
            .setter(setter(Builder::associatedServerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedServerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> MORE_APPLICATION_RESOURCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("moreApplicationResource")
            .getter(getter(GetApplicationComponentDetailsResponse::moreApplicationResource))
            .setter(setter(Builder::moreApplicationResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moreApplicationResource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_COMPONENT_DETAIL_FIELD, ASSOCIATED_APPLICATIONS_FIELD, ASSOCIATED_SERVER_IDS_FIELD,
            MORE_APPLICATION_RESOURCE_FIELD));

    private final ApplicationComponentDetail applicationComponentDetail;

    private final List<AssociatedApplication> associatedApplications;

    private final List<String> associatedServerIds;

    private final Boolean moreApplicationResource;

    private GetApplicationComponentDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationComponentDetail = builder.applicationComponentDetail;
        this.associatedApplications = builder.associatedApplications;
        this.associatedServerIds = builder.associatedServerIds;
        this.moreApplicationResource = builder.moreApplicationResource;
    }

    /**
     * <p>
     * Detailed information about an application component.
     * </p>
     * 
     * @return Detailed information about an application component.
     */
    public final ApplicationComponentDetail applicationComponentDetail() {
        return applicationComponentDetail;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedApplications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociatedApplications() {
        return associatedApplications != null && !(associatedApplications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The associated application group as defined in AWS Application Discovery Service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedApplications} method.
     * </p>
     * 
     * @return The associated application group as defined in AWS Application Discovery Service.
     */
    public final List<AssociatedApplication> associatedApplications() {
        return associatedApplications;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedServerIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedServerIds() {
        return associatedServerIds != null && !(associatedServerIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the IDs of the servers on which the application component is running.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedServerIds} method.
     * </p>
     * 
     * @return A list of the IDs of the servers on which the application component is running.
     */
    public final List<String> associatedServerIds() {
        return associatedServerIds;
    }

    /**
     * <p>
     * Set to true if the application component belongs to more than one application group.
     * </p>
     * 
     * @return Set to true if the application component belongs to more than one application group.
     */
    public final Boolean moreApplicationResource() {
        return moreApplicationResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationComponentDetail());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedApplications() ? associatedApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedServerIds() ? associatedServerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(moreApplicationResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationComponentDetailsResponse)) {
            return false;
        }
        GetApplicationComponentDetailsResponse other = (GetApplicationComponentDetailsResponse) obj;
        return Objects.equals(applicationComponentDetail(), other.applicationComponentDetail())
                && hasAssociatedApplications() == other.hasAssociatedApplications()
                && Objects.equals(associatedApplications(), other.associatedApplications())
                && hasAssociatedServerIds() == other.hasAssociatedServerIds()
                && Objects.equals(associatedServerIds(), other.associatedServerIds())
                && Objects.equals(moreApplicationResource(), other.moreApplicationResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationComponentDetailsResponse")
                .add("ApplicationComponentDetail", applicationComponentDetail())
                .add("AssociatedApplications", hasAssociatedApplications() ? associatedApplications() : null)
                .add("AssociatedServerIds", hasAssociatedServerIds() ? associatedServerIds() : null)
                .add("MoreApplicationResource", moreApplicationResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationComponentDetail":
            return Optional.ofNullable(clazz.cast(applicationComponentDetail()));
        case "associatedApplications":
            return Optional.ofNullable(clazz.cast(associatedApplications()));
        case "associatedServerIds":
            return Optional.ofNullable(clazz.cast(associatedServerIds()));
        case "moreApplicationResource":
            return Optional.ofNullable(clazz.cast(moreApplicationResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationComponentDetailsResponse, T> g) {
        return obj -> g.apply((GetApplicationComponentDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationComponentDetailsResponse> {
        /**
         * <p>
         * Detailed information about an application component.
         * </p>
         * 
         * @param applicationComponentDetail
         *        Detailed information about an application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponentDetail(ApplicationComponentDetail applicationComponentDetail);

        /**
         * <p>
         * Detailed information about an application component.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationComponentDetail.Builder}
         * avoiding the need to create one manually via {@link ApplicationComponentDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationComponentDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #applicationComponentDetail(ApplicationComponentDetail)}.
         * 
         * @param applicationComponentDetail
         *        a consumer that will call methods on {@link ApplicationComponentDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationComponentDetail(ApplicationComponentDetail)
         */
        default Builder applicationComponentDetail(Consumer<ApplicationComponentDetail.Builder> applicationComponentDetail) {
            return applicationComponentDetail(ApplicationComponentDetail.builder().applyMutation(applicationComponentDetail)
                    .build());
        }

        /**
         * <p>
         * The associated application group as defined in AWS Application Discovery Service.
         * </p>
         * 
         * @param associatedApplications
         *        The associated application group as defined in AWS Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedApplications(Collection<AssociatedApplication> associatedApplications);

        /**
         * <p>
         * The associated application group as defined in AWS Application Discovery Service.
         * </p>
         * 
         * @param associatedApplications
         *        The associated application group as defined in AWS Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedApplications(AssociatedApplication... associatedApplications);

        /**
         * <p>
         * The associated application group as defined in AWS Application Discovery Service.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AssociatedApplication>.Builder}
         * avoiding the need to create one manually via {@link List<AssociatedApplication>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssociatedApplication>.Builder#build()} is called
         * immediately and its result is passed to {@link #associatedApplications(List<AssociatedApplication>)}.
         * 
         * @param associatedApplications
         *        a consumer that will call methods on {@link List<AssociatedApplication>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedApplications(List<AssociatedApplication>)
         */
        Builder associatedApplications(Consumer<AssociatedApplication.Builder>... associatedApplications);

        /**
         * <p>
         * A list of the IDs of the servers on which the application component is running.
         * </p>
         * 
         * @param associatedServerIds
         *        A list of the IDs of the servers on which the application component is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedServerIds(Collection<String> associatedServerIds);

        /**
         * <p>
         * A list of the IDs of the servers on which the application component is running.
         * </p>
         * 
         * @param associatedServerIds
         *        A list of the IDs of the servers on which the application component is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedServerIds(String... associatedServerIds);

        /**
         * <p>
         * Set to true if the application component belongs to more than one application group.
         * </p>
         * 
         * @param moreApplicationResource
         *        Set to true if the application component belongs to more than one application group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moreApplicationResource(Boolean moreApplicationResource);
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private ApplicationComponentDetail applicationComponentDetail;

        private List<AssociatedApplication> associatedApplications = DefaultSdkAutoConstructList.getInstance();

        private List<String> associatedServerIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean moreApplicationResource;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationComponentDetailsResponse model) {
            super(model);
            applicationComponentDetail(model.applicationComponentDetail);
            associatedApplications(model.associatedApplications);
            associatedServerIds(model.associatedServerIds);
            moreApplicationResource(model.moreApplicationResource);
        }

        public final ApplicationComponentDetail.Builder getApplicationComponentDetail() {
            return applicationComponentDetail != null ? applicationComponentDetail.toBuilder() : null;
        }

        public final void setApplicationComponentDetail(ApplicationComponentDetail.BuilderImpl applicationComponentDetail) {
            this.applicationComponentDetail = applicationComponentDetail != null ? applicationComponentDetail.build() : null;
        }

        @Override
        public final Builder applicationComponentDetail(ApplicationComponentDetail applicationComponentDetail) {
            this.applicationComponentDetail = applicationComponentDetail;
            return this;
        }

        public final List<AssociatedApplication.Builder> getAssociatedApplications() {
            List<AssociatedApplication.Builder> result = AssociatedApplicationsCopier.copyToBuilder(this.associatedApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedApplications(Collection<AssociatedApplication.BuilderImpl> associatedApplications) {
            this.associatedApplications = AssociatedApplicationsCopier.copyFromBuilder(associatedApplications);
        }

        @Override
        public final Builder associatedApplications(Collection<AssociatedApplication> associatedApplications) {
            this.associatedApplications = AssociatedApplicationsCopier.copy(associatedApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedApplications(AssociatedApplication... associatedApplications) {
            associatedApplications(Arrays.asList(associatedApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedApplications(Consumer<AssociatedApplication.Builder>... associatedApplications) {
            associatedApplications(Stream.of(associatedApplications)
                    .map(c -> AssociatedApplication.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAssociatedServerIds() {
            if (associatedServerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedServerIds;
        }

        public final void setAssociatedServerIds(Collection<String> associatedServerIds) {
            this.associatedServerIds = AssociatedServerIDsCopier.copy(associatedServerIds);
        }

        @Override
        public final Builder associatedServerIds(Collection<String> associatedServerIds) {
            this.associatedServerIds = AssociatedServerIDsCopier.copy(associatedServerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedServerIds(String... associatedServerIds) {
            associatedServerIds(Arrays.asList(associatedServerIds));
            return this;
        }

        public final Boolean getMoreApplicationResource() {
            return moreApplicationResource;
        }

        public final void setMoreApplicationResource(Boolean moreApplicationResource) {
            this.moreApplicationResource = moreApplicationResource;
        }

        @Override
        public final Builder moreApplicationResource(Boolean moreApplicationResource) {
            this.moreApplicationResource = moreApplicationResource;
            return this;
        }

        @Override
        public GetApplicationComponentDetailsResponse build() {
            return new GetApplicationComponentDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
