/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPortfolioSummaryResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<GetPortfolioSummaryResponse.Builder, GetPortfolioSummaryResponse> {
    private static final SdkField<AssessmentSummary> ASSESSMENT_SUMMARY_FIELD = SdkField
            .<AssessmentSummary> builder(MarshallingType.SDK_POJO).memberName("assessmentSummary")
            .getter(getter(GetPortfolioSummaryResponse::assessmentSummary)).setter(setter(Builder::assessmentSummary))
            .constructor(AssessmentSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_SUMMARY_FIELD));

    private final AssessmentSummary assessmentSummary;

    private GetPortfolioSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentSummary = builder.assessmentSummary;
    }

    /**
     * <p>
     * An assessment summary for the portfolio including the number of servers to rehost and the overall number of
     * anti-patterns.
     * </p>
     * 
     * @return An assessment summary for the portfolio including the number of servers to rehost and the overall number
     *         of anti-patterns.
     */
    public final AssessmentSummary assessmentSummary() {
        return assessmentSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPortfolioSummaryResponse)) {
            return false;
        }
        GetPortfolioSummaryResponse other = (GetPortfolioSummaryResponse) obj;
        return Objects.equals(assessmentSummary(), other.assessmentSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPortfolioSummaryResponse").add("AssessmentSummary", assessmentSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentSummary":
            return Optional.ofNullable(clazz.cast(assessmentSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPortfolioSummaryResponse, T> g) {
        return obj -> g.apply((GetPortfolioSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPortfolioSummaryResponse> {
        /**
         * <p>
         * An assessment summary for the portfolio including the number of servers to rehost and the overall number of
         * anti-patterns.
         * </p>
         * 
         * @param assessmentSummary
         *        An assessment summary for the portfolio including the number of servers to rehost and the overall
         *        number of anti-patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentSummary(AssessmentSummary assessmentSummary);

        /**
         * <p>
         * An assessment summary for the portfolio including the number of servers to rehost and the overall number of
         * anti-patterns.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssessmentSummary.Builder} avoiding the
         * need to create one manually via {@link AssessmentSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssessmentSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #assessmentSummary(AssessmentSummary)}.
         * 
         * @param assessmentSummary
         *        a consumer that will call methods on {@link AssessmentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentSummary(AssessmentSummary)
         */
        default Builder assessmentSummary(Consumer<AssessmentSummary.Builder> assessmentSummary) {
            return assessmentSummary(AssessmentSummary.builder().applyMutation(assessmentSummary).build());
        }
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private AssessmentSummary assessmentSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPortfolioSummaryResponse model) {
            super(model);
            assessmentSummary(model.assessmentSummary);
        }

        public final AssessmentSummary.Builder getAssessmentSummary() {
            return assessmentSummary != null ? assessmentSummary.toBuilder() : null;
        }

        public final void setAssessmentSummary(AssessmentSummary.BuilderImpl assessmentSummary) {
            this.assessmentSummary = assessmentSummary != null ? assessmentSummary.build() : null;
        }

        @Override
        public final Builder assessmentSummary(AssessmentSummary assessmentSummary) {
            this.assessmentSummary = assessmentSummary;
            return this;
        }

        @Override
        public GetPortfolioSummaryResponse build() {
            return new GetPortfolioSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
