/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationReportDetailsResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<GetRecommendationReportDetailsResponse.Builder, GetRecommendationReportDetailsResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetRecommendationReportDetailsResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<RecommendationReportDetails> RECOMMENDATION_REPORT_DETAILS_FIELD = SdkField
            .<RecommendationReportDetails> builder(MarshallingType.SDK_POJO)
            .memberName("recommendationReportDetails")
            .getter(getter(GetRecommendationReportDetailsResponse::recommendationReportDetails))
            .setter(setter(Builder::recommendationReportDetails))
            .constructor(RecommendationReportDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationReportDetails")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            RECOMMENDATION_REPORT_DETAILS_FIELD));

    private final String id;

    private final RecommendationReportDetails recommendationReportDetails;

    private GetRecommendationReportDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.recommendationReportDetails = builder.recommendationReportDetails;
    }

    /**
     * <p>
     * The ID of the recommendation report generation task. See the response of
     * <a>StartRecommendationReportGeneration</a>.
     * </p>
     * 
     * @return The ID of the recommendation report generation task. See the response of
     *         <a>StartRecommendationReportGeneration</a>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Detailed information about the recommendation report.
     * </p>
     * 
     * @return Detailed information about the recommendation report.
     */
    public final RecommendationReportDetails recommendationReportDetails() {
        return recommendationReportDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationReportDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationReportDetailsResponse)) {
            return false;
        }
        GetRecommendationReportDetailsResponse other = (GetRecommendationReportDetailsResponse) obj;
        return Objects.equals(id(), other.id())
                && Objects.equals(recommendationReportDetails(), other.recommendationReportDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecommendationReportDetailsResponse").add("Id", id())
                .add("RecommendationReportDetails", recommendationReportDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "recommendationReportDetails":
            return Optional.ofNullable(clazz.cast(recommendationReportDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationReportDetailsResponse, T> g) {
        return obj -> g.apply((GetRecommendationReportDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommendationReportDetailsResponse> {
        /**
         * <p>
         * The ID of the recommendation report generation task. See the response of
         * <a>StartRecommendationReportGeneration</a>.
         * </p>
         * 
         * @param id
         *        The ID of the recommendation report generation task. See the response of
         *        <a>StartRecommendationReportGeneration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Detailed information about the recommendation report.
         * </p>
         * 
         * @param recommendationReportDetails
         *        Detailed information about the recommendation report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationReportDetails(RecommendationReportDetails recommendationReportDetails);

        /**
         * <p>
         * Detailed information about the recommendation report.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationReportDetails.Builder}
         * avoiding the need to create one manually via {@link RecommendationReportDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommendationReportDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendationReportDetails(RecommendationReportDetails)}.
         * 
         * @param recommendationReportDetails
         *        a consumer that will call methods on {@link RecommendationReportDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationReportDetails(RecommendationReportDetails)
         */
        default Builder recommendationReportDetails(Consumer<RecommendationReportDetails.Builder> recommendationReportDetails) {
            return recommendationReportDetails(RecommendationReportDetails.builder().applyMutation(recommendationReportDetails)
                    .build());
        }
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private String id;

        private RecommendationReportDetails recommendationReportDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationReportDetailsResponse model) {
            super(model);
            id(model.id);
            recommendationReportDetails(model.recommendationReportDetails);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final RecommendationReportDetails.Builder getRecommendationReportDetails() {
            return recommendationReportDetails != null ? recommendationReportDetails.toBuilder() : null;
        }

        public final void setRecommendationReportDetails(RecommendationReportDetails.BuilderImpl recommendationReportDetails) {
            this.recommendationReportDetails = recommendationReportDetails != null ? recommendationReportDetails.build() : null;
        }

        @Override
        public final Builder recommendationReportDetails(RecommendationReportDetails recommendationReportDetails) {
            this.recommendationReportDetails = recommendationReportDetails;
            return this;
        }

        @Override
        public GetRecommendationReportDetailsResponse build() {
            return new GetRecommendationReportDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
