/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImportFileTaskResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<ListImportFileTaskResponse.Builder, ListImportFileTaskResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListImportFileTaskResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ImportFileTaskInformation>> TASK_INFOS_FIELD = SdkField
            .<List<ImportFileTaskInformation>> builder(MarshallingType.LIST)
            .memberName("taskInfos")
            .getter(getter(ListImportFileTaskResponse::taskInfos))
            .setter(setter(Builder::taskInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportFileTaskInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportFileTaskInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TASK_INFOS_FIELD));

    private final String nextToken;

    private final List<ImportFileTaskInformation> taskInfos;

    private ListImportFileTaskResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.taskInfos = builder.taskInfos;
    }

    /**
     * <p>
     * The token you use to retrieve the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token you use to retrieve the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskInfos property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTaskInfos() {
        return taskInfos != null && !(taskInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists information about the files you import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskInfos} method.
     * </p>
     * 
     * @return Lists information about the files you import.
     */
    public final List<ImportFileTaskInformation> taskInfos() {
        return taskInfos;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskInfos() ? taskInfos() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportFileTaskResponse)) {
            return false;
        }
        ListImportFileTaskResponse other = (ListImportFileTaskResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTaskInfos() == other.hasTaskInfos()
                && Objects.equals(taskInfos(), other.taskInfos());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImportFileTaskResponse").add("NextToken", nextToken())
                .add("TaskInfos", hasTaskInfos() ? taskInfos() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "taskInfos":
            return Optional.ofNullable(clazz.cast(taskInfos()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImportFileTaskResponse, T> g) {
        return obj -> g.apply((ListImportFileTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListImportFileTaskResponse> {
        /**
         * <p>
         * The token you use to retrieve the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token you use to retrieve the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Lists information about the files you import.
         * </p>
         * 
         * @param taskInfos
         *        Lists information about the files you import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskInfos(Collection<ImportFileTaskInformation> taskInfos);

        /**
         * <p>
         * Lists information about the files you import.
         * </p>
         * 
         * @param taskInfos
         *        Lists information about the files you import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskInfos(ImportFileTaskInformation... taskInfos);

        /**
         * <p>
         * Lists information about the files you import.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ImportFileTaskInformation>.Builder}
         * avoiding the need to create one manually via {@link List<ImportFileTaskInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImportFileTaskInformation>.Builder#build()} is called
         * immediately and its result is passed to {@link #taskInfos(List<ImportFileTaskInformation>)}.
         * 
         * @param taskInfos
         *        a consumer that will call methods on {@link List<ImportFileTaskInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskInfos(List<ImportFileTaskInformation>)
         */
        Builder taskInfos(Consumer<ImportFileTaskInformation.Builder>... taskInfos);
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ImportFileTaskInformation> taskInfos = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportFileTaskResponse model) {
            super(model);
            nextToken(model.nextToken);
            taskInfos(model.taskInfos);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ImportFileTaskInformation.Builder> getTaskInfos() {
            List<ImportFileTaskInformation.Builder> result = ListImportFileTaskInformationCopier.copyToBuilder(this.taskInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskInfos(Collection<ImportFileTaskInformation.BuilderImpl> taskInfos) {
            this.taskInfos = ListImportFileTaskInformationCopier.copyFromBuilder(taskInfos);
        }

        @Override
        public final Builder taskInfos(Collection<ImportFileTaskInformation> taskInfos) {
            this.taskInfos = ListImportFileTaskInformationCopier.copy(taskInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskInfos(ImportFileTaskInformation... taskInfos) {
            taskInfos(Arrays.asList(taskInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskInfos(Consumer<ImportFileTaskInformation.Builder>... taskInfos) {
            taskInfos(Stream.of(taskInfos).map(c -> ImportFileTaskInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListImportFileTaskResponse build() {
            return new ListImportFileTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
