/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Preferences for migrating an application to AWS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagementPreference implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagementPreference.Builder, ManagementPreference> {
    private static final SdkField<AwsManagedResources> AWS_MANAGED_RESOURCES_FIELD = SdkField
            .<AwsManagedResources> builder(MarshallingType.SDK_POJO).memberName("awsManagedResources")
            .getter(getter(ManagementPreference::awsManagedResources)).setter(setter(Builder::awsManagedResources))
            .constructor(AwsManagedResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsManagedResources").build())
            .build();

    private static final SdkField<NoManagementPreference> NO_PREFERENCE_FIELD = SdkField
            .<NoManagementPreference> builder(MarshallingType.SDK_POJO).memberName("noPreference")
            .getter(getter(ManagementPreference::noPreference)).setter(setter(Builder::noPreference))
            .constructor(NoManagementPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noPreference").build()).build();

    private static final SdkField<SelfManageResources> SELF_MANAGE_RESOURCES_FIELD = SdkField
            .<SelfManageResources> builder(MarshallingType.SDK_POJO).memberName("selfManageResources")
            .getter(getter(ManagementPreference::selfManageResources)).setter(setter(Builder::selfManageResources))
            .constructor(SelfManageResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfManageResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_MANAGED_RESOURCES_FIELD,
            NO_PREFERENCE_FIELD, SELF_MANAGE_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsManagedResources awsManagedResources;

    private final NoManagementPreference noPreference;

    private final SelfManageResources selfManageResources;

    private final Type type;

    private ManagementPreference(BuilderImpl builder) {
        this.awsManagedResources = builder.awsManagedResources;
        this.noPreference = builder.noPreference;
        this.selfManageResources = builder.selfManageResources;
        this.type = builder.type;
    }

    /**
     * <p>
     * Indicates interest in solutions that are managed by AWS.
     * </p>
     * 
     * @return Indicates interest in solutions that are managed by AWS.
     */
    public final AwsManagedResources awsManagedResources() {
        return awsManagedResources;
    }

    /**
     * <p>
     * No specific preference.
     * </p>
     * 
     * @return No specific preference.
     */
    public final NoManagementPreference noPreference() {
        return noPreference;
    }

    /**
     * <p>
     * Indicates interest in managing your own resources on AWS.
     * </p>
     * 
     * @return Indicates interest in managing your own resources on AWS.
     */
    public final SelfManageResources selfManageResources() {
        return selfManageResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsManagedResources());
        hashCode = 31 * hashCode + Objects.hashCode(noPreference());
        hashCode = 31 * hashCode + Objects.hashCode(selfManageResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagementPreference)) {
            return false;
        }
        ManagementPreference other = (ManagementPreference) obj;
        return Objects.equals(awsManagedResources(), other.awsManagedResources())
                && Objects.equals(noPreference(), other.noPreference())
                && Objects.equals(selfManageResources(), other.selfManageResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagementPreference").add("AwsManagedResources", awsManagedResources())
                .add("NoPreference", noPreference()).add("SelfManageResources", selfManageResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsManagedResources":
            return Optional.ofNullable(clazz.cast(awsManagedResources()));
        case "noPreference":
            return Optional.ofNullable(clazz.cast(noPreference()));
        case "selfManageResources":
            return Optional.ofNullable(clazz.cast(selfManageResources()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #awsManagedResources()} initialized to the given value.
     *
     * <p>
     * Indicates interest in solutions that are managed by AWS.
     * </p>
     * 
     * @param awsManagedResources
     *        Indicates interest in solutions that are managed by AWS.
     */
    public static ManagementPreference fromAwsManagedResources(AwsManagedResources awsManagedResources) {
        return builder().awsManagedResources(awsManagedResources).build();
    }

    /**
     * Create an instance of this class with {@link #awsManagedResources()} initialized to the given value.
     *
     * <p>
     * Indicates interest in solutions that are managed by AWS.
     * </p>
     * 
     * @param awsManagedResources
     *        Indicates interest in solutions that are managed by AWS.
     */
    public static ManagementPreference fromAwsManagedResources(Consumer<AwsManagedResources.Builder> awsManagedResources) {
        AwsManagedResources.Builder builder = AwsManagedResources.builder();
        awsManagedResources.accept(builder);
        return fromAwsManagedResources(builder.build());
    }

    /**
     * Create an instance of this class with {@link #noPreference()} initialized to the given value.
     *
     * <p>
     * No specific preference.
     * </p>
     * 
     * @param noPreference
     *        No specific preference.
     */
    public static ManagementPreference fromNoPreference(NoManagementPreference noPreference) {
        return builder().noPreference(noPreference).build();
    }

    /**
     * Create an instance of this class with {@link #noPreference()} initialized to the given value.
     *
     * <p>
     * No specific preference.
     * </p>
     * 
     * @param noPreference
     *        No specific preference.
     */
    public static ManagementPreference fromNoPreference(Consumer<NoManagementPreference.Builder> noPreference) {
        NoManagementPreference.Builder builder = NoManagementPreference.builder();
        noPreference.accept(builder);
        return fromNoPreference(builder.build());
    }

    /**
     * Create an instance of this class with {@link #selfManageResources()} initialized to the given value.
     *
     * <p>
     * Indicates interest in managing your own resources on AWS.
     * </p>
     * 
     * @param selfManageResources
     *        Indicates interest in managing your own resources on AWS.
     */
    public static ManagementPreference fromSelfManageResources(SelfManageResources selfManageResources) {
        return builder().selfManageResources(selfManageResources).build();
    }

    /**
     * Create an instance of this class with {@link #selfManageResources()} initialized to the given value.
     *
     * <p>
     * Indicates interest in managing your own resources on AWS.
     * </p>
     * 
     * @param selfManageResources
     *        Indicates interest in managing your own resources on AWS.
     */
    public static ManagementPreference fromSelfManageResources(Consumer<SelfManageResources.Builder> selfManageResources) {
        SelfManageResources.Builder builder = SelfManageResources.builder();
        selfManageResources.accept(builder);
        return fromSelfManageResources(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagementPreference, T> g) {
        return obj -> g.apply((ManagementPreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagementPreference> {
        /**
         * <p>
         * Indicates interest in solutions that are managed by AWS.
         * </p>
         * 
         * @param awsManagedResources
         *        Indicates interest in solutions that are managed by AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsManagedResources(AwsManagedResources awsManagedResources);

        /**
         * <p>
         * Indicates interest in solutions that are managed by AWS.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsManagedResources.Builder} avoiding the
         * need to create one manually via {@link AwsManagedResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsManagedResources.Builder#build()} is called immediately and
         * its result is passed to {@link #awsManagedResources(AwsManagedResources)}.
         * 
         * @param awsManagedResources
         *        a consumer that will call methods on {@link AwsManagedResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsManagedResources(AwsManagedResources)
         */
        default Builder awsManagedResources(Consumer<AwsManagedResources.Builder> awsManagedResources) {
            return awsManagedResources(AwsManagedResources.builder().applyMutation(awsManagedResources).build());
        }

        /**
         * <p>
         * No specific preference.
         * </p>
         * 
         * @param noPreference
         *        No specific preference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noPreference(NoManagementPreference noPreference);

        /**
         * <p>
         * No specific preference.
         * </p>
         * This is a convenience method that creates an instance of the {@link NoManagementPreference.Builder} avoiding
         * the need to create one manually via {@link NoManagementPreference#builder()}.
         *
         * When the {@link Consumer} completes, {@link NoManagementPreference.Builder#build()} is called immediately and
         * its result is passed to {@link #noPreference(NoManagementPreference)}.
         * 
         * @param noPreference
         *        a consumer that will call methods on {@link NoManagementPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noPreference(NoManagementPreference)
         */
        default Builder noPreference(Consumer<NoManagementPreference.Builder> noPreference) {
            return noPreference(NoManagementPreference.builder().applyMutation(noPreference).build());
        }

        /**
         * <p>
         * Indicates interest in managing your own resources on AWS.
         * </p>
         * 
         * @param selfManageResources
         *        Indicates interest in managing your own resources on AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManageResources(SelfManageResources selfManageResources);

        /**
         * <p>
         * Indicates interest in managing your own resources on AWS.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelfManageResources.Builder} avoiding the
         * need to create one manually via {@link SelfManageResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link SelfManageResources.Builder#build()} is called immediately and
         * its result is passed to {@link #selfManageResources(SelfManageResources)}.
         * 
         * @param selfManageResources
         *        a consumer that will call methods on {@link SelfManageResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManageResources(SelfManageResources)
         */
        default Builder selfManageResources(Consumer<SelfManageResources.Builder> selfManageResources) {
            return selfManageResources(SelfManageResources.builder().applyMutation(selfManageResources).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsManagedResources awsManagedResources;

        private NoManagementPreference noPreference;

        private SelfManageResources selfManageResources;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ManagementPreference model) {
            awsManagedResources(model.awsManagedResources);
            noPreference(model.noPreference);
            selfManageResources(model.selfManageResources);
        }

        public final AwsManagedResources.Builder getAwsManagedResources() {
            return awsManagedResources != null ? awsManagedResources.toBuilder() : null;
        }

        public final void setAwsManagedResources(AwsManagedResources.BuilderImpl awsManagedResources) {
            Object oldValue = this.awsManagedResources;
            this.awsManagedResources = awsManagedResources != null ? awsManagedResources.build() : null;
            handleUnionValueChange(Type.AWS_MANAGED_RESOURCES, oldValue, this.awsManagedResources);
        }

        @Override
        public final Builder awsManagedResources(AwsManagedResources awsManagedResources) {
            Object oldValue = this.awsManagedResources;
            this.awsManagedResources = awsManagedResources;
            handleUnionValueChange(Type.AWS_MANAGED_RESOURCES, oldValue, this.awsManagedResources);
            return this;
        }

        public final NoManagementPreference.Builder getNoPreference() {
            return noPreference != null ? noPreference.toBuilder() : null;
        }

        public final void setNoPreference(NoManagementPreference.BuilderImpl noPreference) {
            Object oldValue = this.noPreference;
            this.noPreference = noPreference != null ? noPreference.build() : null;
            handleUnionValueChange(Type.NO_PREFERENCE, oldValue, this.noPreference);
        }

        @Override
        public final Builder noPreference(NoManagementPreference noPreference) {
            Object oldValue = this.noPreference;
            this.noPreference = noPreference;
            handleUnionValueChange(Type.NO_PREFERENCE, oldValue, this.noPreference);
            return this;
        }

        public final SelfManageResources.Builder getSelfManageResources() {
            return selfManageResources != null ? selfManageResources.toBuilder() : null;
        }

        public final void setSelfManageResources(SelfManageResources.BuilderImpl selfManageResources) {
            Object oldValue = this.selfManageResources;
            this.selfManageResources = selfManageResources != null ? selfManageResources.build() : null;
            handleUnionValueChange(Type.SELF_MANAGE_RESOURCES, oldValue, this.selfManageResources);
        }

        @Override
        public final Builder selfManageResources(SelfManageResources selfManageResources) {
            Object oldValue = this.selfManageResources;
            this.selfManageResources = selfManageResources;
            handleUnionValueChange(Type.SELF_MANAGE_RESOURCES, oldValue, this.selfManageResources);
            return this;
        }

        @Override
        public ManagementPreference build() {
            return new ManagementPreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ManagementPreference#type()
     */
    public enum Type {
        AWS_MANAGED_RESOURCES,

        NO_PREFERENCE,

        SELF_MANAGE_RESOURCES,

        UNKNOWN_TO_SDK_VERSION
    }
}
