/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerCriteria {
    NOT_DEFINED("NOT_DEFINED"),
    OS_NAME("OS_NAME"),
    STRATEGY("STRATEGY"),
    DESTINATION("DESTINATION"),
    SERVER_ID("SERVER_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerCriteria> VALUE_MAP;
    private final String value;

    private ServerCriteria(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerCriteria fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerCriteria> knownValues() {
        EnumSet<ServerCriteria> knownValues = EnumSet.allOf(ServerCriteria.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerCriteria.class, ServerCriteria::toString);
    }
}

