/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the summary of the assessment results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentSummary.Builder, AssessmentSummary> {
    private static final SdkField<S3Object> ANTIPATTERN_REPORT_S3_OBJECT_FIELD = SdkField
            .<S3Object> builder(MarshallingType.SDK_POJO).memberName("antipatternReportS3Object")
            .getter(getter(AssessmentSummary::antipatternReportS3Object)).setter(setter(Builder::antipatternReportS3Object))
            .constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportS3Object").build())
            .build();

    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("antipatternReportStatus").getter(getter(AssessmentSummary::antipatternReportStatusAsString))
            .setter(setter(Builder::antipatternReportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatus").build())
            .build();

    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("antipatternReportStatusMessage")
            .getter(getter(AssessmentSummary::antipatternReportStatusMessage))
            .setter(setter(Builder::antipatternReportStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatusMessage")
                    .build()).build();

    private static final SdkField<Instant> LAST_ANALYZED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastAnalyzedTimestamp").getter(getter(AssessmentSummary::lastAnalyzedTimestamp))
            .setter(setter(Builder::lastAnalyzedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAnalyzedTimestamp").build())
            .build();

    private static final SdkField<List<AntipatternSeveritySummary>> LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD = SdkField
            .<List<AntipatternSeveritySummary>> builder(MarshallingType.LIST)
            .memberName("listAntipatternSeveritySummary")
            .getter(getter(AssessmentSummary::listAntipatternSeveritySummary))
            .setter(setter(Builder::listAntipatternSeveritySummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listAntipatternSeveritySummary")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AntipatternSeveritySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AntipatternSeveritySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StrategySummary>> LIST_APPLICATION_COMPONENT_STRATEGY_SUMMARY_FIELD = SdkField
            .<List<StrategySummary>> builder(MarshallingType.LIST)
            .memberName("listApplicationComponentStrategySummary")
            .getter(getter(AssessmentSummary::listApplicationComponentStrategySummary))
            .setter(setter(Builder::listApplicationComponentStrategySummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("listApplicationComponentStrategySummary").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StrategySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StrategySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ApplicationComponentSummary>> LIST_APPLICATION_COMPONENT_SUMMARY_FIELD = SdkField
            .<List<ApplicationComponentSummary>> builder(MarshallingType.LIST)
            .memberName("listApplicationComponentSummary")
            .getter(getter(AssessmentSummary::listApplicationComponentSummary))
            .setter(setter(Builder::listApplicationComponentSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listApplicationComponentSummary")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationComponentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationComponentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StrategySummary>> LIST_SERVER_STRATEGY_SUMMARY_FIELD = SdkField
            .<List<StrategySummary>> builder(MarshallingType.LIST)
            .memberName("listServerStrategySummary")
            .getter(getter(AssessmentSummary::listServerStrategySummary))
            .setter(setter(Builder::listServerStrategySummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listServerStrategySummary").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StrategySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StrategySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServerSummary>> LIST_SERVER_SUMMARY_FIELD = SdkField
            .<List<ServerSummary>> builder(MarshallingType.LIST)
            .memberName("listServerSummary")
            .getter(getter(AssessmentSummary::listServerSummary))
            .setter(setter(Builder::listServerSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listServerSummary").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANTIPATTERN_REPORT_S3_OBJECT_FIELD, ANTIPATTERN_REPORT_STATUS_FIELD, ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD,
            LAST_ANALYZED_TIMESTAMP_FIELD, LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD,
            LIST_APPLICATION_COMPONENT_STRATEGY_SUMMARY_FIELD, LIST_APPLICATION_COMPONENT_SUMMARY_FIELD,
            LIST_SERVER_STRATEGY_SUMMARY_FIELD, LIST_SERVER_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Object antipatternReportS3Object;

    private final String antipatternReportStatus;

    private final String antipatternReportStatusMessage;

    private final Instant lastAnalyzedTimestamp;

    private final List<AntipatternSeveritySummary> listAntipatternSeveritySummary;

    private final List<StrategySummary> listApplicationComponentStrategySummary;

    private final List<ApplicationComponentSummary> listApplicationComponentSummary;

    private final List<StrategySummary> listServerStrategySummary;

    private final List<ServerSummary> listServerSummary;

    private AssessmentSummary(BuilderImpl builder) {
        this.antipatternReportS3Object = builder.antipatternReportS3Object;
        this.antipatternReportStatus = builder.antipatternReportStatus;
        this.antipatternReportStatusMessage = builder.antipatternReportStatusMessage;
        this.lastAnalyzedTimestamp = builder.lastAnalyzedTimestamp;
        this.listAntipatternSeveritySummary = builder.listAntipatternSeveritySummary;
        this.listApplicationComponentStrategySummary = builder.listApplicationComponentStrategySummary;
        this.listApplicationComponentSummary = builder.listApplicationComponentSummary;
        this.listServerStrategySummary = builder.listServerStrategySummary;
        this.listServerSummary = builder.listServerSummary;
    }

    /**
     * <p>
     * The Amazon S3 object containing the anti-pattern report.
     * </p>
     * 
     * @return The Amazon S3 object containing the anti-pattern report.
     */
    public final S3Object antipatternReportS3Object() {
        return antipatternReportS3Object;
    }

    /**
     * <p>
     * The status of the anti-pattern report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #antipatternReportStatus} will return {@link AntipatternReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #antipatternReportStatusAsString}.
     * </p>
     * 
     * @return The status of the anti-pattern report.
     * @see AntipatternReportStatus
     */
    public final AntipatternReportStatus antipatternReportStatus() {
        return AntipatternReportStatus.fromValue(antipatternReportStatus);
    }

    /**
     * <p>
     * The status of the anti-pattern report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #antipatternReportStatus} will return {@link AntipatternReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #antipatternReportStatusAsString}.
     * </p>
     * 
     * @return The status of the anti-pattern report.
     * @see AntipatternReportStatus
     */
    public final String antipatternReportStatusAsString() {
        return antipatternReportStatus;
    }

    /**
     * <p>
     * The status message of the anti-pattern report.
     * </p>
     * 
     * @return The status message of the anti-pattern report.
     */
    public final String antipatternReportStatusMessage() {
        return antipatternReportStatusMessage;
    }

    /**
     * <p>
     * The time the assessment was performed.
     * </p>
     * 
     * @return The time the assessment was performed.
     */
    public final Instant lastAnalyzedTimestamp() {
        return lastAnalyzedTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListAntipatternSeveritySummary property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasListAntipatternSeveritySummary() {
        return listAntipatternSeveritySummary != null && !(listAntipatternSeveritySummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of AntipatternSeveritySummary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListAntipatternSeveritySummary} method.
     * </p>
     * 
     * @return List of AntipatternSeveritySummary.
     */
    public final List<AntipatternSeveritySummary> listAntipatternSeveritySummary() {
        return listAntipatternSeveritySummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListApplicationComponentStrategySummary
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasListApplicationComponentStrategySummary() {
        return listApplicationComponentStrategySummary != null
                && !(listApplicationComponentStrategySummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of ApplicationComponentStrategySummary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasListApplicationComponentStrategySummary} method.
     * </p>
     * 
     * @return List of ApplicationComponentStrategySummary.
     */
    public final List<StrategySummary> listApplicationComponentStrategySummary() {
        return listApplicationComponentStrategySummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListApplicationComponentSummary
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasListApplicationComponentSummary() {
        return listApplicationComponentSummary != null && !(listApplicationComponentSummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of ApplicationComponentSummary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListApplicationComponentSummary}
     * method.
     * </p>
     * 
     * @return List of ApplicationComponentSummary.
     */
    public final List<ApplicationComponentSummary> listApplicationComponentSummary() {
        return listApplicationComponentSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListServerStrategySummary property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasListServerStrategySummary() {
        return listServerStrategySummary != null && !(listServerStrategySummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of ServerStrategySummary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListServerStrategySummary} method.
     * </p>
     * 
     * @return List of ServerStrategySummary.
     */
    public final List<StrategySummary> listServerStrategySummary() {
        return listServerStrategySummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListServerSummary property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListServerSummary() {
        return listServerSummary != null && !(listServerSummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of ServerSummary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListServerSummary} method.
     * </p>
     * 
     * @return List of ServerSummary.
     */
    public final List<ServerSummary> listServerSummary() {
        return listServerSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastAnalyzedTimestamp());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasListAntipatternSeveritySummary() ? listAntipatternSeveritySummary() : null);
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasListApplicationComponentStrategySummary() ? listApplicationComponentStrategySummary()
                        : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasListApplicationComponentSummary() ? listApplicationComponentSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasListServerStrategySummary() ? listServerStrategySummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasListServerSummary() ? listServerSummary() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentSummary)) {
            return false;
        }
        AssessmentSummary other = (AssessmentSummary) obj;
        return Objects.equals(antipatternReportS3Object(), other.antipatternReportS3Object())
                && Objects.equals(antipatternReportStatusAsString(), other.antipatternReportStatusAsString())
                && Objects.equals(antipatternReportStatusMessage(), other.antipatternReportStatusMessage())
                && Objects.equals(lastAnalyzedTimestamp(), other.lastAnalyzedTimestamp())
                && hasListAntipatternSeveritySummary() == other.hasListAntipatternSeveritySummary()
                && Objects.equals(listAntipatternSeveritySummary(), other.listAntipatternSeveritySummary())
                && hasListApplicationComponentStrategySummary() == other.hasListApplicationComponentStrategySummary()
                && Objects.equals(listApplicationComponentStrategySummary(), other.listApplicationComponentStrategySummary())
                && hasListApplicationComponentSummary() == other.hasListApplicationComponentSummary()
                && Objects.equals(listApplicationComponentSummary(), other.listApplicationComponentSummary())
                && hasListServerStrategySummary() == other.hasListServerStrategySummary()
                && Objects.equals(listServerStrategySummary(), other.listServerStrategySummary())
                && hasListServerSummary() == other.hasListServerSummary()
                && Objects.equals(listServerSummary(), other.listServerSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AssessmentSummary")
                .add("AntipatternReportS3Object", antipatternReportS3Object())
                .add("AntipatternReportStatus", antipatternReportStatusAsString())
                .add("AntipatternReportStatusMessage", antipatternReportStatusMessage())
                .add("LastAnalyzedTimestamp", lastAnalyzedTimestamp())
                .add("ListAntipatternSeveritySummary",
                        hasListAntipatternSeveritySummary() ? listAntipatternSeveritySummary() : null)
                .add("ListApplicationComponentStrategySummary",
                        hasListApplicationComponentStrategySummary() ? listApplicationComponentStrategySummary() : null)
                .add("ListApplicationComponentSummary",
                        hasListApplicationComponentSummary() ? listApplicationComponentSummary() : null)
                .add("ListServerStrategySummary", hasListServerStrategySummary() ? listServerStrategySummary() : null)
                .add("ListServerSummary", hasListServerSummary() ? listServerSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "antipatternReportS3Object":
            return Optional.ofNullable(clazz.cast(antipatternReportS3Object()));
        case "antipatternReportStatus":
            return Optional.ofNullable(clazz.cast(antipatternReportStatusAsString()));
        case "antipatternReportStatusMessage":
            return Optional.ofNullable(clazz.cast(antipatternReportStatusMessage()));
        case "lastAnalyzedTimestamp":
            return Optional.ofNullable(clazz.cast(lastAnalyzedTimestamp()));
        case "listAntipatternSeveritySummary":
            return Optional.ofNullable(clazz.cast(listAntipatternSeveritySummary()));
        case "listApplicationComponentStrategySummary":
            return Optional.ofNullable(clazz.cast(listApplicationComponentStrategySummary()));
        case "listApplicationComponentSummary":
            return Optional.ofNullable(clazz.cast(listApplicationComponentSummary()));
        case "listServerStrategySummary":
            return Optional.ofNullable(clazz.cast(listServerStrategySummary()));
        case "listServerSummary":
            return Optional.ofNullable(clazz.cast(listServerSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentSummary, T> g) {
        return obj -> g.apply((AssessmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentSummary> {
        /**
         * <p>
         * The Amazon S3 object containing the anti-pattern report.
         * </p>
         * 
         * @param antipatternReportS3Object
         *        The Amazon S3 object containing the anti-pattern report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antipatternReportS3Object(S3Object antipatternReportS3Object);

        /**
         * <p>
         * The Amazon S3 object containing the anti-pattern report.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Object.Builder} avoiding the need to
         * create one manually via {@link S3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #antipatternReportS3Object(S3Object)}.
         * 
         * @param antipatternReportS3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #antipatternReportS3Object(S3Object)
         */
        default Builder antipatternReportS3Object(Consumer<S3Object.Builder> antipatternReportS3Object) {
            return antipatternReportS3Object(S3Object.builder().applyMutation(antipatternReportS3Object).build());
        }

        /**
         * <p>
         * The status of the anti-pattern report.
         * </p>
         * 
         * @param antipatternReportStatus
         *        The status of the anti-pattern report.
         * @see AntipatternReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AntipatternReportStatus
         */
        Builder antipatternReportStatus(String antipatternReportStatus);

        /**
         * <p>
         * The status of the anti-pattern report.
         * </p>
         * 
         * @param antipatternReportStatus
         *        The status of the anti-pattern report.
         * @see AntipatternReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AntipatternReportStatus
         */
        Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus);

        /**
         * <p>
         * The status message of the anti-pattern report.
         * </p>
         * 
         * @param antipatternReportStatusMessage
         *        The status message of the anti-pattern report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antipatternReportStatusMessage(String antipatternReportStatusMessage);

        /**
         * <p>
         * The time the assessment was performed.
         * </p>
         * 
         * @param lastAnalyzedTimestamp
         *        The time the assessment was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAnalyzedTimestamp(Instant lastAnalyzedTimestamp);

        /**
         * <p>
         * List of AntipatternSeveritySummary.
         * </p>
         * 
         * @param listAntipatternSeveritySummary
         *        List of AntipatternSeveritySummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> listAntipatternSeveritySummary);

        /**
         * <p>
         * List of AntipatternSeveritySummary.
         * </p>
         * 
         * @param listAntipatternSeveritySummary
         *        List of AntipatternSeveritySummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listAntipatternSeveritySummary(AntipatternSeveritySummary... listAntipatternSeveritySummary);

        /**
         * <p>
         * List of AntipatternSeveritySummary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #listAntipatternSeveritySummary(List<AntipatternSeveritySummary>)}.
         * 
         * @param listAntipatternSeveritySummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listAntipatternSeveritySummary(java.util.Collection<AntipatternSeveritySummary>)
         */
        Builder listAntipatternSeveritySummary(Consumer<AntipatternSeveritySummary.Builder>... listAntipatternSeveritySummary);

        /**
         * <p>
         * List of ApplicationComponentStrategySummary.
         * </p>
         * 
         * @param listApplicationComponentStrategySummary
         *        List of ApplicationComponentStrategySummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listApplicationComponentStrategySummary(Collection<StrategySummary> listApplicationComponentStrategySummary);

        /**
         * <p>
         * List of ApplicationComponentStrategySummary.
         * </p>
         * 
         * @param listApplicationComponentStrategySummary
         *        List of ApplicationComponentStrategySummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listApplicationComponentStrategySummary(StrategySummary... listApplicationComponentStrategySummary);

        /**
         * <p>
         * List of ApplicationComponentStrategySummary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #listApplicationComponentStrategySummary(List<StrategySummary>)}.
         * 
         * @param listApplicationComponentStrategySummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listApplicationComponentStrategySummary(java.util.Collection<StrategySummary>)
         */
        Builder listApplicationComponentStrategySummary(
                Consumer<StrategySummary.Builder>... listApplicationComponentStrategySummary);

        /**
         * <p>
         * List of ApplicationComponentSummary.
         * </p>
         * 
         * @param listApplicationComponentSummary
         *        List of ApplicationComponentSummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listApplicationComponentSummary(Collection<ApplicationComponentSummary> listApplicationComponentSummary);

        /**
         * <p>
         * List of ApplicationComponentSummary.
         * </p>
         * 
         * @param listApplicationComponentSummary
         *        List of ApplicationComponentSummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listApplicationComponentSummary(ApplicationComponentSummary... listApplicationComponentSummary);

        /**
         * <p>
         * List of ApplicationComponentSummary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #listApplicationComponentSummary(List<ApplicationComponentSummary>)}.
         * 
         * @param listApplicationComponentSummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listApplicationComponentSummary(java.util.Collection<ApplicationComponentSummary>)
         */
        Builder listApplicationComponentSummary(Consumer<ApplicationComponentSummary.Builder>... listApplicationComponentSummary);

        /**
         * <p>
         * List of ServerStrategySummary.
         * </p>
         * 
         * @param listServerStrategySummary
         *        List of ServerStrategySummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listServerStrategySummary(Collection<StrategySummary> listServerStrategySummary);

        /**
         * <p>
         * List of ServerStrategySummary.
         * </p>
         * 
         * @param listServerStrategySummary
         *        List of ServerStrategySummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listServerStrategySummary(StrategySummary... listServerStrategySummary);

        /**
         * <p>
         * List of ServerStrategySummary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #listServerStrategySummary(List<StrategySummary>)}.
         * 
         * @param listServerStrategySummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listServerStrategySummary(java.util.Collection<StrategySummary>)
         */
        Builder listServerStrategySummary(Consumer<StrategySummary.Builder>... listServerStrategySummary);

        /**
         * <p>
         * List of ServerSummary.
         * </p>
         * 
         * @param listServerSummary
         *        List of ServerSummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listServerSummary(Collection<ServerSummary> listServerSummary);

        /**
         * <p>
         * List of ServerSummary.
         * </p>
         * 
         * @param listServerSummary
         *        List of ServerSummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listServerSummary(ServerSummary... listServerSummary);

        /**
         * <p>
         * List of ServerSummary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.ServerSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.ServerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.ServerSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #listServerSummary(List<ServerSummary>)}.
         * 
         * @param listServerSummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ServerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listServerSummary(java.util.Collection<ServerSummary>)
         */
        Builder listServerSummary(Consumer<ServerSummary.Builder>... listServerSummary);
    }

    static final class BuilderImpl implements Builder {
        private S3Object antipatternReportS3Object;

        private String antipatternReportStatus;

        private String antipatternReportStatusMessage;

        private Instant lastAnalyzedTimestamp;

        private List<AntipatternSeveritySummary> listAntipatternSeveritySummary = DefaultSdkAutoConstructList.getInstance();

        private List<StrategySummary> listApplicationComponentStrategySummary = DefaultSdkAutoConstructList.getInstance();

        private List<ApplicationComponentSummary> listApplicationComponentSummary = DefaultSdkAutoConstructList.getInstance();

        private List<StrategySummary> listServerStrategySummary = DefaultSdkAutoConstructList.getInstance();

        private List<ServerSummary> listServerSummary = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentSummary model) {
            antipatternReportS3Object(model.antipatternReportS3Object);
            antipatternReportStatus(model.antipatternReportStatus);
            antipatternReportStatusMessage(model.antipatternReportStatusMessage);
            lastAnalyzedTimestamp(model.lastAnalyzedTimestamp);
            listAntipatternSeveritySummary(model.listAntipatternSeveritySummary);
            listApplicationComponentStrategySummary(model.listApplicationComponentStrategySummary);
            listApplicationComponentSummary(model.listApplicationComponentSummary);
            listServerStrategySummary(model.listServerStrategySummary);
            listServerSummary(model.listServerSummary);
        }

        public final S3Object.Builder getAntipatternReportS3Object() {
            return antipatternReportS3Object != null ? antipatternReportS3Object.toBuilder() : null;
        }

        public final void setAntipatternReportS3Object(S3Object.BuilderImpl antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object != null ? antipatternReportS3Object.build() : null;
        }

        @Override
        public final Builder antipatternReportS3Object(S3Object antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object;
            return this;
        }

        public final String getAntipatternReportStatus() {
            return antipatternReportStatus;
        }

        public final void setAntipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
        }

        @Override
        public final Builder antipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
            return this;
        }

        @Override
        public final Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus) {
            this.antipatternReportStatus(antipatternReportStatus == null ? null : antipatternReportStatus.toString());
            return this;
        }

        public final String getAntipatternReportStatusMessage() {
            return antipatternReportStatusMessage;
        }

        public final void setAntipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
        }

        @Override
        public final Builder antipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
            return this;
        }

        public final Instant getLastAnalyzedTimestamp() {
            return lastAnalyzedTimestamp;
        }

        public final void setLastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
        }

        @Override
        public final Builder lastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
            return this;
        }

        public final List<AntipatternSeveritySummary.Builder> getListAntipatternSeveritySummary() {
            List<AntipatternSeveritySummary.Builder> result = ListAntipatternSeveritySummaryCopier
                    .copyToBuilder(this.listAntipatternSeveritySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListAntipatternSeveritySummary(
                Collection<AntipatternSeveritySummary.BuilderImpl> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier
                    .copyFromBuilder(listAntipatternSeveritySummary);
        }

        @Override
        public final Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier.copy(listAntipatternSeveritySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(AntipatternSeveritySummary... listAntipatternSeveritySummary) {
            listAntipatternSeveritySummary(Arrays.asList(listAntipatternSeveritySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(
                Consumer<AntipatternSeveritySummary.Builder>... listAntipatternSeveritySummary) {
            listAntipatternSeveritySummary(Stream.of(listAntipatternSeveritySummary)
                    .map(c -> AntipatternSeveritySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StrategySummary.Builder> getListApplicationComponentStrategySummary() {
            List<StrategySummary.Builder> result = ListStrategySummaryCopier
                    .copyToBuilder(this.listApplicationComponentStrategySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListApplicationComponentStrategySummary(
                Collection<StrategySummary.BuilderImpl> listApplicationComponentStrategySummary) {
            this.listApplicationComponentStrategySummary = ListStrategySummaryCopier
                    .copyFromBuilder(listApplicationComponentStrategySummary);
        }

        @Override
        public final Builder listApplicationComponentStrategySummary(
                Collection<StrategySummary> listApplicationComponentStrategySummary) {
            this.listApplicationComponentStrategySummary = ListStrategySummaryCopier
                    .copy(listApplicationComponentStrategySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listApplicationComponentStrategySummary(StrategySummary... listApplicationComponentStrategySummary) {
            listApplicationComponentStrategySummary(Arrays.asList(listApplicationComponentStrategySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listApplicationComponentStrategySummary(
                Consumer<StrategySummary.Builder>... listApplicationComponentStrategySummary) {
            listApplicationComponentStrategySummary(Stream.of(listApplicationComponentStrategySummary)
                    .map(c -> StrategySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ApplicationComponentSummary.Builder> getListApplicationComponentSummary() {
            List<ApplicationComponentSummary.Builder> result = ListApplicationComponentSummaryCopier
                    .copyToBuilder(this.listApplicationComponentSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListApplicationComponentSummary(
                Collection<ApplicationComponentSummary.BuilderImpl> listApplicationComponentSummary) {
            this.listApplicationComponentSummary = ListApplicationComponentSummaryCopier
                    .copyFromBuilder(listApplicationComponentSummary);
        }

        @Override
        public final Builder listApplicationComponentSummary(
                Collection<ApplicationComponentSummary> listApplicationComponentSummary) {
            this.listApplicationComponentSummary = ListApplicationComponentSummaryCopier.copy(listApplicationComponentSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listApplicationComponentSummary(ApplicationComponentSummary... listApplicationComponentSummary) {
            listApplicationComponentSummary(Arrays.asList(listApplicationComponentSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listApplicationComponentSummary(
                Consumer<ApplicationComponentSummary.Builder>... listApplicationComponentSummary) {
            listApplicationComponentSummary(Stream.of(listApplicationComponentSummary)
                    .map(c -> ApplicationComponentSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StrategySummary.Builder> getListServerStrategySummary() {
            List<StrategySummary.Builder> result = ListStrategySummaryCopier.copyToBuilder(this.listServerStrategySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListServerStrategySummary(Collection<StrategySummary.BuilderImpl> listServerStrategySummary) {
            this.listServerStrategySummary = ListStrategySummaryCopier.copyFromBuilder(listServerStrategySummary);
        }

        @Override
        public final Builder listServerStrategySummary(Collection<StrategySummary> listServerStrategySummary) {
            this.listServerStrategySummary = ListStrategySummaryCopier.copy(listServerStrategySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listServerStrategySummary(StrategySummary... listServerStrategySummary) {
            listServerStrategySummary(Arrays.asList(listServerStrategySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listServerStrategySummary(Consumer<StrategySummary.Builder>... listServerStrategySummary) {
            listServerStrategySummary(Stream.of(listServerStrategySummary)
                    .map(c -> StrategySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServerSummary.Builder> getListServerSummary() {
            List<ServerSummary.Builder> result = ListServerSummaryCopier.copyToBuilder(this.listServerSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListServerSummary(Collection<ServerSummary.BuilderImpl> listServerSummary) {
            this.listServerSummary = ListServerSummaryCopier.copyFromBuilder(listServerSummary);
        }

        @Override
        public final Builder listServerSummary(Collection<ServerSummary> listServerSummary) {
            this.listServerSummary = ListServerSummaryCopier.copy(listServerSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listServerSummary(ServerSummary... listServerSummary) {
            listServerSummary(Arrays.asList(listServerSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listServerSummary(Consumer<ServerSummary.Builder>... listServerSummary) {
            listServerSummary(Stream.of(listServerSummary).map(c -> ServerSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssessmentSummary build() {
            return new AssessmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
