/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerDetail implements SdkPojo, Serializable, ToCopyableBuilder<ServerDetail.Builder, ServerDetail> {
    private static final SdkField<S3Object> ANTIPATTERN_REPORT_S3_OBJECT_FIELD = SdkField
            .<S3Object> builder(MarshallingType.SDK_POJO).memberName("antipatternReportS3Object")
            .getter(getter(ServerDetail::antipatternReportS3Object)).setter(setter(Builder::antipatternReportS3Object))
            .constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportS3Object").build())
            .build();

    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("antipatternReportStatus").getter(getter(ServerDetail::antipatternReportStatusAsString))
            .setter(setter(Builder::antipatternReportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatus").build())
            .build();

    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("antipatternReportStatusMessage")
            .getter(getter(ServerDetail::antipatternReportStatusMessage))
            .setter(setter(Builder::antipatternReportStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatusMessage")
                    .build()).build();

    private static final SdkField<List<StrategySummary>> APPLICATION_COMPONENT_STRATEGY_SUMMARY_FIELD = SdkField
            .<List<StrategySummary>> builder(MarshallingType.LIST)
            .memberName("applicationComponentStrategySummary")
            .getter(getter(ServerDetail::applicationComponentStrategySummary))
            .setter(setter(Builder::applicationComponentStrategySummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("applicationComponentStrategySummary").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StrategySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StrategySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_COLLECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataCollectionStatus").getter(getter(ServerDetail::dataCollectionStatusAsString))
            .setter(setter(Builder::dataCollectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCollectionStatus").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ServerDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_ANALYZED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastAnalyzedTimestamp").getter(getter(ServerDetail::lastAnalyzedTimestamp))
            .setter(setter(Builder::lastAnalyzedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAnalyzedTimestamp").build())
            .build();

    private static final SdkField<List<AntipatternSeveritySummary>> LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD = SdkField
            .<List<AntipatternSeveritySummary>> builder(MarshallingType.LIST)
            .memberName("listAntipatternSeveritySummary")
            .getter(getter(ServerDetail::listAntipatternSeveritySummary))
            .setter(setter(Builder::listAntipatternSeveritySummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listAntipatternSeveritySummary")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AntipatternSeveritySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AntipatternSeveritySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServerDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<RecommendationSet> RECOMMENDATION_SET_FIELD = SdkField
            .<RecommendationSet> builder(MarshallingType.SDK_POJO).memberName("recommendationSet")
            .getter(getter(ServerDetail::recommendationSet)).setter(setter(Builder::recommendationSet))
            .constructor(RecommendationSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSet").build()).build();

    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverType").getter(getter(ServerDetail::serverType)).setter(setter(Builder::serverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ServerDetail::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<SystemInfo> SYSTEM_INFO_FIELD = SdkField.<SystemInfo> builder(MarshallingType.SDK_POJO)
            .memberName("systemInfo").getter(getter(ServerDetail::systemInfo)).setter(setter(Builder::systemInfo))
            .constructor(SystemInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANTIPATTERN_REPORT_S3_OBJECT_FIELD, ANTIPATTERN_REPORT_STATUS_FIELD, ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD,
            APPLICATION_COMPONENT_STRATEGY_SUMMARY_FIELD, DATA_COLLECTION_STATUS_FIELD, ID_FIELD, LAST_ANALYZED_TIMESTAMP_FIELD,
            LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD, NAME_FIELD, RECOMMENDATION_SET_FIELD, SERVER_TYPE_FIELD,
            STATUS_MESSAGE_FIELD, SYSTEM_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Object antipatternReportS3Object;

    private final String antipatternReportStatus;

    private final String antipatternReportStatusMessage;

    private final List<StrategySummary> applicationComponentStrategySummary;

    private final String dataCollectionStatus;

    private final String id;

    private final Instant lastAnalyzedTimestamp;

    private final List<AntipatternSeveritySummary> listAntipatternSeveritySummary;

    private final String name;

    private final RecommendationSet recommendationSet;

    private final String serverType;

    private final String statusMessage;

    private final SystemInfo systemInfo;

    private ServerDetail(BuilderImpl builder) {
        this.antipatternReportS3Object = builder.antipatternReportS3Object;
        this.antipatternReportStatus = builder.antipatternReportStatus;
        this.antipatternReportStatusMessage = builder.antipatternReportStatusMessage;
        this.applicationComponentStrategySummary = builder.applicationComponentStrategySummary;
        this.dataCollectionStatus = builder.dataCollectionStatus;
        this.id = builder.id;
        this.lastAnalyzedTimestamp = builder.lastAnalyzedTimestamp;
        this.listAntipatternSeveritySummary = builder.listAntipatternSeveritySummary;
        this.name = builder.name;
        this.recommendationSet = builder.recommendationSet;
        this.serverType = builder.serverType;
        this.statusMessage = builder.statusMessage;
        this.systemInfo = builder.systemInfo;
    }

    /**
     * <p>
     * The S3 bucket name and Amazon S3 key name for anti-pattern report.
     * </p>
     * 
     * @return The S3 bucket name and Amazon S3 key name for anti-pattern report.
     */
    public final S3Object antipatternReportS3Object() {
        return antipatternReportS3Object;
    }

    /**
     * <p>
     * The status of the anti-pattern report generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #antipatternReportStatus} will return {@link AntipatternReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #antipatternReportStatusAsString}.
     * </p>
     * 
     * @return The status of the anti-pattern report generation.
     * @see AntipatternReportStatus
     */
    public final AntipatternReportStatus antipatternReportStatus() {
        return AntipatternReportStatus.fromValue(antipatternReportStatus);
    }

    /**
     * <p>
     * The status of the anti-pattern report generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #antipatternReportStatus} will return {@link AntipatternReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #antipatternReportStatusAsString}.
     * </p>
     * 
     * @return The status of the anti-pattern report generation.
     * @see AntipatternReportStatus
     */
    public final String antipatternReportStatusAsString() {
        return antipatternReportStatus;
    }

    /**
     * <p>
     * A message about the status of the anti-pattern report generation.
     * </p>
     * 
     * @return A message about the status of the anti-pattern report generation.
     */
    public final String antipatternReportStatusMessage() {
        return antipatternReportStatusMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationComponentStrategySummary
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasApplicationComponentStrategySummary() {
        return applicationComponentStrategySummary != null
                && !(applicationComponentStrategySummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strategy summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationComponentStrategySummary}
     * method.
     * </p>
     * 
     * @return A list of strategy summaries.
     */
    public final List<StrategySummary> applicationComponentStrategySummary() {
        return applicationComponentStrategySummary;
    }

    /**
     * <p>
     * The status of assessment for the server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataCollectionStatus} will return {@link RunTimeAssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataCollectionStatusAsString}.
     * </p>
     * 
     * @return The status of assessment for the server.
     * @see RunTimeAssessmentStatus
     */
    public final RunTimeAssessmentStatus dataCollectionStatus() {
        return RunTimeAssessmentStatus.fromValue(dataCollectionStatus);
    }

    /**
     * <p>
     * The status of assessment for the server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataCollectionStatus} will return {@link RunTimeAssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataCollectionStatusAsString}.
     * </p>
     * 
     * @return The status of assessment for the server.
     * @see RunTimeAssessmentStatus
     */
    public final String dataCollectionStatusAsString() {
        return dataCollectionStatus;
    }

    /**
     * <p>
     * The server ID.
     * </p>
     * 
     * @return The server ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The timestamp of when the server was assessed.
     * </p>
     * 
     * @return The timestamp of when the server was assessed.
     */
    public final Instant lastAnalyzedTimestamp() {
        return lastAnalyzedTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListAntipatternSeveritySummary property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasListAntipatternSeveritySummary() {
        return listAntipatternSeveritySummary != null && !(listAntipatternSeveritySummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of anti-pattern severity summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListAntipatternSeveritySummary} method.
     * </p>
     * 
     * @return A list of anti-pattern severity summaries.
     */
    public final List<AntipatternSeveritySummary> listAntipatternSeveritySummary() {
        return listAntipatternSeveritySummary;
    }

    /**
     * <p>
     * The name of the server.
     * </p>
     * 
     * @return The name of the server.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A set of recommendations.
     * </p>
     * 
     * @return A set of recommendations.
     */
    public final RecommendationSet recommendationSet() {
        return recommendationSet;
    }

    /**
     * <p>
     * The type of server.
     * </p>
     * 
     * @return The type of server.
     */
    public final String serverType() {
        return serverType;
    }

    /**
     * <p>
     * A message about the status of data collection, which contains detailed descriptions of any error messages.
     * </p>
     * 
     * @return A message about the status of data collection, which contains detailed descriptions of any error
     *         messages.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * System information about the server.
     * </p>
     * 
     * @return System information about the server.
     */
    public final SystemInfo systemInfo() {
        return systemInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportStatusMessage());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasApplicationComponentStrategySummary() ? applicationComponentStrategySummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataCollectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastAnalyzedTimestamp());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasListAntipatternSeveritySummary() ? listAntipatternSeveritySummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationSet());
        hashCode = 31 * hashCode + Objects.hashCode(serverType());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(systemInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerDetail)) {
            return false;
        }
        ServerDetail other = (ServerDetail) obj;
        return Objects.equals(antipatternReportS3Object(), other.antipatternReportS3Object())
                && Objects.equals(antipatternReportStatusAsString(), other.antipatternReportStatusAsString())
                && Objects.equals(antipatternReportStatusMessage(), other.antipatternReportStatusMessage())
                && hasApplicationComponentStrategySummary() == other.hasApplicationComponentStrategySummary()
                && Objects.equals(applicationComponentStrategySummary(), other.applicationComponentStrategySummary())
                && Objects.equals(dataCollectionStatusAsString(), other.dataCollectionStatusAsString())
                && Objects.equals(id(), other.id()) && Objects.equals(lastAnalyzedTimestamp(), other.lastAnalyzedTimestamp())
                && hasListAntipatternSeveritySummary() == other.hasListAntipatternSeveritySummary()
                && Objects.equals(listAntipatternSeveritySummary(), other.listAntipatternSeveritySummary())
                && Objects.equals(name(), other.name()) && Objects.equals(recommendationSet(), other.recommendationSet())
                && Objects.equals(serverType(), other.serverType()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(systemInfo(), other.systemInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ServerDetail")
                .add("AntipatternReportS3Object", antipatternReportS3Object())
                .add("AntipatternReportStatus", antipatternReportStatusAsString())
                .add("AntipatternReportStatusMessage", antipatternReportStatusMessage())
                .add("ApplicationComponentStrategySummary",
                        hasApplicationComponentStrategySummary() ? applicationComponentStrategySummary() : null)
                .add("DataCollectionStatus", dataCollectionStatusAsString())
                .add("Id", id())
                .add("LastAnalyzedTimestamp", lastAnalyzedTimestamp())
                .add("ListAntipatternSeveritySummary",
                        hasListAntipatternSeveritySummary() ? listAntipatternSeveritySummary() : null).add("Name", name())
                .add("RecommendationSet", recommendationSet()).add("ServerType", serverType())
                .add("StatusMessage", statusMessage()).add("SystemInfo", systemInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "antipatternReportS3Object":
            return Optional.ofNullable(clazz.cast(antipatternReportS3Object()));
        case "antipatternReportStatus":
            return Optional.ofNullable(clazz.cast(antipatternReportStatusAsString()));
        case "antipatternReportStatusMessage":
            return Optional.ofNullable(clazz.cast(antipatternReportStatusMessage()));
        case "applicationComponentStrategySummary":
            return Optional.ofNullable(clazz.cast(applicationComponentStrategySummary()));
        case "dataCollectionStatus":
            return Optional.ofNullable(clazz.cast(dataCollectionStatusAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastAnalyzedTimestamp":
            return Optional.ofNullable(clazz.cast(lastAnalyzedTimestamp()));
        case "listAntipatternSeveritySummary":
            return Optional.ofNullable(clazz.cast(listAntipatternSeveritySummary()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "recommendationSet":
            return Optional.ofNullable(clazz.cast(recommendationSet()));
        case "serverType":
            return Optional.ofNullable(clazz.cast(serverType()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "systemInfo":
            return Optional.ofNullable(clazz.cast(systemInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerDetail, T> g) {
        return obj -> g.apply((ServerDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerDetail> {
        /**
         * <p>
         * The S3 bucket name and Amazon S3 key name for anti-pattern report.
         * </p>
         * 
         * @param antipatternReportS3Object
         *        The S3 bucket name and Amazon S3 key name for anti-pattern report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antipatternReportS3Object(S3Object antipatternReportS3Object);

        /**
         * <p>
         * The S3 bucket name and Amazon S3 key name for anti-pattern report.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Object.Builder} avoiding the need to
         * create one manually via {@link S3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #antipatternReportS3Object(S3Object)}.
         * 
         * @param antipatternReportS3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #antipatternReportS3Object(S3Object)
         */
        default Builder antipatternReportS3Object(Consumer<S3Object.Builder> antipatternReportS3Object) {
            return antipatternReportS3Object(S3Object.builder().applyMutation(antipatternReportS3Object).build());
        }

        /**
         * <p>
         * The status of the anti-pattern report generation.
         * </p>
         * 
         * @param antipatternReportStatus
         *        The status of the anti-pattern report generation.
         * @see AntipatternReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AntipatternReportStatus
         */
        Builder antipatternReportStatus(String antipatternReportStatus);

        /**
         * <p>
         * The status of the anti-pattern report generation.
         * </p>
         * 
         * @param antipatternReportStatus
         *        The status of the anti-pattern report generation.
         * @see AntipatternReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AntipatternReportStatus
         */
        Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus);

        /**
         * <p>
         * A message about the status of the anti-pattern report generation.
         * </p>
         * 
         * @param antipatternReportStatusMessage
         *        A message about the status of the anti-pattern report generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antipatternReportStatusMessage(String antipatternReportStatusMessage);

        /**
         * <p>
         * A list of strategy summaries.
         * </p>
         * 
         * @param applicationComponentStrategySummary
         *        A list of strategy summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponentStrategySummary(Collection<StrategySummary> applicationComponentStrategySummary);

        /**
         * <p>
         * A list of strategy summaries.
         * </p>
         * 
         * @param applicationComponentStrategySummary
         *        A list of strategy summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponentStrategySummary(StrategySummary... applicationComponentStrategySummary);

        /**
         * <p>
         * A list of strategy summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationComponentStrategySummary(List<StrategySummary>)}.
         * 
         * @param applicationComponentStrategySummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationComponentStrategySummary(java.util.Collection<StrategySummary>)
         */
        Builder applicationComponentStrategySummary(Consumer<StrategySummary.Builder>... applicationComponentStrategySummary);

        /**
         * <p>
         * The status of assessment for the server.
         * </p>
         * 
         * @param dataCollectionStatus
         *        The status of assessment for the server.
         * @see RunTimeAssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunTimeAssessmentStatus
         */
        Builder dataCollectionStatus(String dataCollectionStatus);

        /**
         * <p>
         * The status of assessment for the server.
         * </p>
         * 
         * @param dataCollectionStatus
         *        The status of assessment for the server.
         * @see RunTimeAssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunTimeAssessmentStatus
         */
        Builder dataCollectionStatus(RunTimeAssessmentStatus dataCollectionStatus);

        /**
         * <p>
         * The server ID.
         * </p>
         * 
         * @param id
         *        The server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The timestamp of when the server was assessed.
         * </p>
         * 
         * @param lastAnalyzedTimestamp
         *        The timestamp of when the server was assessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAnalyzedTimestamp(Instant lastAnalyzedTimestamp);

        /**
         * <p>
         * A list of anti-pattern severity summaries.
         * </p>
         * 
         * @param listAntipatternSeveritySummary
         *        A list of anti-pattern severity summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> listAntipatternSeveritySummary);

        /**
         * <p>
         * A list of anti-pattern severity summaries.
         * </p>
         * 
         * @param listAntipatternSeveritySummary
         *        A list of anti-pattern severity summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listAntipatternSeveritySummary(AntipatternSeveritySummary... listAntipatternSeveritySummary);

        /**
         * <p>
         * A list of anti-pattern severity summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #listAntipatternSeveritySummary(List<AntipatternSeveritySummary>)}.
         * 
         * @param listAntipatternSeveritySummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listAntipatternSeveritySummary(java.util.Collection<AntipatternSeveritySummary>)
         */
        Builder listAntipatternSeveritySummary(Consumer<AntipatternSeveritySummary.Builder>... listAntipatternSeveritySummary);

        /**
         * <p>
         * The name of the server.
         * </p>
         * 
         * @param name
         *        The name of the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A set of recommendations.
         * </p>
         * 
         * @param recommendationSet
         *        A set of recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationSet(RecommendationSet recommendationSet);

        /**
         * <p>
         * A set of recommendations.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationSet.Builder} avoiding the
         * need to create one manually via {@link RecommendationSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #recommendationSet(RecommendationSet)}.
         * 
         * @param recommendationSet
         *        a consumer that will call methods on {@link RecommendationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationSet(RecommendationSet)
         */
        default Builder recommendationSet(Consumer<RecommendationSet.Builder> recommendationSet) {
            return recommendationSet(RecommendationSet.builder().applyMutation(recommendationSet).build());
        }

        /**
         * <p>
         * The type of server.
         * </p>
         * 
         * @param serverType
         *        The type of server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverType(String serverType);

        /**
         * <p>
         * A message about the status of data collection, which contains detailed descriptions of any error messages.
         * </p>
         * 
         * @param statusMessage
         *        A message about the status of data collection, which contains detailed descriptions of any error
         *        messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * System information about the server.
         * </p>
         * 
         * @param systemInfo
         *        System information about the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemInfo(SystemInfo systemInfo);

        /**
         * <p>
         * System information about the server.
         * </p>
         * This is a convenience method that creates an instance of the {@link SystemInfo.Builder} avoiding the need to
         * create one manually via {@link SystemInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SystemInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #systemInfo(SystemInfo)}.
         * 
         * @param systemInfo
         *        a consumer that will call methods on {@link SystemInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemInfo(SystemInfo)
         */
        default Builder systemInfo(Consumer<SystemInfo.Builder> systemInfo) {
            return systemInfo(SystemInfo.builder().applyMutation(systemInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Object antipatternReportS3Object;

        private String antipatternReportStatus;

        private String antipatternReportStatusMessage;

        private List<StrategySummary> applicationComponentStrategySummary = DefaultSdkAutoConstructList.getInstance();

        private String dataCollectionStatus;

        private String id;

        private Instant lastAnalyzedTimestamp;

        private List<AntipatternSeveritySummary> listAntipatternSeveritySummary = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private RecommendationSet recommendationSet;

        private String serverType;

        private String statusMessage;

        private SystemInfo systemInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerDetail model) {
            antipatternReportS3Object(model.antipatternReportS3Object);
            antipatternReportStatus(model.antipatternReportStatus);
            antipatternReportStatusMessage(model.antipatternReportStatusMessage);
            applicationComponentStrategySummary(model.applicationComponentStrategySummary);
            dataCollectionStatus(model.dataCollectionStatus);
            id(model.id);
            lastAnalyzedTimestamp(model.lastAnalyzedTimestamp);
            listAntipatternSeveritySummary(model.listAntipatternSeveritySummary);
            name(model.name);
            recommendationSet(model.recommendationSet);
            serverType(model.serverType);
            statusMessage(model.statusMessage);
            systemInfo(model.systemInfo);
        }

        public final S3Object.Builder getAntipatternReportS3Object() {
            return antipatternReportS3Object != null ? antipatternReportS3Object.toBuilder() : null;
        }

        public final void setAntipatternReportS3Object(S3Object.BuilderImpl antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object != null ? antipatternReportS3Object.build() : null;
        }

        @Override
        public final Builder antipatternReportS3Object(S3Object antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object;
            return this;
        }

        public final String getAntipatternReportStatus() {
            return antipatternReportStatus;
        }

        public final void setAntipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
        }

        @Override
        public final Builder antipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
            return this;
        }

        @Override
        public final Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus) {
            this.antipatternReportStatus(antipatternReportStatus == null ? null : antipatternReportStatus.toString());
            return this;
        }

        public final String getAntipatternReportStatusMessage() {
            return antipatternReportStatusMessage;
        }

        public final void setAntipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
        }

        @Override
        public final Builder antipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
            return this;
        }

        public final List<StrategySummary.Builder> getApplicationComponentStrategySummary() {
            List<StrategySummary.Builder> result = ListStrategySummaryCopier
                    .copyToBuilder(this.applicationComponentStrategySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationComponentStrategySummary(
                Collection<StrategySummary.BuilderImpl> applicationComponentStrategySummary) {
            this.applicationComponentStrategySummary = ListStrategySummaryCopier
                    .copyFromBuilder(applicationComponentStrategySummary);
        }

        @Override
        public final Builder applicationComponentStrategySummary(Collection<StrategySummary> applicationComponentStrategySummary) {
            this.applicationComponentStrategySummary = ListStrategySummaryCopier.copy(applicationComponentStrategySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationComponentStrategySummary(StrategySummary... applicationComponentStrategySummary) {
            applicationComponentStrategySummary(Arrays.asList(applicationComponentStrategySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationComponentStrategySummary(
                Consumer<StrategySummary.Builder>... applicationComponentStrategySummary) {
            applicationComponentStrategySummary(Stream.of(applicationComponentStrategySummary)
                    .map(c -> StrategySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataCollectionStatus() {
            return dataCollectionStatus;
        }

        public final void setDataCollectionStatus(String dataCollectionStatus) {
            this.dataCollectionStatus = dataCollectionStatus;
        }

        @Override
        public final Builder dataCollectionStatus(String dataCollectionStatus) {
            this.dataCollectionStatus = dataCollectionStatus;
            return this;
        }

        @Override
        public final Builder dataCollectionStatus(RunTimeAssessmentStatus dataCollectionStatus) {
            this.dataCollectionStatus(dataCollectionStatus == null ? null : dataCollectionStatus.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastAnalyzedTimestamp() {
            return lastAnalyzedTimestamp;
        }

        public final void setLastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
        }

        @Override
        public final Builder lastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
            return this;
        }

        public final List<AntipatternSeveritySummary.Builder> getListAntipatternSeveritySummary() {
            List<AntipatternSeveritySummary.Builder> result = ListAntipatternSeveritySummaryCopier
                    .copyToBuilder(this.listAntipatternSeveritySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListAntipatternSeveritySummary(
                Collection<AntipatternSeveritySummary.BuilderImpl> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier
                    .copyFromBuilder(listAntipatternSeveritySummary);
        }

        @Override
        public final Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier.copy(listAntipatternSeveritySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(AntipatternSeveritySummary... listAntipatternSeveritySummary) {
            listAntipatternSeveritySummary(Arrays.asList(listAntipatternSeveritySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(
                Consumer<AntipatternSeveritySummary.Builder>... listAntipatternSeveritySummary) {
            listAntipatternSeveritySummary(Stream.of(listAntipatternSeveritySummary)
                    .map(c -> AntipatternSeveritySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RecommendationSet.Builder getRecommendationSet() {
            return recommendationSet != null ? recommendationSet.toBuilder() : null;
        }

        public final void setRecommendationSet(RecommendationSet.BuilderImpl recommendationSet) {
            this.recommendationSet = recommendationSet != null ? recommendationSet.build() : null;
        }

        @Override
        public final Builder recommendationSet(RecommendationSet recommendationSet) {
            this.recommendationSet = recommendationSet;
            return this;
        }

        public final String getServerType() {
            return serverType;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final SystemInfo.Builder getSystemInfo() {
            return systemInfo != null ? systemInfo.toBuilder() : null;
        }

        public final void setSystemInfo(SystemInfo.BuilderImpl systemInfo) {
            this.systemInfo = systemInfo != null ? systemInfo.build() : null;
        }

        @Override
        public final Builder systemInfo(SystemInfo systemInfo) {
            this.systemInfo = systemInfo;
            return this;
        }

        @Override
        public ServerDetail build() {
            return new ServerDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
