/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the summary of anti-patterns and their severity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AntipatternSeveritySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AntipatternSeveritySummary.Builder, AntipatternSeveritySummary> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(AntipatternSeveritySummary::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("severity").getter(getter(AntipatternSeveritySummary::severityAsString))
            .setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, SEVERITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final String severity;

    private AntipatternSeveritySummary(BuilderImpl builder) {
        this.count = builder.count;
        this.severity = builder.severity;
    }

    /**
     * <p>
     * Contains the count of anti-patterns.
     * </p>
     * 
     * @return Contains the count of anti-patterns.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * Contains the severity of anti-patterns.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return Contains the severity of anti-patterns.
     * @see Severity
     */
    public final Severity severity() {
        return Severity.fromValue(severity);
    }

    /**
     * <p>
     * Contains the severity of anti-patterns.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return Contains the severity of anti-patterns.
     * @see Severity
     */
    public final String severityAsString() {
        return severity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AntipatternSeveritySummary)) {
            return false;
        }
        AntipatternSeveritySummary other = (AntipatternSeveritySummary) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(severityAsString(), other.severityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AntipatternSeveritySummary").add("Count", count()).add("Severity", severityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AntipatternSeveritySummary, T> g) {
        return obj -> g.apply((AntipatternSeveritySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AntipatternSeveritySummary> {
        /**
         * <p>
         * Contains the count of anti-patterns.
         * </p>
         * 
         * @param count
         *        Contains the count of anti-patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * Contains the severity of anti-patterns.
         * </p>
         * 
         * @param severity
         *        Contains the severity of anti-patterns.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(String severity);

        /**
         * <p>
         * Contains the severity of anti-patterns.
         * </p>
         * 
         * @param severity
         *        Contains the severity of anti-patterns.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(Severity severity);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(AntipatternSeveritySummary model) {
            count(model.count);
            severity(model.severity);
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        @Transient
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        @Override
        public AntipatternSeveritySummary build() {
            return new AntipatternSeveritySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
