/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Business goals that you specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BusinessGoals implements SdkPojo, Serializable, ToCopyableBuilder<BusinessGoals.Builder, BusinessGoals> {
    private static final SdkField<Integer> LICENSE_COST_REDUCTION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("licenseCostReduction").getter(getter(BusinessGoals::licenseCostReduction))
            .setter(setter(Builder::licenseCostReduction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseCostReduction").build())
            .build();

    private static final SdkField<Integer> MODERNIZE_INFRASTRUCTURE_WITH_CLOUD_NATIVE_TECHNOLOGIES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("modernizeInfrastructureWithCloudNativeTechnologies")
            .getter(getter(BusinessGoals::modernizeInfrastructureWithCloudNativeTechnologies))
            .setter(setter(Builder::modernizeInfrastructureWithCloudNativeTechnologies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("modernizeInfrastructureWithCloudNativeTechnologies").build()).build();

    private static final SdkField<Integer> REDUCE_OPERATIONAL_OVERHEAD_WITH_MANAGED_SERVICES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("reduceOperationalOverheadWithManagedServices")
            .getter(getter(BusinessGoals::reduceOperationalOverheadWithManagedServices))
            .setter(setter(Builder::reduceOperationalOverheadWithManagedServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("reduceOperationalOverheadWithManagedServices").build()).build();

    private static final SdkField<Integer> SPEED_OF_MIGRATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("speedOfMigration").getter(getter(BusinessGoals::speedOfMigration))
            .setter(setter(Builder::speedOfMigration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speedOfMigration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_COST_REDUCTION_FIELD,
            MODERNIZE_INFRASTRUCTURE_WITH_CLOUD_NATIVE_TECHNOLOGIES_FIELD,
            REDUCE_OPERATIONAL_OVERHEAD_WITH_MANAGED_SERVICES_FIELD, SPEED_OF_MIGRATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer licenseCostReduction;

    private final Integer modernizeInfrastructureWithCloudNativeTechnologies;

    private final Integer reduceOperationalOverheadWithManagedServices;

    private final Integer speedOfMigration;

    private BusinessGoals(BuilderImpl builder) {
        this.licenseCostReduction = builder.licenseCostReduction;
        this.modernizeInfrastructureWithCloudNativeTechnologies = builder.modernizeInfrastructureWithCloudNativeTechnologies;
        this.reduceOperationalOverheadWithManagedServices = builder.reduceOperationalOverheadWithManagedServices;
        this.speedOfMigration = builder.speedOfMigration;
    }

    /**
     * <p>
     * Business goal to reduce license costs.
     * </p>
     * 
     * @return Business goal to reduce license costs.
     */
    public final Integer licenseCostReduction() {
        return licenseCostReduction;
    }

    /**
     * <p>
     * Business goal to modernize infrastructure by moving to cloud native technologies.
     * </p>
     * 
     * @return Business goal to modernize infrastructure by moving to cloud native technologies.
     */
    public final Integer modernizeInfrastructureWithCloudNativeTechnologies() {
        return modernizeInfrastructureWithCloudNativeTechnologies;
    }

    /**
     * <p>
     * Business goal to reduce the operational overhead on the team by moving into managed services.
     * </p>
     * 
     * @return Business goal to reduce the operational overhead on the team by moving into managed services.
     */
    public final Integer reduceOperationalOverheadWithManagedServices() {
        return reduceOperationalOverheadWithManagedServices;
    }

    /**
     * <p>
     * Business goal to achieve migration at a fast pace.
     * </p>
     * 
     * @return Business goal to achieve migration at a fast pace.
     */
    public final Integer speedOfMigration() {
        return speedOfMigration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(licenseCostReduction());
        hashCode = 31 * hashCode + Objects.hashCode(modernizeInfrastructureWithCloudNativeTechnologies());
        hashCode = 31 * hashCode + Objects.hashCode(reduceOperationalOverheadWithManagedServices());
        hashCode = 31 * hashCode + Objects.hashCode(speedOfMigration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BusinessGoals)) {
            return false;
        }
        BusinessGoals other = (BusinessGoals) obj;
        return Objects.equals(licenseCostReduction(), other.licenseCostReduction())
                && Objects.equals(modernizeInfrastructureWithCloudNativeTechnologies(),
                        other.modernizeInfrastructureWithCloudNativeTechnologies())
                && Objects.equals(reduceOperationalOverheadWithManagedServices(),
                        other.reduceOperationalOverheadWithManagedServices())
                && Objects.equals(speedOfMigration(), other.speedOfMigration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BusinessGoals").add("LicenseCostReduction", licenseCostReduction())
                .add("ModernizeInfrastructureWithCloudNativeTechnologies", modernizeInfrastructureWithCloudNativeTechnologies())
                .add("ReduceOperationalOverheadWithManagedServices", reduceOperationalOverheadWithManagedServices())
                .add("SpeedOfMigration", speedOfMigration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "licenseCostReduction":
            return Optional.ofNullable(clazz.cast(licenseCostReduction()));
        case "modernizeInfrastructureWithCloudNativeTechnologies":
            return Optional.ofNullable(clazz.cast(modernizeInfrastructureWithCloudNativeTechnologies()));
        case "reduceOperationalOverheadWithManagedServices":
            return Optional.ofNullable(clazz.cast(reduceOperationalOverheadWithManagedServices()));
        case "speedOfMigration":
            return Optional.ofNullable(clazz.cast(speedOfMigration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BusinessGoals, T> g) {
        return obj -> g.apply((BusinessGoals) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BusinessGoals> {
        /**
         * <p>
         * Business goal to reduce license costs.
         * </p>
         * 
         * @param licenseCostReduction
         *        Business goal to reduce license costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseCostReduction(Integer licenseCostReduction);

        /**
         * <p>
         * Business goal to modernize infrastructure by moving to cloud native technologies.
         * </p>
         * 
         * @param modernizeInfrastructureWithCloudNativeTechnologies
         *        Business goal to modernize infrastructure by moving to cloud native technologies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modernizeInfrastructureWithCloudNativeTechnologies(Integer modernizeInfrastructureWithCloudNativeTechnologies);

        /**
         * <p>
         * Business goal to reduce the operational overhead on the team by moving into managed services.
         * </p>
         * 
         * @param reduceOperationalOverheadWithManagedServices
         *        Business goal to reduce the operational overhead on the team by moving into managed services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reduceOperationalOverheadWithManagedServices(Integer reduceOperationalOverheadWithManagedServices);

        /**
         * <p>
         * Business goal to achieve migration at a fast pace.
         * </p>
         * 
         * @param speedOfMigration
         *        Business goal to achieve migration at a fast pace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speedOfMigration(Integer speedOfMigration);
    }

    static final class BuilderImpl implements Builder {
        private Integer licenseCostReduction;

        private Integer modernizeInfrastructureWithCloudNativeTechnologies;

        private Integer reduceOperationalOverheadWithManagedServices;

        private Integer speedOfMigration;

        private BuilderImpl() {
        }

        private BuilderImpl(BusinessGoals model) {
            licenseCostReduction(model.licenseCostReduction);
            modernizeInfrastructureWithCloudNativeTechnologies(model.modernizeInfrastructureWithCloudNativeTechnologies);
            reduceOperationalOverheadWithManagedServices(model.reduceOperationalOverheadWithManagedServices);
            speedOfMigration(model.speedOfMigration);
        }

        public final Integer getLicenseCostReduction() {
            return licenseCostReduction;
        }

        public final void setLicenseCostReduction(Integer licenseCostReduction) {
            this.licenseCostReduction = licenseCostReduction;
        }

        @Override
        @Transient
        public final Builder licenseCostReduction(Integer licenseCostReduction) {
            this.licenseCostReduction = licenseCostReduction;
            return this;
        }

        public final Integer getModernizeInfrastructureWithCloudNativeTechnologies() {
            return modernizeInfrastructureWithCloudNativeTechnologies;
        }

        public final void setModernizeInfrastructureWithCloudNativeTechnologies(
                Integer modernizeInfrastructureWithCloudNativeTechnologies) {
            this.modernizeInfrastructureWithCloudNativeTechnologies = modernizeInfrastructureWithCloudNativeTechnologies;
        }

        @Override
        @Transient
        public final Builder modernizeInfrastructureWithCloudNativeTechnologies(
                Integer modernizeInfrastructureWithCloudNativeTechnologies) {
            this.modernizeInfrastructureWithCloudNativeTechnologies = modernizeInfrastructureWithCloudNativeTechnologies;
            return this;
        }

        public final Integer getReduceOperationalOverheadWithManagedServices() {
            return reduceOperationalOverheadWithManagedServices;
        }

        public final void setReduceOperationalOverheadWithManagedServices(Integer reduceOperationalOverheadWithManagedServices) {
            this.reduceOperationalOverheadWithManagedServices = reduceOperationalOverheadWithManagedServices;
        }

        @Override
        @Transient
        public final Builder reduceOperationalOverheadWithManagedServices(Integer reduceOperationalOverheadWithManagedServices) {
            this.reduceOperationalOverheadWithManagedServices = reduceOperationalOverheadWithManagedServices;
            return this;
        }

        public final Integer getSpeedOfMigration() {
            return speedOfMigration;
        }

        public final void setSpeedOfMigration(Integer speedOfMigration) {
            this.speedOfMigration = speedOfMigration;
        }

        @Override
        @Transient
        public final Builder speedOfMigration(Integer speedOfMigration) {
            this.speedOfMigration = speedOfMigration;
            return this;
        }

        @Override
        public BusinessGoals build() {
            return new BusinessGoals(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
