/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about an assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataCollectionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DataCollectionDetails.Builder, DataCollectionDetails> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completionTime").getter(getter(DataCollectionDetails::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build()).build();

    private static final SdkField<Integer> FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failed").getter(getter(DataCollectionDetails::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()).build();

    private static final SdkField<Integer> IN_PROGRESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("inProgress").getter(getter(DataCollectionDetails::inProgress)).setter(setter(Builder::inProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inProgress").build()).build();

    private static final SdkField<Integer> SERVERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("servers").getter(getter(DataCollectionDetails::servers)).setter(setter(Builder::servers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servers").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(DataCollectionDetails::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataCollectionDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> SUCCESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("success").getter(getter(DataCollectionDetails::success)).setter(setter(Builder::success))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("success").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD,
            FAILED_FIELD, IN_PROGRESS_FIELD, SERVERS_FIELD, START_TIME_FIELD, STATUS_FIELD, SUCCESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant completionTime;

    private final Integer failed;

    private final Integer inProgress;

    private final Integer servers;

    private final Instant startTime;

    private final String status;

    private final Integer success;

    private DataCollectionDetails(BuilderImpl builder) {
        this.completionTime = builder.completionTime;
        this.failed = builder.failed;
        this.inProgress = builder.inProgress;
        this.servers = builder.servers;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.success = builder.success;
    }

    /**
     * <p>
     * The time the assessment completes.
     * </p>
     * 
     * @return The time the assessment completes.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The number of failed servers in the assessment.
     * </p>
     * 
     * @return The number of failed servers in the assessment.
     */
    public final Integer failed() {
        return failed;
    }

    /**
     * <p>
     * The number of servers with the assessment status <code>IN_PROGESS</code>.
     * </p>
     * 
     * @return The number of servers with the assessment status <code>IN_PROGESS</code>.
     */
    public final Integer inProgress() {
        return inProgress;
    }

    /**
     * <p>
     * The total number of servers in the assessment.
     * </p>
     * 
     * @return The total number of servers in the assessment.
     */
    public final Integer servers() {
        return servers;
    }

    /**
     * <p>
     * The start time of assessment.
     * </p>
     * 
     * @return The start time of assessment.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of the assessment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the assessment.
     * @see AssessmentStatus
     */
    public final AssessmentStatus status() {
        return AssessmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the assessment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the assessment.
     * @see AssessmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The number of successful servers in the assessment.
     * </p>
     * 
     * @return The number of successful servers in the assessment.
     */
    public final Integer success() {
        return success;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(inProgress());
        hashCode = 31 * hashCode + Objects.hashCode(servers());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(success());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCollectionDetails)) {
            return false;
        }
        DataCollectionDetails other = (DataCollectionDetails) obj;
        return Objects.equals(completionTime(), other.completionTime()) && Objects.equals(failed(), other.failed())
                && Objects.equals(inProgress(), other.inProgress()) && Objects.equals(servers(), other.servers())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(success(), other.success());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataCollectionDetails").add("CompletionTime", completionTime()).add("Failed", failed())
                .add("InProgress", inProgress()).add("Servers", servers()).add("StartTime", startTime())
                .add("Status", statusAsString()).add("Success", success()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "completionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "inProgress":
            return Optional.ofNullable(clazz.cast(inProgress()));
        case "servers":
            return Optional.ofNullable(clazz.cast(servers()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "success":
            return Optional.ofNullable(clazz.cast(success()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCollectionDetails, T> g) {
        return obj -> g.apply((DataCollectionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataCollectionDetails> {
        /**
         * <p>
         * The time the assessment completes.
         * </p>
         * 
         * @param completionTime
         *        The time the assessment completes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The number of failed servers in the assessment.
         * </p>
         * 
         * @param failed
         *        The number of failed servers in the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);

        /**
         * <p>
         * The number of servers with the assessment status <code>IN_PROGESS</code>.
         * </p>
         * 
         * @param inProgress
         *        The number of servers with the assessment status <code>IN_PROGESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgress(Integer inProgress);

        /**
         * <p>
         * The total number of servers in the assessment.
         * </p>
         * 
         * @param servers
         *        The total number of servers in the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servers(Integer servers);

        /**
         * <p>
         * The start time of assessment.
         * </p>
         * 
         * @param startTime
         *        The start time of assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of the assessment.
         * </p>
         * 
         * @param status
         *        The status of the assessment.
         * @see AssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the assessment.
         * </p>
         * 
         * @param status
         *        The status of the assessment.
         * @see AssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentStatus
         */
        Builder status(AssessmentStatus status);

        /**
         * <p>
         * The number of successful servers in the assessment.
         * </p>
         * 
         * @param success
         *        The number of successful servers in the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder success(Integer success);
    }

    static final class BuilderImpl implements Builder {
        private Instant completionTime;

        private Integer failed;

        private Integer inProgress;

        private Integer servers;

        private Instant startTime;

        private String status;

        private Integer success;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCollectionDetails model) {
            completionTime(model.completionTime);
            failed(model.failed);
            inProgress(model.inProgress);
            servers(model.servers);
            startTime(model.startTime);
            status(model.status);
            success(model.success);
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        @Transient
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Integer getFailed() {
            return failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        @Transient
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final Integer getInProgress() {
            return inProgress;
        }

        public final void setInProgress(Integer inProgress) {
            this.inProgress = inProgress;
        }

        @Override
        @Transient
        public final Builder inProgress(Integer inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final Integer getServers() {
            return servers;
        }

        public final void setServers(Integer servers) {
            this.servers = servers;
        }

        @Override
        @Transient
        public final Builder servers(Integer servers) {
            this.servers = servers;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(AssessmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getSuccess() {
            return success;
        }

        public final void setSuccess(Integer success) {
            this.success = success;
        }

        @Override
        @Transient
        public final Builder success(Integer success) {
            this.success = success;
            return this;
        }

        @Override
        public DataCollectionDetails build() {
            return new DataCollectionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
