/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Preferences for migrating a database to AWS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseMigrationPreference implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabaseMigrationPreference.Builder, DatabaseMigrationPreference> {
    private static final SdkField<Heterogeneous> HETEROGENEOUS_FIELD = SdkField.<Heterogeneous> builder(MarshallingType.SDK_POJO)
            .memberName("heterogeneous").getter(getter(DatabaseMigrationPreference::heterogeneous))
            .setter(setter(Builder::heterogeneous)).constructor(Heterogeneous::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heterogeneous").build()).build();

    private static final SdkField<Homogeneous> HOMOGENEOUS_FIELD = SdkField.<Homogeneous> builder(MarshallingType.SDK_POJO)
            .memberName("homogeneous").getter(getter(DatabaseMigrationPreference::homogeneous))
            .setter(setter(Builder::homogeneous)).constructor(Homogeneous::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homogeneous").build()).build();

    private static final SdkField<NoDatabaseMigrationPreference> NO_PREFERENCE_FIELD = SdkField
            .<NoDatabaseMigrationPreference> builder(MarshallingType.SDK_POJO).memberName("noPreference")
            .getter(getter(DatabaseMigrationPreference::noPreference)).setter(setter(Builder::noPreference))
            .constructor(NoDatabaseMigrationPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noPreference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HETEROGENEOUS_FIELD,
            HOMOGENEOUS_FIELD, NO_PREFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Heterogeneous heterogeneous;

    private final Homogeneous homogeneous;

    private final NoDatabaseMigrationPreference noPreference;

    private DatabaseMigrationPreference(BuilderImpl builder) {
        this.heterogeneous = builder.heterogeneous;
        this.homogeneous = builder.homogeneous;
        this.noPreference = builder.noPreference;
    }

    /**
     * <p>
     * Indicates whether you are interested in moving from one type of database to another. For example, from SQL Server
     * to Amazon Aurora MySQL-Compatible Edition.
     * </p>
     * 
     * @return Indicates whether you are interested in moving from one type of database to another. For example, from
     *         SQL Server to Amazon Aurora MySQL-Compatible Edition.
     */
    public final Heterogeneous heterogeneous() {
        return heterogeneous;
    }

    /**
     * <p>
     * Indicates whether you are interested in moving to the same type of database into AWS. For example, from SQL
     * Server in your environment to SQL Server on AWS.
     * </p>
     * 
     * @return Indicates whether you are interested in moving to the same type of database into AWS. For example, from
     *         SQL Server in your environment to SQL Server on AWS.
     */
    public final Homogeneous homogeneous() {
        return homogeneous;
    }

    /**
     * <p>
     * Indicated that you do not prefer heterogeneous or homogeneous.
     * </p>
     * 
     * @return Indicated that you do not prefer heterogeneous or homogeneous.
     */
    public final NoDatabaseMigrationPreference noPreference() {
        return noPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(heterogeneous());
        hashCode = 31 * hashCode + Objects.hashCode(homogeneous());
        hashCode = 31 * hashCode + Objects.hashCode(noPreference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseMigrationPreference)) {
            return false;
        }
        DatabaseMigrationPreference other = (DatabaseMigrationPreference) obj;
        return Objects.equals(heterogeneous(), other.heterogeneous()) && Objects.equals(homogeneous(), other.homogeneous())
                && Objects.equals(noPreference(), other.noPreference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseMigrationPreference").add("Heterogeneous", heterogeneous())
                .add("Homogeneous", homogeneous()).add("NoPreference", noPreference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "heterogeneous":
            return Optional.ofNullable(clazz.cast(heterogeneous()));
        case "homogeneous":
            return Optional.ofNullable(clazz.cast(homogeneous()));
        case "noPreference":
            return Optional.ofNullable(clazz.cast(noPreference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseMigrationPreference, T> g) {
        return obj -> g.apply((DatabaseMigrationPreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseMigrationPreference> {
        /**
         * <p>
         * Indicates whether you are interested in moving from one type of database to another. For example, from SQL
         * Server to Amazon Aurora MySQL-Compatible Edition.
         * </p>
         * 
         * @param heterogeneous
         *        Indicates whether you are interested in moving from one type of database to another. For example, from
         *        SQL Server to Amazon Aurora MySQL-Compatible Edition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heterogeneous(Heterogeneous heterogeneous);

        /**
         * <p>
         * Indicates whether you are interested in moving from one type of database to another. For example, from SQL
         * Server to Amazon Aurora MySQL-Compatible Edition.
         * </p>
         * This is a convenience that creates an instance of the {@link Heterogeneous.Builder} avoiding the need to
         * create one manually via {@link Heterogeneous#builder()}.
         *
         * When the {@link Consumer} completes, {@link Heterogeneous.Builder#build()} is called immediately and its
         * result is passed to {@link #heterogeneous(Heterogeneous)}.
         * 
         * @param heterogeneous
         *        a consumer that will call methods on {@link Heterogeneous.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #heterogeneous(Heterogeneous)
         */
        default Builder heterogeneous(Consumer<Heterogeneous.Builder> heterogeneous) {
            return heterogeneous(Heterogeneous.builder().applyMutation(heterogeneous).build());
        }

        /**
         * <p>
         * Indicates whether you are interested in moving to the same type of database into AWS. For example, from SQL
         * Server in your environment to SQL Server on AWS.
         * </p>
         * 
         * @param homogeneous
         *        Indicates whether you are interested in moving to the same type of database into AWS. For example,
         *        from SQL Server in your environment to SQL Server on AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homogeneous(Homogeneous homogeneous);

        /**
         * <p>
         * Indicates whether you are interested in moving to the same type of database into AWS. For example, from SQL
         * Server in your environment to SQL Server on AWS.
         * </p>
         * This is a convenience that creates an instance of the {@link Homogeneous.Builder} avoiding the need to create
         * one manually via {@link Homogeneous#builder()}.
         *
         * When the {@link Consumer} completes, {@link Homogeneous.Builder#build()} is called immediately and its result
         * is passed to {@link #homogeneous(Homogeneous)}.
         * 
         * @param homogeneous
         *        a consumer that will call methods on {@link Homogeneous.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #homogeneous(Homogeneous)
         */
        default Builder homogeneous(Consumer<Homogeneous.Builder> homogeneous) {
            return homogeneous(Homogeneous.builder().applyMutation(homogeneous).build());
        }

        /**
         * <p>
         * Indicated that you do not prefer heterogeneous or homogeneous.
         * </p>
         * 
         * @param noPreference
         *        Indicated that you do not prefer heterogeneous or homogeneous.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noPreference(NoDatabaseMigrationPreference noPreference);

        /**
         * <p>
         * Indicated that you do not prefer heterogeneous or homogeneous.
         * </p>
         * This is a convenience that creates an instance of the {@link NoDatabaseMigrationPreference.Builder} avoiding
         * the need to create one manually via {@link NoDatabaseMigrationPreference#builder()}.
         *
         * When the {@link Consumer} completes, {@link NoDatabaseMigrationPreference.Builder#build()} is called
         * immediately and its result is passed to {@link #noPreference(NoDatabaseMigrationPreference)}.
         * 
         * @param noPreference
         *        a consumer that will call methods on {@link NoDatabaseMigrationPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noPreference(NoDatabaseMigrationPreference)
         */
        default Builder noPreference(Consumer<NoDatabaseMigrationPreference.Builder> noPreference) {
            return noPreference(NoDatabaseMigrationPreference.builder().applyMutation(noPreference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Heterogeneous heterogeneous;

        private Homogeneous homogeneous;

        private NoDatabaseMigrationPreference noPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseMigrationPreference model) {
            heterogeneous(model.heterogeneous);
            homogeneous(model.homogeneous);
            noPreference(model.noPreference);
        }

        public final Heterogeneous.Builder getHeterogeneous() {
            return heterogeneous != null ? heterogeneous.toBuilder() : null;
        }

        public final void setHeterogeneous(Heterogeneous.BuilderImpl heterogeneous) {
            this.heterogeneous = heterogeneous != null ? heterogeneous.build() : null;
        }

        @Override
        @Transient
        public final Builder heterogeneous(Heterogeneous heterogeneous) {
            this.heterogeneous = heterogeneous;
            return this;
        }

        public final Homogeneous.Builder getHomogeneous() {
            return homogeneous != null ? homogeneous.toBuilder() : null;
        }

        public final void setHomogeneous(Homogeneous.BuilderImpl homogeneous) {
            this.homogeneous = homogeneous != null ? homogeneous.build() : null;
        }

        @Override
        @Transient
        public final Builder homogeneous(Homogeneous homogeneous) {
            this.homogeneous = homogeneous;
            return this;
        }

        public final NoDatabaseMigrationPreference.Builder getNoPreference() {
            return noPreference != null ? noPreference.toBuilder() : null;
        }

        public final void setNoPreference(NoDatabaseMigrationPreference.BuilderImpl noPreference) {
            this.noPreference = noPreference != null ? noPreference.build() : null;
        }

        @Override
        @Transient
        public final Builder noPreference(NoDatabaseMigrationPreference noPreference) {
            this.noPreference = noPreference;
            return this;
        }

        @Override
        public DatabaseMigrationPreference build() {
            return new DatabaseMigrationPreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
