/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Preferences on managing your databases on AWS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabasePreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabasePreferences.Builder, DatabasePreferences> {
    private static final SdkField<String> DATABASE_MANAGEMENT_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("databaseManagementPreference")
            .getter(getter(DatabasePreferences::databaseManagementPreferenceAsString))
            .setter(setter(Builder::databaseManagementPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseManagementPreference")
                    .build()).build();

    private static final SdkField<DatabaseMigrationPreference> DATABASE_MIGRATION_PREFERENCE_FIELD = SdkField
            .<DatabaseMigrationPreference> builder(MarshallingType.SDK_POJO)
            .memberName("databaseMigrationPreference")
            .getter(getter(DatabasePreferences::databaseMigrationPreference))
            .setter(setter(Builder::databaseMigrationPreference))
            .constructor(DatabaseMigrationPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseMigrationPreference")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATABASE_MANAGEMENT_PREFERENCE_FIELD, DATABASE_MIGRATION_PREFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseManagementPreference;

    private final DatabaseMigrationPreference databaseMigrationPreference;

    private DatabasePreferences(BuilderImpl builder) {
        this.databaseManagementPreference = builder.databaseManagementPreference;
        this.databaseMigrationPreference = builder.databaseMigrationPreference;
    }

    /**
     * <p>
     * Specifies whether you're interested in self-managed databases or databases managed by AWS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseManagementPreference} will return {@link DatabaseManagementPreference#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #databaseManagementPreferenceAsString}.
     * </p>
     * 
     * @return Specifies whether you're interested in self-managed databases or databases managed by AWS.
     * @see DatabaseManagementPreference
     */
    public final DatabaseManagementPreference databaseManagementPreference() {
        return DatabaseManagementPreference.fromValue(databaseManagementPreference);
    }

    /**
     * <p>
     * Specifies whether you're interested in self-managed databases or databases managed by AWS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseManagementPreference} will return {@link DatabaseManagementPreference#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #databaseManagementPreferenceAsString}.
     * </p>
     * 
     * @return Specifies whether you're interested in self-managed databases or databases managed by AWS.
     * @see DatabaseManagementPreference
     */
    public final String databaseManagementPreferenceAsString() {
        return databaseManagementPreference;
    }

    /**
     * <p>
     * Specifies your preferred migration path.
     * </p>
     * 
     * @return Specifies your preferred migration path.
     */
    public final DatabaseMigrationPreference databaseMigrationPreference() {
        return databaseMigrationPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseManagementPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(databaseMigrationPreference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabasePreferences)) {
            return false;
        }
        DatabasePreferences other = (DatabasePreferences) obj;
        return Objects.equals(databaseManagementPreferenceAsString(), other.databaseManagementPreferenceAsString())
                && Objects.equals(databaseMigrationPreference(), other.databaseMigrationPreference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabasePreferences")
                .add("DatabaseManagementPreference", databaseManagementPreferenceAsString())
                .add("DatabaseMigrationPreference", databaseMigrationPreference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "databaseManagementPreference":
            return Optional.ofNullable(clazz.cast(databaseManagementPreferenceAsString()));
        case "databaseMigrationPreference":
            return Optional.ofNullable(clazz.cast(databaseMigrationPreference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabasePreferences, T> g) {
        return obj -> g.apply((DatabasePreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabasePreferences> {
        /**
         * <p>
         * Specifies whether you're interested in self-managed databases or databases managed by AWS.
         * </p>
         * 
         * @param databaseManagementPreference
         *        Specifies whether you're interested in self-managed databases or databases managed by AWS.
         * @see DatabaseManagementPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseManagementPreference
         */
        Builder databaseManagementPreference(String databaseManagementPreference);

        /**
         * <p>
         * Specifies whether you're interested in self-managed databases or databases managed by AWS.
         * </p>
         * 
         * @param databaseManagementPreference
         *        Specifies whether you're interested in self-managed databases or databases managed by AWS.
         * @see DatabaseManagementPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseManagementPreference
         */
        Builder databaseManagementPreference(DatabaseManagementPreference databaseManagementPreference);

        /**
         * <p>
         * Specifies your preferred migration path.
         * </p>
         * 
         * @param databaseMigrationPreference
         *        Specifies your preferred migration path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseMigrationPreference(DatabaseMigrationPreference databaseMigrationPreference);

        /**
         * <p>
         * Specifies your preferred migration path.
         * </p>
         * This is a convenience that creates an instance of the {@link DatabaseMigrationPreference.Builder} avoiding
         * the need to create one manually via {@link DatabaseMigrationPreference#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatabaseMigrationPreference.Builder#build()} is called
         * immediately and its result is passed to {@link #databaseMigrationPreference(DatabaseMigrationPreference)}.
         * 
         * @param databaseMigrationPreference
         *        a consumer that will call methods on {@link DatabaseMigrationPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseMigrationPreference(DatabaseMigrationPreference)
         */
        default Builder databaseMigrationPreference(Consumer<DatabaseMigrationPreference.Builder> databaseMigrationPreference) {
            return databaseMigrationPreference(DatabaseMigrationPreference.builder().applyMutation(databaseMigrationPreference)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String databaseManagementPreference;

        private DatabaseMigrationPreference databaseMigrationPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabasePreferences model) {
            databaseManagementPreference(model.databaseManagementPreference);
            databaseMigrationPreference(model.databaseMigrationPreference);
        }

        public final String getDatabaseManagementPreference() {
            return databaseManagementPreference;
        }

        public final void setDatabaseManagementPreference(String databaseManagementPreference) {
            this.databaseManagementPreference = databaseManagementPreference;
        }

        @Override
        @Transient
        public final Builder databaseManagementPreference(String databaseManagementPreference) {
            this.databaseManagementPreference = databaseManagementPreference;
            return this;
        }

        @Override
        @Transient
        public final Builder databaseManagementPreference(DatabaseManagementPreference databaseManagementPreference) {
            this.databaseManagementPreference(databaseManagementPreference == null ? null : databaseManagementPreference
                    .toString());
            return this;
        }

        public final DatabaseMigrationPreference.Builder getDatabaseMigrationPreference() {
            return databaseMigrationPreference != null ? databaseMigrationPreference.toBuilder() : null;
        }

        public final void setDatabaseMigrationPreference(DatabaseMigrationPreference.BuilderImpl databaseMigrationPreference) {
            this.databaseMigrationPreference = databaseMigrationPreference != null ? databaseMigrationPreference.build() : null;
        }

        @Override
        @Transient
        public final Builder databaseMigrationPreference(DatabaseMigrationPreference databaseMigrationPreference) {
            this.databaseMigrationPreference = databaseMigrationPreference;
            return this;
        }

        @Override
        public DatabasePreferences build() {
            return new DatabasePreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
