/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationComponentStrategiesResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<GetApplicationComponentStrategiesResponse.Builder, GetApplicationComponentStrategiesResponse> {
    private static final SdkField<List<ApplicationComponentStrategy>> APPLICATION_COMPONENT_STRATEGIES_FIELD = SdkField
            .<List<ApplicationComponentStrategy>> builder(MarshallingType.LIST)
            .memberName("applicationComponentStrategies")
            .getter(getter(GetApplicationComponentStrategiesResponse::applicationComponentStrategies))
            .setter(setter(Builder::applicationComponentStrategies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationComponentStrategies")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationComponentStrategy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationComponentStrategy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_COMPONENT_STRATEGIES_FIELD));

    private final List<ApplicationComponentStrategy> applicationComponentStrategies;

    private GetApplicationComponentStrategiesResponse(BuilderImpl builder) {
        super(builder);
        this.applicationComponentStrategies = builder.applicationComponentStrategies;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationComponentStrategies property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApplicationComponentStrategies() {
        return applicationComponentStrategies != null && !(applicationComponentStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of application component strategy recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationComponentStrategies} method.
     * </p>
     * 
     * @return A list of application component strategy recommendations.
     */
    public final List<ApplicationComponentStrategy> applicationComponentStrategies() {
        return applicationComponentStrategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasApplicationComponentStrategies() ? applicationComponentStrategies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationComponentStrategiesResponse)) {
            return false;
        }
        GetApplicationComponentStrategiesResponse other = (GetApplicationComponentStrategiesResponse) obj;
        return hasApplicationComponentStrategies() == other.hasApplicationComponentStrategies()
                && Objects.equals(applicationComponentStrategies(), other.applicationComponentStrategies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetApplicationComponentStrategiesResponse")
                .add("ApplicationComponentStrategies",
                        hasApplicationComponentStrategies() ? applicationComponentStrategies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationComponentStrategies":
            return Optional.ofNullable(clazz.cast(applicationComponentStrategies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationComponentStrategiesResponse, T> g) {
        return obj -> g.apply((GetApplicationComponentStrategiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationComponentStrategiesResponse> {
        /**
         * <p>
         * A list of application component strategy recommendations.
         * </p>
         * 
         * @param applicationComponentStrategies
         *        A list of application component strategy recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponentStrategies(Collection<ApplicationComponentStrategy> applicationComponentStrategies);

        /**
         * <p>
         * A list of application component strategy recommendations.
         * </p>
         * 
         * @param applicationComponentStrategies
         *        A list of application component strategy recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponentStrategies(ApplicationComponentStrategy... applicationComponentStrategies);

        /**
         * <p>
         * A list of application component strategy recommendations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ApplicationComponentStrategy>.Builder}
         * avoiding the need to create one manually via {@link List<ApplicationComponentStrategy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationComponentStrategy>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #applicationComponentStrategies(List<ApplicationComponentStrategy>)}.
         * 
         * @param applicationComponentStrategies
         *        a consumer that will call methods on {@link List<ApplicationComponentStrategy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationComponentStrategies(List<ApplicationComponentStrategy>)
         */
        Builder applicationComponentStrategies(Consumer<ApplicationComponentStrategy.Builder>... applicationComponentStrategies);
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private List<ApplicationComponentStrategy> applicationComponentStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationComponentStrategiesResponse model) {
            super(model);
            applicationComponentStrategies(model.applicationComponentStrategies);
        }

        public final List<ApplicationComponentStrategy.Builder> getApplicationComponentStrategies() {
            List<ApplicationComponentStrategy.Builder> result = ApplicationComponentStrategiesCopier
                    .copyToBuilder(this.applicationComponentStrategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationComponentStrategies(
                Collection<ApplicationComponentStrategy.BuilderImpl> applicationComponentStrategies) {
            this.applicationComponentStrategies = ApplicationComponentStrategiesCopier
                    .copyFromBuilder(applicationComponentStrategies);
        }

        @Override
        @Transient
        public final Builder applicationComponentStrategies(
                Collection<ApplicationComponentStrategy> applicationComponentStrategies) {
            this.applicationComponentStrategies = ApplicationComponentStrategiesCopier.copy(applicationComponentStrategies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applicationComponentStrategies(ApplicationComponentStrategy... applicationComponentStrategies) {
            applicationComponentStrategies(Arrays.asList(applicationComponentStrategies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applicationComponentStrategies(
                Consumer<ApplicationComponentStrategy.Builder>... applicationComponentStrategies) {
            applicationComponentStrategies(Stream.of(applicationComponentStrategies)
                    .map(c -> ApplicationComponentStrategy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetApplicationComponentStrategiesResponse build() {
            return new GetApplicationComponentStrategiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
