/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServerStrategiesResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<GetServerStrategiesResponse.Builder, GetServerStrategiesResponse> {
    private static final SdkField<List<ServerStrategy>> SERVER_STRATEGIES_FIELD = SdkField
            .<List<ServerStrategy>> builder(MarshallingType.LIST)
            .memberName("serverStrategies")
            .getter(getter(GetServerStrategiesResponse::serverStrategies))
            .setter(setter(Builder::serverStrategies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverStrategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerStrategy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerStrategy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_STRATEGIES_FIELD));

    private final List<ServerStrategy> serverStrategies;

    private GetServerStrategiesResponse(BuilderImpl builder) {
        super(builder);
        this.serverStrategies = builder.serverStrategies;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerStrategies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServerStrategies() {
        return serverStrategies != null && !(serverStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strategy recommendations for the server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerStrategies} method.
     * </p>
     * 
     * @return A list of strategy recommendations for the server.
     */
    public final List<ServerStrategy> serverStrategies() {
        return serverStrategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServerStrategies() ? serverStrategies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServerStrategiesResponse)) {
            return false;
        }
        GetServerStrategiesResponse other = (GetServerStrategiesResponse) obj;
        return hasServerStrategies() == other.hasServerStrategies()
                && Objects.equals(serverStrategies(), other.serverStrategies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServerStrategiesResponse")
                .add("ServerStrategies", hasServerStrategies() ? serverStrategies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverStrategies":
            return Optional.ofNullable(clazz.cast(serverStrategies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServerStrategiesResponse, T> g) {
        return obj -> g.apply((GetServerStrategiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServerStrategiesResponse> {
        /**
         * <p>
         * A list of strategy recommendations for the server.
         * </p>
         * 
         * @param serverStrategies
         *        A list of strategy recommendations for the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverStrategies(Collection<ServerStrategy> serverStrategies);

        /**
         * <p>
         * A list of strategy recommendations for the server.
         * </p>
         * 
         * @param serverStrategies
         *        A list of strategy recommendations for the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverStrategies(ServerStrategy... serverStrategies);

        /**
         * <p>
         * A list of strategy recommendations for the server.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServerStrategy>.Builder} avoiding the need
         * to create one manually via {@link List<ServerStrategy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerStrategy>.Builder#build()} is called immediately and
         * its result is passed to {@link #serverStrategies(List<ServerStrategy>)}.
         * 
         * @param serverStrategies
         *        a consumer that will call methods on {@link List<ServerStrategy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverStrategies(List<ServerStrategy>)
         */
        Builder serverStrategies(Consumer<ServerStrategy.Builder>... serverStrategies);
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private List<ServerStrategy> serverStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetServerStrategiesResponse model) {
            super(model);
            serverStrategies(model.serverStrategies);
        }

        public final List<ServerStrategy.Builder> getServerStrategies() {
            List<ServerStrategy.Builder> result = ServerStrategiesCopier.copyToBuilder(this.serverStrategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerStrategies(Collection<ServerStrategy.BuilderImpl> serverStrategies) {
            this.serverStrategies = ServerStrategiesCopier.copyFromBuilder(serverStrategies);
        }

        @Override
        @Transient
        public final Builder serverStrategies(Collection<ServerStrategy> serverStrategies) {
            this.serverStrategies = ServerStrategiesCopier.copy(serverStrategies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serverStrategies(ServerStrategy... serverStrategies) {
            serverStrategies(Arrays.asList(serverStrategies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serverStrategies(Consumer<ServerStrategy.Builder>... serverStrategies) {
            serverStrategies(Stream.of(serverStrategies).map(c -> ServerStrategy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetServerStrategiesResponse build() {
            return new GetServerStrategiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
