/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object containing details about homogeneous database preferences.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Homogeneous implements SdkPojo, Serializable, ToCopyableBuilder<Homogeneous.Builder, Homogeneous> {
    private static final SdkField<List<String>> TARGET_DATABASE_ENGINE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targetDatabaseEngine")
            .getter(getter(Homogeneous::targetDatabaseEngineAsStrings))
            .setter(setter(Builder::targetDatabaseEngineWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDatabaseEngine").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_DATABASE_ENGINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> targetDatabaseEngine;

    private Homogeneous(BuilderImpl builder) {
        this.targetDatabaseEngine = builder.targetDatabaseEngine;
    }

    /**
     * <p>
     * The target database engine for homogeneous database migration preferences.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetDatabaseEngine} method.
     * </p>
     * 
     * @return The target database engine for homogeneous database migration preferences.
     */
    public final List<HomogeneousTargetDatabaseEngine> targetDatabaseEngine() {
        return HomogeneousTargetDatabaseEnginesCopier.copyStringToEnum(targetDatabaseEngine);
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetDatabaseEngine property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetDatabaseEngine() {
        return targetDatabaseEngine != null && !(targetDatabaseEngine instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target database engine for homogeneous database migration preferences.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetDatabaseEngine} method.
     * </p>
     * 
     * @return The target database engine for homogeneous database migration preferences.
     */
    public final List<String> targetDatabaseEngineAsStrings() {
        return targetDatabaseEngine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetDatabaseEngine() ? targetDatabaseEngineAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Homogeneous)) {
            return false;
        }
        Homogeneous other = (Homogeneous) obj;
        return hasTargetDatabaseEngine() == other.hasTargetDatabaseEngine()
                && Objects.equals(targetDatabaseEngineAsStrings(), other.targetDatabaseEngineAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Homogeneous")
                .add("TargetDatabaseEngine", hasTargetDatabaseEngine() ? targetDatabaseEngineAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetDatabaseEngine":
            return Optional.ofNullable(clazz.cast(targetDatabaseEngineAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Homogeneous, T> g) {
        return obj -> g.apply((Homogeneous) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Homogeneous> {
        /**
         * <p>
         * The target database engine for homogeneous database migration preferences.
         * </p>
         * 
         * @param targetDatabaseEngine
         *        The target database engine for homogeneous database migration preferences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabaseEngineWithStrings(Collection<String> targetDatabaseEngine);

        /**
         * <p>
         * The target database engine for homogeneous database migration preferences.
         * </p>
         * 
         * @param targetDatabaseEngine
         *        The target database engine for homogeneous database migration preferences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabaseEngineWithStrings(String... targetDatabaseEngine);

        /**
         * <p>
         * The target database engine for homogeneous database migration preferences.
         * </p>
         * 
         * @param targetDatabaseEngine
         *        The target database engine for homogeneous database migration preferences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabaseEngine(Collection<HomogeneousTargetDatabaseEngine> targetDatabaseEngine);

        /**
         * <p>
         * The target database engine for homogeneous database migration preferences.
         * </p>
         * 
         * @param targetDatabaseEngine
         *        The target database engine for homogeneous database migration preferences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabaseEngine(HomogeneousTargetDatabaseEngine... targetDatabaseEngine);
    }

    static final class BuilderImpl implements Builder {
        private List<String> targetDatabaseEngine = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Homogeneous model) {
            targetDatabaseEngineWithStrings(model.targetDatabaseEngine);
        }

        public final Collection<String> getTargetDatabaseEngine() {
            if (targetDatabaseEngine instanceof SdkAutoConstructList) {
                return null;
            }
            return targetDatabaseEngine;
        }

        public final void setTargetDatabaseEngine(Collection<String> targetDatabaseEngine) {
            this.targetDatabaseEngine = HomogeneousTargetDatabaseEnginesCopier.copy(targetDatabaseEngine);
        }

        @Override
        @Transient
        public final Builder targetDatabaseEngineWithStrings(Collection<String> targetDatabaseEngine) {
            this.targetDatabaseEngine = HomogeneousTargetDatabaseEnginesCopier.copy(targetDatabaseEngine);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetDatabaseEngineWithStrings(String... targetDatabaseEngine) {
            targetDatabaseEngineWithStrings(Arrays.asList(targetDatabaseEngine));
            return this;
        }

        @Override
        @Transient
        public final Builder targetDatabaseEngine(Collection<HomogeneousTargetDatabaseEngine> targetDatabaseEngine) {
            this.targetDatabaseEngine = HomogeneousTargetDatabaseEnginesCopier.copyEnumToString(targetDatabaseEngine);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetDatabaseEngine(HomogeneousTargetDatabaseEngine... targetDatabaseEngine) {
            targetDatabaseEngine(Arrays.asList(targetDatabaseEngine));
            return this;
        }

        @Override
        public Homogeneous build() {
            return new Homogeneous(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
