/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a recommendation set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationSet implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationSet.Builder, RecommendationSet> {
    private static final SdkField<String> STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("strategy").getter(getter(RecommendationSet::strategyAsString)).setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategy").build()).build();

    private static final SdkField<String> TARGET_DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetDestination").getter(getter(RecommendationSet::targetDestinationAsString))
            .setter(setter(Builder::targetDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDestination").build()).build();

    private static final SdkField<TransformationTool> TRANSFORMATION_TOOL_FIELD = SdkField
            .<TransformationTool> builder(MarshallingType.SDK_POJO).memberName("transformationTool")
            .getter(getter(RecommendationSet::transformationTool)).setter(setter(Builder::transformationTool))
            .constructor(TransformationTool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformationTool").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_FIELD,
            TARGET_DESTINATION_FIELD, TRANSFORMATION_TOOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String strategy;

    private final String targetDestination;

    private final TransformationTool transformationTool;

    private RecommendationSet(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.targetDestination = builder.targetDestination;
        this.transformationTool = builder.transformationTool;
    }

    /**
     * <p>
     * The recommended strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link Strategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The recommended strategy.
     * @see Strategy
     */
    public final Strategy strategy() {
        return Strategy.fromValue(strategy);
    }

    /**
     * <p>
     * The recommended strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link Strategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The recommended strategy.
     * @see Strategy
     */
    public final String strategyAsString() {
        return strategy;
    }

    /**
     * <p>
     * The recommended target destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetDestination}
     * will return {@link TargetDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetDestinationAsString}.
     * </p>
     * 
     * @return The recommended target destination.
     * @see TargetDestination
     */
    public final TargetDestination targetDestination() {
        return TargetDestination.fromValue(targetDestination);
    }

    /**
     * <p>
     * The recommended target destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetDestination}
     * will return {@link TargetDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetDestinationAsString}.
     * </p>
     * 
     * @return The recommended target destination.
     * @see TargetDestination
     */
    public final String targetDestinationAsString() {
        return targetDestination;
    }

    /**
     * <p>
     * The target destination for the recommendation set.
     * </p>
     * 
     * @return The target destination for the recommendation set.
     */
    public final TransformationTool transformationTool() {
        return transformationTool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetDestinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transformationTool());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSet)) {
            return false;
        }
        RecommendationSet other = (RecommendationSet) obj;
        return Objects.equals(strategyAsString(), other.strategyAsString())
                && Objects.equals(targetDestinationAsString(), other.targetDestinationAsString())
                && Objects.equals(transformationTool(), other.transformationTool());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationSet").add("Strategy", strategyAsString())
                .add("TargetDestination", targetDestinationAsString()).add("TransformationTool", transformationTool()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        case "targetDestination":
            return Optional.ofNullable(clazz.cast(targetDestinationAsString()));
        case "transformationTool":
            return Optional.ofNullable(clazz.cast(transformationTool()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSet, T> g) {
        return obj -> g.apply((RecommendationSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationSet> {
        /**
         * <p>
         * The recommended strategy.
         * </p>
         * 
         * @param strategy
         *        The recommended strategy.
         * @see Strategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Strategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The recommended strategy.
         * </p>
         * 
         * @param strategy
         *        The recommended strategy.
         * @see Strategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Strategy
         */
        Builder strategy(Strategy strategy);

        /**
         * <p>
         * The recommended target destination.
         * </p>
         * 
         * @param targetDestination
         *        The recommended target destination.
         * @see TargetDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDestination
         */
        Builder targetDestination(String targetDestination);

        /**
         * <p>
         * The recommended target destination.
         * </p>
         * 
         * @param targetDestination
         *        The recommended target destination.
         * @see TargetDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDestination
         */
        Builder targetDestination(TargetDestination targetDestination);

        /**
         * <p>
         * The target destination for the recommendation set.
         * </p>
         * 
         * @param transformationTool
         *        The target destination for the recommendation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformationTool(TransformationTool transformationTool);

        /**
         * <p>
         * The target destination for the recommendation set.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformationTool.Builder} avoiding the need to
         * create one manually via {@link TransformationTool#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformationTool.Builder#build()} is called immediately and its
         * result is passed to {@link #transformationTool(TransformationTool)}.
         * 
         * @param transformationTool
         *        a consumer that will call methods on {@link TransformationTool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformationTool(TransformationTool)
         */
        default Builder transformationTool(Consumer<TransformationTool.Builder> transformationTool) {
            return transformationTool(TransformationTool.builder().applyMutation(transformationTool).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String strategy;

        private String targetDestination;

        private TransformationTool transformationTool;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSet model) {
            strategy(model.strategy);
            targetDestination(model.targetDestination);
            transformationTool(model.transformationTool);
        }

        public final String getStrategy() {
            return strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        @Transient
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        @Transient
        public final Builder strategy(Strategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final String getTargetDestination() {
            return targetDestination;
        }

        public final void setTargetDestination(String targetDestination) {
            this.targetDestination = targetDestination;
        }

        @Override
        @Transient
        public final Builder targetDestination(String targetDestination) {
            this.targetDestination = targetDestination;
            return this;
        }

        @Override
        @Transient
        public final Builder targetDestination(TargetDestination targetDestination) {
            this.targetDestination(targetDestination == null ? null : targetDestination.toString());
            return this;
        }

        public final TransformationTool.Builder getTransformationTool() {
            return transformationTool != null ? transformationTool.toBuilder() : null;
        }

        public final void setTransformationTool(TransformationTool.BuilderImpl transformationTool) {
            this.transformationTool = transformationTool != null ? transformationTool.build() : null;
        }

        @Override
        @Transient
        public final Builder transformationTool(TransformationTool transformationTool) {
            this.transformationTool = transformationTool;
            return this;
        }

        @Override
        public RecommendationSet build() {
            return new RecommendationSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
