/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAssessmentRequest extends MigrationHubStrategyRequest implements
        ToCopyableBuilder<StartAssessmentRequest.Builder, StartAssessmentRequest> {
    private static final SdkField<String> S3_BUCKET_FOR_ANALYSIS_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3bucketForAnalysisData").getter(getter(StartAssessmentRequest::s3bucketForAnalysisData))
            .setter(setter(Builder::s3bucketForAnalysisData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3bucketForAnalysisData").build())
            .build();

    private static final SdkField<String> S3_BUCKET_FOR_REPORT_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3bucketForReportData").getter(getter(StartAssessmentRequest::s3bucketForReportData))
            .setter(setter(Builder::s3bucketForReportData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3bucketForReportData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            S3_BUCKET_FOR_ANALYSIS_DATA_FIELD, S3_BUCKET_FOR_REPORT_DATA_FIELD));

    private final String s3bucketForAnalysisData;

    private final String s3bucketForReportData;

    private StartAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.s3bucketForAnalysisData = builder.s3bucketForAnalysisData;
        this.s3bucketForReportData = builder.s3bucketForReportData;
    }

    /**
     * <p>
     * The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @return The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin
     *         with <code>migrationhub-strategy-</code>.
     */
    public final String s3bucketForAnalysisData() {
        return s3bucketForAnalysisData;
    }

    /**
     * <p>
     * The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @return The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     *         <code>migrationhub-strategy-</code>.
     */
    public final String s3bucketForReportData() {
        return s3bucketForReportData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3bucketForAnalysisData());
        hashCode = 31 * hashCode + Objects.hashCode(s3bucketForReportData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssessmentRequest)) {
            return false;
        }
        StartAssessmentRequest other = (StartAssessmentRequest) obj;
        return Objects.equals(s3bucketForAnalysisData(), other.s3bucketForAnalysisData())
                && Objects.equals(s3bucketForReportData(), other.s3bucketForReportData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAssessmentRequest").add("S3bucketForAnalysisData", s3bucketForAnalysisData())
                .add("S3bucketForReportData", s3bucketForReportData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3bucketForAnalysisData":
            return Optional.ofNullable(clazz.cast(s3bucketForAnalysisData()));
        case "s3bucketForReportData":
            return Optional.ofNullable(clazz.cast(s3bucketForReportData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssessmentRequest, T> g) {
        return obj -> g.apply((StartAssessmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAssessmentRequest> {
        /**
         * <p>
         * The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with
         * <code>migrationhub-strategy-</code>.
         * </p>
         * 
         * @param s3bucketForAnalysisData
         *        The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin
         *        with <code>migrationhub-strategy-</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3bucketForAnalysisData(String s3bucketForAnalysisData);

        /**
         * <p>
         * The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
         * <code>migrationhub-strategy-</code>.
         * </p>
         * 
         * @param s3bucketForReportData
         *        The S3 bucket where all the reports generated by the service are stored. The bucket name must begin
         *        with <code>migrationhub-strategy-</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3bucketForReportData(String s3bucketForReportData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubStrategyRequest.BuilderImpl implements Builder {
        private String s3bucketForAnalysisData;

        private String s3bucketForReportData;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssessmentRequest model) {
            super(model);
            s3bucketForAnalysisData(model.s3bucketForAnalysisData);
            s3bucketForReportData(model.s3bucketForReportData);
        }

        public final String getS3bucketForAnalysisData() {
            return s3bucketForAnalysisData;
        }

        public final void setS3bucketForAnalysisData(String s3bucketForAnalysisData) {
            this.s3bucketForAnalysisData = s3bucketForAnalysisData;
        }

        @Override
        @Transient
        public final Builder s3bucketForAnalysisData(String s3bucketForAnalysisData) {
            this.s3bucketForAnalysisData = s3bucketForAnalysisData;
            return this;
        }

        public final String getS3bucketForReportData() {
            return s3bucketForReportData;
        }

        public final void setS3bucketForReportData(String s3bucketForReportData) {
            this.s3bucketForReportData = s3bucketForReportData;
        }

        @Override
        @Transient
        public final Builder s3bucketForReportData(String s3bucketForReportData) {
            this.s3bucketForReportData = s3bucketForReportData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssessmentRequest build() {
            return new StartAssessmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
