/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing the summary of the strategy recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StrategySummary implements SdkPojo, Serializable, ToCopyableBuilder<StrategySummary.Builder, StrategySummary> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(StrategySummary::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("strategy").getter(getter(StrategySummary::strategyAsString)).setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final String strategy;

    private StrategySummary(BuilderImpl builder) {
        this.count = builder.count;
        this.strategy = builder.strategy;
    }

    /**
     * <p>
     * The count of recommendations per strategy.
     * </p>
     * 
     * @return The count of recommendations per strategy.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The name of recommended strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link Strategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The name of recommended strategy.
     * @see Strategy
     */
    public final Strategy strategy() {
        return Strategy.fromValue(strategy);
    }

    /**
     * <p>
     * The name of recommended strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link Strategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The name of recommended strategy.
     * @see Strategy
     */
    public final String strategyAsString() {
        return strategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StrategySummary)) {
            return false;
        }
        StrategySummary other = (StrategySummary) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(strategyAsString(), other.strategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StrategySummary").add("Count", count()).add("Strategy", strategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StrategySummary, T> g) {
        return obj -> g.apply((StrategySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StrategySummary> {
        /**
         * <p>
         * The count of recommendations per strategy.
         * </p>
         * 
         * @param count
         *        The count of recommendations per strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The name of recommended strategy.
         * </p>
         * 
         * @param strategy
         *        The name of recommended strategy.
         * @see Strategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Strategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The name of recommended strategy.
         * </p>
         * 
         * @param strategy
         *        The name of recommended strategy.
         * @see Strategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Strategy
         */
        Builder strategy(Strategy strategy);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(StrategySummary model) {
            count(model.count);
            strategy(model.strategy);
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getStrategy() {
            return strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        @Transient
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        @Transient
        public final Builder strategy(Strategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        @Override
        public StrategySummary build() {
            return new StrategySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
