/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentDetail;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentDetailsCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationComponentsResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, ListApplicationComponentsResponse> {
    private static final SdkField<List<ApplicationComponentDetail>> APPLICATION_COMPONENT_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationComponentInfos").getter(ListApplicationComponentsResponse.getter(ListApplicationComponentsResponse::applicationComponentInfos)).setter(ListApplicationComponentsResponse.setter(Builder::applicationComponentInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationComponentInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationComponentDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListApplicationComponentsResponse.getter(ListApplicationComponentsResponse::nextToken)).setter(ListApplicationComponentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_COMPONENT_INFOS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ApplicationComponentDetail> applicationComponentInfos;
    private final String nextToken;

    private ListApplicationComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationComponentInfos = builder.applicationComponentInfos;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationComponentInfos() {
        return this.applicationComponentInfos != null && !(this.applicationComponentInfos instanceof SdkAutoConstructList);
    }

    public final List<ApplicationComponentDetail> applicationComponentInfos() {
        return this.applicationComponentInfos;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationComponentInfos() ? this.applicationComponentInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationComponentsResponse)) {
            return false;
        }
        ListApplicationComponentsResponse other = (ListApplicationComponentsResponse)((Object)obj);
        return this.hasApplicationComponentInfos() == other.hasApplicationComponentInfos() && Objects.equals(this.applicationComponentInfos(), other.applicationComponentInfos()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationComponentsResponse").add("ApplicationComponentInfos", this.hasApplicationComponentInfos() ? this.applicationComponentInfos() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationComponentInfos": {
                return Optional.ofNullable(clazz.cast(this.applicationComponentInfos()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationComponentsResponse, T> g) {
        return obj -> g.apply((ListApplicationComponentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private List<ApplicationComponentDetail> applicationComponentInfos = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationComponentsResponse model) {
            super(model);
            this.applicationComponentInfos(model.applicationComponentInfos);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationComponentDetail.Builder> getApplicationComponentInfos() {
            List<ApplicationComponentDetail.Builder> result = ApplicationComponentDetailsCopier.copyToBuilder(this.applicationComponentInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationComponentInfos(Collection<ApplicationComponentDetail.BuilderImpl> applicationComponentInfos) {
            this.applicationComponentInfos = ApplicationComponentDetailsCopier.copyFromBuilder(applicationComponentInfos);
        }

        @Override
        @Transient
        public final Builder applicationComponentInfos(Collection<ApplicationComponentDetail> applicationComponentInfos) {
            this.applicationComponentInfos = ApplicationComponentDetailsCopier.copy(applicationComponentInfos);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applicationComponentInfos(ApplicationComponentDetail ... applicationComponentInfos) {
            this.applicationComponentInfos(Arrays.asList(applicationComponentInfos));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applicationComponentInfos(Consumer<ApplicationComponentDetail.Builder> ... applicationComponentInfos) {
            this.applicationComponentInfos(Stream.of(applicationComponentInfos).map(c -> (ApplicationComponentDetail)((ApplicationComponentDetail.Builder)ApplicationComponentDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationComponentsResponse build() {
            return new ListApplicationComponentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationComponentsResponse> {
        public Builder applicationComponentInfos(Collection<ApplicationComponentDetail> var1);

        public Builder applicationComponentInfos(ApplicationComponentDetail ... var1);

        public Builder applicationComponentInfos(Consumer<ApplicationComponentDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

