/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAssessmentRequest
extends MigrationHubStrategyRequest
implements ToCopyableBuilder<Builder, StartAssessmentRequest> {
    private static final SdkField<String> S3_BUCKET_FOR_ANALYSIS_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3bucketForAnalysisData").getter(StartAssessmentRequest.getter(StartAssessmentRequest::s3bucketForAnalysisData)).setter(StartAssessmentRequest.setter(Builder::s3bucketForAnalysisData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3bucketForAnalysisData").build()}).build();
    private static final SdkField<String> S3_BUCKET_FOR_REPORT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3bucketForReportData").getter(StartAssessmentRequest.getter(StartAssessmentRequest::s3bucketForReportData)).setter(StartAssessmentRequest.setter(Builder::s3bucketForReportData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3bucketForReportData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FOR_ANALYSIS_DATA_FIELD, S3_BUCKET_FOR_REPORT_DATA_FIELD));
    private final String s3bucketForAnalysisData;
    private final String s3bucketForReportData;

    private StartAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.s3bucketForAnalysisData = builder.s3bucketForAnalysisData;
        this.s3bucketForReportData = builder.s3bucketForReportData;
    }

    public final String s3bucketForAnalysisData() {
        return this.s3bucketForAnalysisData;
    }

    public final String s3bucketForReportData() {
        return this.s3bucketForReportData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.s3bucketForAnalysisData());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3bucketForReportData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssessmentRequest)) {
            return false;
        }
        StartAssessmentRequest other = (StartAssessmentRequest)((Object)obj);
        return Objects.equals(this.s3bucketForAnalysisData(), other.s3bucketForAnalysisData()) && Objects.equals(this.s3bucketForReportData(), other.s3bucketForReportData());
    }

    public final String toString() {
        return ToString.builder((String)"StartAssessmentRequest").add("S3bucketForAnalysisData", (Object)this.s3bucketForAnalysisData()).add("S3bucketForReportData", (Object)this.s3bucketForReportData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3bucketForAnalysisData": {
                return Optional.ofNullable(clazz.cast(this.s3bucketForAnalysisData()));
            }
            case "s3bucketForReportData": {
                return Optional.ofNullable(clazz.cast(this.s3bucketForReportData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssessmentRequest, T> g) {
        return obj -> g.apply((StartAssessmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyRequest.BuilderImpl
    implements Builder {
        private String s3bucketForAnalysisData;
        private String s3bucketForReportData;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssessmentRequest model) {
            super(model);
            this.s3bucketForAnalysisData(model.s3bucketForAnalysisData);
            this.s3bucketForReportData(model.s3bucketForReportData);
        }

        public final String getS3bucketForAnalysisData() {
            return this.s3bucketForAnalysisData;
        }

        public final void setS3bucketForAnalysisData(String s3bucketForAnalysisData) {
            this.s3bucketForAnalysisData = s3bucketForAnalysisData;
        }

        @Override
        @Transient
        public final Builder s3bucketForAnalysisData(String s3bucketForAnalysisData) {
            this.s3bucketForAnalysisData = s3bucketForAnalysisData;
            return this;
        }

        public final String getS3bucketForReportData() {
            return this.s3bucketForReportData;
        }

        public final void setS3bucketForReportData(String s3bucketForReportData) {
            this.s3bucketForReportData = s3bucketForReportData;
        }

        @Override
        @Transient
        public final Builder s3bucketForReportData(String s3bucketForReportData) {
            this.s3bucketForReportData = s3bucketForReportData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssessmentRequest build() {
            return new StartAssessmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAssessmentRequest> {
        public Builder s3bucketForAnalysisData(String var1);

        public Builder s3bucketForReportData(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

