/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a strategy recommendation for an application component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationComponentStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationComponentStrategy.Builder, ApplicationComponentStrategy> {
    private static final SdkField<Boolean> IS_PREFERRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPreferred").getter(getter(ApplicationComponentStrategy::isPreferred))
            .setter(setter(Builder::isPreferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPreferred").build()).build();

    private static final SdkField<RecommendationSet> RECOMMENDATION_FIELD = SdkField
            .<RecommendationSet> builder(MarshallingType.SDK_POJO).memberName("recommendation")
            .getter(getter(ApplicationComponentStrategy::recommendation)).setter(setter(Builder::recommendation))
            .constructor(RecommendationSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ApplicationComponentStrategy::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_PREFERRED_FIELD,
            RECOMMENDATION_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isPreferred;

    private final RecommendationSet recommendation;

    private final String status;

    private ApplicationComponentStrategy(BuilderImpl builder) {
        this.isPreferred = builder.isPreferred;
        this.recommendation = builder.recommendation;
        this.status = builder.status;
    }

    /**
     * <p>
     * Set to true if the recommendation is set as preferred.
     * </p>
     * 
     * @return Set to true if the recommendation is set as preferred.
     */
    public final Boolean isPreferred() {
        return isPreferred;
    }

    /**
     * <p>
     * Strategy recommendation for the application component.
     * </p>
     * 
     * @return Strategy recommendation for the application component.
     */
    public final RecommendationSet recommendation() {
        return recommendation;
    }

    /**
     * <p>
     * The recommendation status of a strategy for an application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StrategyRecommendation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The recommendation status of a strategy for an application component.
     * @see StrategyRecommendation
     */
    public final StrategyRecommendation status() {
        return StrategyRecommendation.fromValue(status);
    }

    /**
     * <p>
     * The recommendation status of a strategy for an application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StrategyRecommendation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The recommendation status of a strategy for an application component.
     * @see StrategyRecommendation
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isPreferred());
        hashCode = 31 * hashCode + Objects.hashCode(recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationComponentStrategy)) {
            return false;
        }
        ApplicationComponentStrategy other = (ApplicationComponentStrategy) obj;
        return Objects.equals(isPreferred(), other.isPreferred()) && Objects.equals(recommendation(), other.recommendation())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationComponentStrategy").add("IsPreferred", isPreferred())
                .add("Recommendation", recommendation()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isPreferred":
            return Optional.ofNullable(clazz.cast(isPreferred()));
        case "recommendation":
            return Optional.ofNullable(clazz.cast(recommendation()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationComponentStrategy, T> g) {
        return obj -> g.apply((ApplicationComponentStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationComponentStrategy> {
        /**
         * <p>
         * Set to true if the recommendation is set as preferred.
         * </p>
         * 
         * @param isPreferred
         *        Set to true if the recommendation is set as preferred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPreferred(Boolean isPreferred);

        /**
         * <p>
         * Strategy recommendation for the application component.
         * </p>
         * 
         * @param recommendation
         *        Strategy recommendation for the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendation(RecommendationSet recommendation);

        /**
         * <p>
         * Strategy recommendation for the application component.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationSet.Builder} avoiding the
         * need to create one manually via {@link RecommendationSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #recommendation(RecommendationSet)}.
         * 
         * @param recommendation
         *        a consumer that will call methods on {@link RecommendationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendation(RecommendationSet)
         */
        default Builder recommendation(Consumer<RecommendationSet.Builder> recommendation) {
            return recommendation(RecommendationSet.builder().applyMutation(recommendation).build());
        }

        /**
         * <p>
         * The recommendation status of a strategy for an application component.
         * </p>
         * 
         * @param status
         *        The recommendation status of a strategy for an application component.
         * @see StrategyRecommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StrategyRecommendation
         */
        Builder status(String status);

        /**
         * <p>
         * The recommendation status of a strategy for an application component.
         * </p>
         * 
         * @param status
         *        The recommendation status of a strategy for an application component.
         * @see StrategyRecommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StrategyRecommendation
         */
        Builder status(StrategyRecommendation status);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isPreferred;

        private RecommendationSet recommendation;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationComponentStrategy model) {
            isPreferred(model.isPreferred);
            recommendation(model.recommendation);
            status(model.status);
        }

        public final Boolean getIsPreferred() {
            return isPreferred;
        }

        public final void setIsPreferred(Boolean isPreferred) {
            this.isPreferred = isPreferred;
        }

        @Override
        public final Builder isPreferred(Boolean isPreferred) {
            this.isPreferred = isPreferred;
            return this;
        }

        public final RecommendationSet.Builder getRecommendation() {
            return recommendation != null ? recommendation.toBuilder() : null;
        }

        public final void setRecommendation(RecommendationSet.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(RecommendationSet recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StrategyRecommendation status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ApplicationComponentStrategy build() {
            return new ApplicationComponentStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
