/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the server that hosts application components.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemInfo implements SdkPojo, Serializable, ToCopyableBuilder<SystemInfo.Builder, SystemInfo> {
    private static final SdkField<String> CPU_ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cpuArchitecture").getter(getter(SystemInfo::cpuArchitecture)).setter(setter(Builder::cpuArchitecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuArchitecture").build()).build();

    private static final SdkField<String> FILE_SYSTEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileSystemType").getter(getter(SystemInfo::fileSystemType)).setter(setter(Builder::fileSystemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemType").build()).build();

    private static final SdkField<List<NetworkInfo>> NETWORK_INFO_LIST_FIELD = SdkField
            .<List<NetworkInfo>> builder(MarshallingType.LIST)
            .memberName("networkInfoList")
            .getter(getter(SystemInfo::networkInfoList))
            .setter(setter(Builder::networkInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OSInfo> OS_INFO_FIELD = SdkField.<OSInfo> builder(MarshallingType.SDK_POJO)
            .memberName("osInfo").getter(getter(SystemInfo::osInfo)).setter(setter(Builder::osInfo)).constructor(OSInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_ARCHITECTURE_FIELD,
            FILE_SYSTEM_TYPE_FIELD, NETWORK_INFO_LIST_FIELD, OS_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cpuArchitecture;

    private final String fileSystemType;

    private final List<NetworkInfo> networkInfoList;

    private final OSInfo osInfo;

    private SystemInfo(BuilderImpl builder) {
        this.cpuArchitecture = builder.cpuArchitecture;
        this.fileSystemType = builder.fileSystemType;
        this.networkInfoList = builder.networkInfoList;
        this.osInfo = builder.osInfo;
    }

    /**
     * <p>
     * CPU architecture type for the server.
     * </p>
     * 
     * @return CPU architecture type for the server.
     */
    public final String cpuArchitecture() {
        return cpuArchitecture;
    }

    /**
     * <p>
     * File system type for the server.
     * </p>
     * 
     * @return File system type for the server.
     */
    public final String fileSystemType() {
        return fileSystemType;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInfoList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInfoList() {
        return networkInfoList != null && !(networkInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Networking information related to a server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInfoList} method.
     * </p>
     * 
     * @return Networking information related to a server.
     */
    public final List<NetworkInfo> networkInfoList() {
        return networkInfoList;
    }

    /**
     * <p>
     * Operating system corresponding to a server.
     * </p>
     * 
     * @return Operating system corresponding to a server.
     */
    public final OSInfo osInfo() {
        return osInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpuArchitecture());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemType());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInfoList() ? networkInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(osInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemInfo)) {
            return false;
        }
        SystemInfo other = (SystemInfo) obj;
        return Objects.equals(cpuArchitecture(), other.cpuArchitecture())
                && Objects.equals(fileSystemType(), other.fileSystemType()) && hasNetworkInfoList() == other.hasNetworkInfoList()
                && Objects.equals(networkInfoList(), other.networkInfoList()) && Objects.equals(osInfo(), other.osInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SystemInfo").add("CpuArchitecture", cpuArchitecture()).add("FileSystemType", fileSystemType())
                .add("NetworkInfoList", hasNetworkInfoList() ? networkInfoList() : null).add("OsInfo", osInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cpuArchitecture":
            return Optional.ofNullable(clazz.cast(cpuArchitecture()));
        case "fileSystemType":
            return Optional.ofNullable(clazz.cast(fileSystemType()));
        case "networkInfoList":
            return Optional.ofNullable(clazz.cast(networkInfoList()));
        case "osInfo":
            return Optional.ofNullable(clazz.cast(osInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemInfo, T> g) {
        return obj -> g.apply((SystemInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemInfo> {
        /**
         * <p>
         * CPU architecture type for the server.
         * </p>
         * 
         * @param cpuArchitecture
         *        CPU architecture type for the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuArchitecture(String cpuArchitecture);

        /**
         * <p>
         * File system type for the server.
         * </p>
         * 
         * @param fileSystemType
         *        File system type for the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemType(String fileSystemType);

        /**
         * <p>
         * Networking information related to a server.
         * </p>
         * 
         * @param networkInfoList
         *        Networking information related to a server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInfoList(Collection<NetworkInfo> networkInfoList);

        /**
         * <p>
         * Networking information related to a server.
         * </p>
         * 
         * @param networkInfoList
         *        Networking information related to a server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInfoList(NetworkInfo... networkInfoList);

        /**
         * <p>
         * Networking information related to a server.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.NetworkInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.NetworkInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.NetworkInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #networkInfoList(List<NetworkInfo>)}.
         * 
         * @param networkInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.NetworkInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInfoList(java.util.Collection<NetworkInfo>)
         */
        Builder networkInfoList(Consumer<NetworkInfo.Builder>... networkInfoList);

        /**
         * <p>
         * Operating system corresponding to a server.
         * </p>
         * 
         * @param osInfo
         *        Operating system corresponding to a server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osInfo(OSInfo osInfo);

        /**
         * <p>
         * Operating system corresponding to a server.
         * </p>
         * This is a convenience method that creates an instance of the {@link OSInfo.Builder} avoiding the need to
         * create one manually via {@link OSInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OSInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #osInfo(OSInfo)}.
         * 
         * @param osInfo
         *        a consumer that will call methods on {@link OSInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #osInfo(OSInfo)
         */
        default Builder osInfo(Consumer<OSInfo.Builder> osInfo) {
            return osInfo(OSInfo.builder().applyMutation(osInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String cpuArchitecture;

        private String fileSystemType;

        private List<NetworkInfo> networkInfoList = DefaultSdkAutoConstructList.getInstance();

        private OSInfo osInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemInfo model) {
            cpuArchitecture(model.cpuArchitecture);
            fileSystemType(model.fileSystemType);
            networkInfoList(model.networkInfoList);
            osInfo(model.osInfo);
        }

        public final String getCpuArchitecture() {
            return cpuArchitecture;
        }

        public final void setCpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
        }

        @Override
        public final Builder cpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
            return this;
        }

        public final String getFileSystemType() {
            return fileSystemType;
        }

        public final void setFileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
        }

        @Override
        public final Builder fileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
            return this;
        }

        public final List<NetworkInfo.Builder> getNetworkInfoList() {
            List<NetworkInfo.Builder> result = NetworkInfoListCopier.copyToBuilder(this.networkInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInfoList(Collection<NetworkInfo.BuilderImpl> networkInfoList) {
            this.networkInfoList = NetworkInfoListCopier.copyFromBuilder(networkInfoList);
        }

        @Override
        public final Builder networkInfoList(Collection<NetworkInfo> networkInfoList) {
            this.networkInfoList = NetworkInfoListCopier.copy(networkInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInfoList(NetworkInfo... networkInfoList) {
            networkInfoList(Arrays.asList(networkInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInfoList(Consumer<NetworkInfo.Builder>... networkInfoList) {
            networkInfoList(Stream.of(networkInfoList).map(c -> NetworkInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OSInfo.Builder getOsInfo() {
            return osInfo != null ? osInfo.toBuilder() : null;
        }

        public final void setOsInfo(OSInfo.BuilderImpl osInfo) {
            this.osInfo = osInfo != null ? osInfo.build() : null;
        }

        @Override
        public final Builder osInfo(OSInfo osInfo) {
            this.osInfo = osInfo;
            return this;
        }

        @Override
        public SystemInfo build() {
            return new SystemInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
