/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentDetailsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentStrategiesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentStrategiesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetAssessmentRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetAssessmentResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetImportFileTaskResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetLatestAssessmentIdRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetLatestAssessmentIdResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioPreferencesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioPreferencesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioSummaryRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioSummaryResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetRecommendationReportDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetRecommendationReportDetailsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerStrategiesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerStrategiesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.PutPortfolioPreferencesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.PutPortfolioPreferencesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartAssessmentRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartAssessmentResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartImportFileTaskResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartRecommendationReportGenerationRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartRecommendationReportGenerationResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.StopAssessmentRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StopAssessmentResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateApplicationComponentConfigRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateApplicationComponentConfigResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateServerConfigRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateServerConfigResponse;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsPublisher;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersPublisher;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsPublisher;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsPublisher;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskPublisher;
import software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersPublisher;

/**
 * Service client for accessing Migration Hub Strategy Recommendations asynchronously. This can be created using the
 * static {@link #builder()} method.
 *
 * <p>
 * <fullname>Migration Hub Strategy Recommendations</fullname>
 * <p>
 * This API reference provides descriptions, syntax, and other details about each of the actions and data types for
 * Migration Hub Strategy Recommendations (Strategy Recommendations). The topic for each action shows the API request
 * parameters and the response. Alternatively, you can use one of the AWS SDKs to access an API that is tailored to the
 * programming language or platform that you're using. For more information, see <a
 * href="http://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MigrationHubStrategyAsyncClient extends AwsClient {
    String SERVICE_NAME = "migrationhub-strategy";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "migrationhub-strategy";

    /**
     * <p>
     * Retrieves details about an application component.
     * </p>
     *
     * @param getApplicationComponentDetailsRequest
     * @return A Java Future containing the result of the GetApplicationComponentDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetApplicationComponentDetails
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationComponentDetailsResponse> getApplicationComponentDetails(
            GetApplicationComponentDetailsRequest getApplicationComponentDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an application component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationComponentDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetApplicationComponentDetailsRequest#builder()}
     * </p>
     *
     * @param getApplicationComponentDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentDetailsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetApplicationComponentDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetApplicationComponentDetails
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationComponentDetailsResponse> getApplicationComponentDetails(
            Consumer<GetApplicationComponentDetailsRequest.Builder> getApplicationComponentDetailsRequest) {
        return getApplicationComponentDetails(GetApplicationComponentDetailsRequest.builder()
                .applyMutation(getApplicationComponentDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the recommended strategies and tools for an application component running on a server.
     * </p>
     *
     * @param getApplicationComponentStrategiesRequest
     * @return A Java Future containing the result of the GetApplicationComponentStrategies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetApplicationComponentStrategies
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationComponentStrategiesResponse> getApplicationComponentStrategies(
            GetApplicationComponentStrategiesRequest getApplicationComponentStrategiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all the recommended strategies and tools for an application component running on a server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationComponentStrategiesRequest.Builder}
     * avoiding the need to create one manually via {@link GetApplicationComponentStrategiesRequest#builder()}
     * </p>
     *
     * @param getApplicationComponentStrategiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentStrategiesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetApplicationComponentStrategies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetApplicationComponentStrategies
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetApplicationComponentStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationComponentStrategiesResponse> getApplicationComponentStrategies(
            Consumer<GetApplicationComponentStrategiesRequest.Builder> getApplicationComponentStrategiesRequest) {
        return getApplicationComponentStrategies(GetApplicationComponentStrategiesRequest.builder()
                .applyMutation(getApplicationComponentStrategiesRequest).build());
    }

    /**
     * <p>
     * Retrieves the status of an on-going assessment.
     * </p>
     *
     * @param getAssessmentRequest
     * @return A Java Future containing the result of the GetAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssessmentResponse> getAssessment(GetAssessmentRequest getAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of an on-going assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssessmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssessmentRequest#builder()}
     * </p>
     *
     * @param getAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetAssessmentRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssessmentResponse> getAssessment(Consumer<GetAssessmentRequest.Builder> getAssessmentRequest) {
        return getAssessment(GetAssessmentRequest.builder().applyMutation(getAssessmentRequest).build());
    }

    /**
     * <p>
     * Retrieves the details about a specific import task.
     * </p>
     *
     * @param getImportFileTaskRequest
     * @return A Java Future containing the result of the GetImportFileTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetImportFileTaskResponse> getImportFileTask(GetImportFileTaskRequest getImportFileTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details about a specific import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportFileTaskRequest.Builder} avoiding the need
     * to create one manually via {@link GetImportFileTaskRequest#builder()}
     * </p>
     *
     * @param getImportFileTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetImportFileTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetImportFileTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetImportFileTaskResponse> getImportFileTask(
            Consumer<GetImportFileTaskRequest.Builder> getImportFileTaskRequest) {
        return getImportFileTask(GetImportFileTaskRequest.builder().applyMutation(getImportFileTaskRequest).build());
    }

    /**
     * <p>
     * Retrieve the latest ID of a specific assessment task.
     * </p>
     *
     * @param getLatestAssessmentIdRequest
     * @return A Java Future containing the result of the GetLatestAssessmentId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetLatestAssessmentId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetLatestAssessmentId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLatestAssessmentIdResponse> getLatestAssessmentId(
            GetLatestAssessmentIdRequest getLatestAssessmentIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the latest ID of a specific assessment task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLatestAssessmentIdRequest.Builder} avoiding the
     * need to create one manually via {@link GetLatestAssessmentIdRequest#builder()}
     * </p>
     *
     * @param getLatestAssessmentIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetLatestAssessmentIdRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetLatestAssessmentId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DependencyException Dependency encountered an error.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetLatestAssessmentId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetLatestAssessmentId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLatestAssessmentIdResponse> getLatestAssessmentId(
            Consumer<GetLatestAssessmentIdRequest.Builder> getLatestAssessmentIdRequest) {
        return getLatestAssessmentId(GetLatestAssessmentIdRequest.builder().applyMutation(getLatestAssessmentIdRequest).build());
    }

    /**
     * <p>
     * Retrieves your migration and modernization preferences.
     * </p>
     *
     * @param getPortfolioPreferencesRequest
     * @return A Java Future containing the result of the GetPortfolioPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetPortfolioPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPortfolioPreferencesResponse> getPortfolioPreferences(
            GetPortfolioPreferencesRequest getPortfolioPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves your migration and modernization preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPortfolioPreferencesRequest.Builder} avoiding
     * the need to create one manually via {@link GetPortfolioPreferencesRequest#builder()}
     * </p>
     *
     * @param getPortfolioPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioPreferencesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetPortfolioPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetPortfolioPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPortfolioPreferencesResponse> getPortfolioPreferences(
            Consumer<GetPortfolioPreferencesRequest.Builder> getPortfolioPreferencesRequest) {
        return getPortfolioPreferences(GetPortfolioPreferencesRequest.builder().applyMutation(getPortfolioPreferencesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves overall summary including the number of servers to rehost and the overall number of anti-patterns.
     * </p>
     *
     * @param getPortfolioSummaryRequest
     * @return A Java Future containing the result of the GetPortfolioSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetPortfolioSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPortfolioSummaryResponse> getPortfolioSummary(
            GetPortfolioSummaryRequest getPortfolioSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves overall summary including the number of servers to rehost and the overall number of anti-patterns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPortfolioSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetPortfolioSummaryRequest#builder()}
     * </p>
     *
     * @param getPortfolioSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioSummaryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetPortfolioSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetPortfolioSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetPortfolioSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPortfolioSummaryResponse> getPortfolioSummary(
            Consumer<GetPortfolioSummaryRequest.Builder> getPortfolioSummaryRequest) {
        return getPortfolioSummary(GetPortfolioSummaryRequest.builder().applyMutation(getPortfolioSummaryRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about the specified recommendation report.
     * </p>
     *
     * @param getRecommendationReportDetailsRequest
     * @return A Java Future containing the result of the GetRecommendationReportDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetRecommendationReportDetails
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetRecommendationReportDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationReportDetailsResponse> getRecommendationReportDetails(
            GetRecommendationReportDetailsRequest getRecommendationReportDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about the specified recommendation report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationReportDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecommendationReportDetailsRequest#builder()}
     * </p>
     *
     * @param getRecommendationReportDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetRecommendationReportDetailsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetRecommendationReportDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetRecommendationReportDetails
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetRecommendationReportDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationReportDetailsResponse> getRecommendationReportDetails(
            Consumer<GetRecommendationReportDetailsRequest.Builder> getRecommendationReportDetailsRequest) {
        return getRecommendationReportDetails(GetRecommendationReportDetailsRequest.builder()
                .applyMutation(getRecommendationReportDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specified server.
     * </p>
     *
     * @param getServerDetailsRequest
     * @return A Java Future containing the result of the GetServerDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetServerDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServerDetailsResponse> getServerDetails(GetServerDetailsRequest getServerDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specified server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServerDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link GetServerDetailsRequest#builder()}
     * </p>
     *
     * @param getServerDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetServerDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetServerDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServerDetailsResponse> getServerDetails(
            Consumer<GetServerDetailsRequest.Builder> getServerDetailsRequest) {
        return getServerDetails(GetServerDetailsRequest.builder().applyMutation(getServerDetailsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getServerDetails(software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsPublisher publisher = client.getServerDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsPublisher publisher = client.getServerDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getServerDetails(software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getServerDetailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetServerDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServerDetailsPublisher getServerDetailsPaginator(GetServerDetailsRequest getServerDetailsRequest) {
        return new GetServerDetailsPublisher(this, getServerDetailsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getServerDetails(software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsPublisher publisher = client.getServerDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.GetServerDetailsPublisher publisher = client.getServerDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getServerDetails(software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServerDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link GetServerDetailsRequest#builder()}
     * </p>
     *
     * @param getServerDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetServerDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServerDetailsPublisher getServerDetailsPaginator(Consumer<GetServerDetailsRequest.Builder> getServerDetailsRequest) {
        return getServerDetailsPaginator(GetServerDetailsRequest.builder().applyMutation(getServerDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves recommended strategies and tools for the specified server.
     * </p>
     *
     * @param getServerStrategiesRequest
     * @return A Java Future containing the result of the GetServerStrategies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetServerStrategies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServerStrategiesResponse> getServerStrategies(
            GetServerStrategiesRequest getServerStrategiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves recommended strategies and tools for the specified server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServerStrategiesRequest.Builder} avoiding the
     * need to create one manually via {@link GetServerStrategiesRequest#builder()}
     * </p>
     *
     * @param getServerStrategiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.GetServerStrategiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetServerStrategies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.GetServerStrategies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/GetServerStrategies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServerStrategiesResponse> getServerStrategies(
            Consumer<GetServerStrategiesRequest.Builder> getServerStrategiesRequest) {
        return getServerStrategies(GetServerStrategiesRequest.builder().applyMutation(getServerStrategiesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the servers fetched from customer vCenter using Strategy Recommendation Collector.
     * </p>
     *
     * @param listAnalyzableServersRequest
     *        Represents input for ListAnalyzableServers operation.
     * @return A Java Future containing the result of the ListAnalyzableServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListAnalyzableServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListAnalyzableServers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnalyzableServersResponse> listAnalyzableServers(
            ListAnalyzableServersRequest listAnalyzableServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all the servers fetched from customer vCenter using Strategy Recommendation Collector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalyzableServersRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnalyzableServersRequest#builder()}
     * </p>
     *
     * @param listAnalyzableServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest.Builder} to
     *        create a request. Represents input for ListAnalyzableServers operation.
     * @return A Java Future containing the result of the ListAnalyzableServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListAnalyzableServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListAnalyzableServers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnalyzableServersResponse> listAnalyzableServers(
            Consumer<ListAnalyzableServersRequest.Builder> listAnalyzableServersRequest) {
        return listAnalyzableServers(ListAnalyzableServersRequest.builder().applyMutation(listAnalyzableServersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnalyzableServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersPublisher publisher = client.listAnalyzableServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersPublisher publisher = client.listAnalyzableServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyzableServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnalyzableServersRequest
     *        Represents input for ListAnalyzableServers operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListAnalyzableServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListAnalyzableServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalyzableServersPublisher listAnalyzableServersPaginator(
            ListAnalyzableServersRequest listAnalyzableServersRequest) {
        return new ListAnalyzableServersPublisher(this, listAnalyzableServersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnalyzableServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersPublisher publisher = client.listAnalyzableServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListAnalyzableServersPublisher publisher = client.listAnalyzableServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyzableServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalyzableServersRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnalyzableServersRequest#builder()}
     * </p>
     *
     * @param listAnalyzableServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest.Builder} to
     *        create a request. Represents input for ListAnalyzableServers operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListAnalyzableServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListAnalyzableServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalyzableServersPublisher listAnalyzableServersPaginator(
            Consumer<ListAnalyzableServersRequest.Builder> listAnalyzableServersRequest) {
        return listAnalyzableServersPaginator(ListAnalyzableServersRequest.builder().applyMutation(listAnalyzableServersRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of all the application components (processes).
     * </p>
     *
     * @param listApplicationComponentsRequest
     * @return A Java Future containing the result of the ListApplicationComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ServiceLinkedRoleLockClientException Exception to indicate that the service-linked role (SLR) is
     *         locked.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListApplicationComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListApplicationComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationComponentsResponse> listApplicationComponents(
            ListApplicationComponentsRequest listApplicationComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all the application components (processes).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationComponentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationComponentsRequest#builder()}
     * </p>
     *
     * @param listApplicationComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListApplicationComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ServiceLinkedRoleLockClientException Exception to indicate that the service-linked role (SLR) is
     *         locked.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListApplicationComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListApplicationComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationComponentsResponse> listApplicationComponents(
            Consumer<ListApplicationComponentsRequest.Builder> listApplicationComponentsRequest) {
        return listApplicationComponents(ListApplicationComponentsRequest.builder()
                .applyMutation(listApplicationComponentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationComponents(software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsPublisher publisher = client.listApplicationComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsPublisher publisher = client.listApplicationComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationComponents(software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ServiceLinkedRoleLockClientException Exception to indicate that the service-linked role (SLR) is
     *         locked.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListApplicationComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListApplicationComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationComponentsPublisher listApplicationComponentsPaginator(
            ListApplicationComponentsRequest listApplicationComponentsRequest) {
        return new ListApplicationComponentsPublisher(this, listApplicationComponentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationComponents(software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsPublisher publisher = client.listApplicationComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListApplicationComponentsPublisher publisher = client.listApplicationComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationComponents(software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationComponentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationComponentsRequest#builder()}
     * </p>
     *
     * @param listApplicationComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ServiceLinkedRoleLockClientException Exception to indicate that the service-linked role (SLR) is
     *         locked.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListApplicationComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListApplicationComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationComponentsPublisher listApplicationComponentsPaginator(
            Consumer<ListApplicationComponentsRequest.Builder> listApplicationComponentsRequest) {
        return listApplicationComponentsPaginator(ListApplicationComponentsRequest.builder()
                .applyMutation(listApplicationComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the installed collectors.
     * </p>
     *
     * @param listCollectorsRequest
     * @return A Java Future containing the result of the ListCollectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollectorsResponse> listCollectors(ListCollectorsRequest listCollectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all the installed collectors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCollectorsRequest#builder()}
     * </p>
     *
     * @param listCollectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListCollectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollectorsResponse> listCollectors(Consumer<ListCollectorsRequest.Builder> listCollectorsRequest) {
        return listCollectors(ListCollectorsRequest.builder().applyMutation(listCollectorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollectors(software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsPublisher publisher = client.listCollectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsPublisher publisher = client.listCollectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollectors(software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectorsPublisher listCollectorsPaginator(ListCollectorsRequest listCollectorsRequest) {
        return new ListCollectorsPublisher(this, listCollectorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollectors(software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsPublisher publisher = client.listCollectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListCollectorsPublisher publisher = client.listCollectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollectors(software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCollectorsRequest#builder()}
     * </p>
     *
     * @param listCollectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectorsPublisher listCollectorsPaginator(Consumer<ListCollectorsRequest.Builder> listCollectorsRequest) {
        return listCollectorsPaginator(ListCollectorsRequest.builder().applyMutation(listCollectorsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all the imports performed.
     * </p>
     *
     * @param listImportFileTaskRequest
     * @return A Java Future containing the result of the ListImportFileTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImportFileTaskResponse> listImportFileTask(ListImportFileTaskRequest listImportFileTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all the imports performed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportFileTaskRequest.Builder} avoiding the
     * need to create one manually via {@link ListImportFileTaskRequest#builder()}
     * </p>
     *
     * @param listImportFileTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListImportFileTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImportFileTaskResponse> listImportFileTask(
            Consumer<ListImportFileTaskRequest.Builder> listImportFileTaskRequest) {
        return listImportFileTask(ListImportFileTaskRequest.builder().applyMutation(listImportFileTaskRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportFileTask(software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskPublisher publisher = client.listImportFileTaskPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskPublisher publisher = client.listImportFileTaskPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportFileTask(software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImportFileTaskRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImportFileTaskPublisher listImportFileTaskPaginator(ListImportFileTaskRequest listImportFileTaskRequest) {
        return new ListImportFileTaskPublisher(this, listImportFileTaskRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportFileTask(software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskPublisher publisher = client.listImportFileTaskPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListImportFileTaskPublisher publisher = client.listImportFileTaskPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportFileTask(software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportFileTaskRequest.Builder} avoiding the
     * need to create one manually via {@link ListImportFileTaskRequest#builder()}
     * </p>
     *
     * @param listImportFileTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImportFileTaskPublisher listImportFileTaskPaginator(
            Consumer<ListImportFileTaskRequest.Builder> listImportFileTaskRequest) {
        return listImportFileTaskPaginator(ListImportFileTaskRequest.builder().applyMutation(listImportFileTaskRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the servers.
     * </p>
     *
     * @param listServersRequest
     * @return A Java Future containing the result of the ListServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListServers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServersResponse> listServers(ListServersRequest listServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the servers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListServersRequest#builder()}
     * </p>
     *
     * @param listServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListServers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServersResponse> listServers(Consumer<ListServersRequest.Builder> listServersRequest) {
        return listServers(ListServersRequest.builder().applyMutation(listServersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersPublisher publisher = client.listServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersPublisher publisher = client.listServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServersPublisher listServersPaginator(ListServersRequest listServersRequest) {
        return new ListServersPublisher(this, listServersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersPublisher publisher = client.listServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubstrategy.paginators.ListServersPublisher publisher = client.listServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServers(software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListServersRequest#builder()}
     * </p>
     *
     * @param listServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/ListServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServersPublisher listServersPaginator(Consumer<ListServersRequest.Builder> listServersRequest) {
        return listServersPaginator(ListServersRequest.builder().applyMutation(listServersRequest).build());
    }

    /**
     * <p>
     * Saves the specified migration and modernization preferences.
     * </p>
     *
     * @param putPortfolioPreferencesRequest
     * @return A Java Future containing the result of the PutPortfolioPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>ConflictException Exception to indicate that there is an ongoing task when a new task is created.
     *         Return when once the existing tasks are complete.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.PutPortfolioPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/PutPortfolioPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutPortfolioPreferencesResponse> putPortfolioPreferences(
            PutPortfolioPreferencesRequest putPortfolioPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Saves the specified migration and modernization preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPortfolioPreferencesRequest.Builder} avoiding
     * the need to create one manually via {@link PutPortfolioPreferencesRequest#builder()}
     * </p>
     *
     * @param putPortfolioPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.PutPortfolioPreferencesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutPortfolioPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>ConflictException Exception to indicate that there is an ongoing task when a new task is created.
     *         Return when once the existing tasks are complete.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.PutPortfolioPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/PutPortfolioPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutPortfolioPreferencesResponse> putPortfolioPreferences(
            Consumer<PutPortfolioPreferencesRequest.Builder> putPortfolioPreferencesRequest) {
        return putPortfolioPreferences(PutPortfolioPreferencesRequest.builder().applyMutation(putPortfolioPreferencesRequest)
                .build());
    }

    /**
     * <p>
     * Starts the assessment of an on-premises environment.
     * </p>
     *
     * @param startAssessmentRequest
     * @return A Java Future containing the result of the StartAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The AWS account has reached its quota of imports. Contact AWS Support
     *         to increase the quota for this account.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.StartAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAssessmentResponse> startAssessment(StartAssessmentRequest startAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the assessment of an on-premises environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAssessmentRequest.Builder} avoiding the need
     * to create one manually via {@link StartAssessmentRequest#builder()}
     * </p>
     *
     * @param startAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StartAssessmentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The AWS account has reached its quota of imports. Contact AWS Support
     *         to increase the quota for this account.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.StartAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAssessmentResponse> startAssessment(
            Consumer<StartAssessmentRequest.Builder> startAssessmentRequest) {
        return startAssessment(StartAssessmentRequest.builder().applyMutation(startAssessmentRequest).build());
    }

    /**
     * <p>
     * Starts a file import.
     * </p>
     *
     * @param startImportFileTaskRequest
     * @return A Java Future containing the result of the StartImportFileTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The AWS account has reached its quota of imports. Contact AWS Support
     *         to increase the quota for this account.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.StartImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartImportFileTaskResponse> startImportFileTask(
            StartImportFileTaskRequest startImportFileTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a file import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportFileTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StartImportFileTaskRequest#builder()}
     * </p>
     *
     * @param startImportFileTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StartImportFileTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartImportFileTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The AWS account has reached its quota of imports. Contact AWS Support
     *         to increase the quota for this account.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.StartImportFileTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartImportFileTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartImportFileTaskResponse> startImportFileTask(
            Consumer<StartImportFileTaskRequest.Builder> startImportFileTaskRequest) {
        return startImportFileTask(StartImportFileTaskRequest.builder().applyMutation(startImportFileTaskRequest).build());
    }

    /**
     * <p>
     * Starts generating a recommendation report.
     * </p>
     *
     * @param startRecommendationReportGenerationRequest
     * @return A Java Future containing the result of the StartRecommendationReportGeneration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>ConflictException Exception to indicate that there is an ongoing task when a new task is created.
     *         Return when once the existing tasks are complete.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.StartRecommendationReportGeneration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartRecommendationReportGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartRecommendationReportGenerationResponse> startRecommendationReportGeneration(
            StartRecommendationReportGenerationRequest startRecommendationReportGenerationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts generating a recommendation report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRecommendationReportGenerationRequest.Builder}
     * avoiding the need to create one manually via {@link StartRecommendationReportGenerationRequest#builder()}
     * </p>
     *
     * @param startRecommendationReportGenerationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StartRecommendationReportGenerationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartRecommendationReportGeneration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>ConflictException Exception to indicate that there is an ongoing task when a new task is created.
     *         Return when once the existing tasks are complete.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.StartRecommendationReportGeneration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartRecommendationReportGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartRecommendationReportGenerationResponse> startRecommendationReportGeneration(
            Consumer<StartRecommendationReportGenerationRequest.Builder> startRecommendationReportGenerationRequest) {
        return startRecommendationReportGeneration(StartRecommendationReportGenerationRequest.builder()
                .applyMutation(startRecommendationReportGenerationRequest).build());
    }

    /**
     * <p>
     * Stops the assessment of an on-premises environment.
     * </p>
     *
     * @param stopAssessmentRequest
     * @return A Java Future containing the result of the StopAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.StopAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StopAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopAssessmentResponse> stopAssessment(StopAssessmentRequest stopAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the assessment of an on-premises environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopAssessmentRequest.Builder} avoiding the need to
     * create one manually via {@link StopAssessmentRequest#builder()}
     * </p>
     *
     * @param stopAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.StopAssessmentRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StopAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user does not have permission to perform the action. Check the AWS Identity
     *         and Access Management (IAM) policy associated with this user.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.StopAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StopAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopAssessmentResponse> stopAssessment(Consumer<StopAssessmentRequest.Builder> stopAssessmentRequest) {
        return stopAssessment(StopAssessmentRequest.builder().applyMutation(stopAssessmentRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an application component.
     * </p>
     *
     * @param updateApplicationComponentConfigRequest
     * @return A Java Future containing the result of the UpdateApplicationComponentConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.UpdateApplicationComponentConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateApplicationComponentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationComponentConfigResponse> updateApplicationComponentConfig(
            UpdateApplicationComponentConfigRequest updateApplicationComponentConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an application component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationComponentConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateApplicationComponentConfigRequest#builder()}
     * </p>
     *
     * @param updateApplicationComponentConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.UpdateApplicationComponentConfigRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateApplicationComponentConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.UpdateApplicationComponentConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateApplicationComponentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationComponentConfigResponse> updateApplicationComponentConfig(
            Consumer<UpdateApplicationComponentConfigRequest.Builder> updateApplicationComponentConfigRequest) {
        return updateApplicationComponentConfig(UpdateApplicationComponentConfigRequest.builder()
                .applyMutation(updateApplicationComponentConfigRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of the specified server.
     * </p>
     *
     * @param updateServerConfigRequest
     * @return A Java Future containing the result of the UpdateServerConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.UpdateServerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateServerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServerConfigResponse> updateServerConfig(UpdateServerConfigRequest updateServerConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of the specified server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServerConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServerConfigRequest#builder()}
     * </p>
     *
     * @param updateServerConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.UpdateServerConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateServerConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified ID in the request is not found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request body isn't valid.</li>
     *         <li>InternalServerException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubStrategyException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubStrategyAsyncClient.UpdateServerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/UpdateServerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServerConfigResponse> updateServerConfig(
            Consumer<UpdateServerConfigRequest.Builder> updateServerConfigRequest) {
        return updateServerConfig(UpdateServerConfigRequest.builder().applyMutation(updateServerConfigRequest).build());
    }

    @Override
    default MigrationHubStrategyServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MigrationHubStrategyAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MigrationHubStrategyAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MigrationHubStrategyAsyncClient}.
     */
    static MigrationHubStrategyAsyncClientBuilder builder() {
        return new DefaultMigrationHubStrategyAsyncClientBuilder();
    }
}
