/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about an analyzable server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyzableServerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyzableServerSummary.Builder, AnalyzableServerSummary> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(AnalyzableServerSummary::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddress").getter(getter(AnalyzableServerSummary::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(AnalyzableServerSummary::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> VM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vmId")
            .getter(getter(AnalyzableServerSummary::vmId)).setter(setter(Builder::vmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD,
            IP_ADDRESS_FIELD, SOURCE_FIELD, VM_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostname;

    private final String ipAddress;

    private final String source;

    private final String vmId;

    private AnalyzableServerSummary(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.ipAddress = builder.ipAddress;
        this.source = builder.source;
        this.vmId = builder.vmId;
    }

    /**
     * <p>
     * The host name of the analyzable server.
     * </p>
     * 
     * @return The host name of the analyzable server.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The ip address of the analyzable server.
     * </p>
     * 
     * @return The ip address of the analyzable server.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The data source of the analyzable server.
     * </p>
     * 
     * @return The data source of the analyzable server.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The virtual machine id of the analyzable server.
     * </p>
     * 
     * @return The virtual machine id of the analyzable server.
     */
    public final String vmId() {
        return vmId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(vmId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzableServerSummary)) {
            return false;
        }
        AnalyzableServerSummary other = (AnalyzableServerSummary) obj;
        return Objects.equals(hostname(), other.hostname()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(source(), other.source()) && Objects.equals(vmId(), other.vmId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyzableServerSummary").add("Hostname", hostname()).add("IpAddress", ipAddress())
                .add("Source", source()).add("VmId", vmId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "ipAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "vmId":
            return Optional.ofNullable(clazz.cast(vmId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzableServerSummary, T> g) {
        return obj -> g.apply((AnalyzableServerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyzableServerSummary> {
        /**
         * <p>
         * The host name of the analyzable server.
         * </p>
         * 
         * @param hostname
         *        The host name of the analyzable server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The ip address of the analyzable server.
         * </p>
         * 
         * @param ipAddress
         *        The ip address of the analyzable server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The data source of the analyzable server.
         * </p>
         * 
         * @param source
         *        The data source of the analyzable server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The virtual machine id of the analyzable server.
         * </p>
         * 
         * @param vmId
         *        The virtual machine id of the analyzable server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmId(String vmId);
    }

    static final class BuilderImpl implements Builder {
        private String hostname;

        private String ipAddress;

        private String source;

        private String vmId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzableServerSummary model) {
            hostname(model.hostname);
            ipAddress(model.ipAddress);
            source(model.source);
            vmId(model.vmId);
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getVmId() {
            return vmId;
        }

        public final void setVmId(String vmId) {
            this.vmId = vmId;
        }

        @Override
        public final Builder vmId(String vmId) {
            this.vmId = vmId;
            return this;
        }

        @Override
        public AnalyzableServerSummary build() {
            return new AnalyzableServerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
