/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyClient;
import software.amazon.awssdk.services.migrationhubstrategy.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhubstrategy.model.ImportFileTaskInformation;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse;

public class ListImportFileTaskIterable
implements SdkIterable<ListImportFileTaskResponse> {
    private final MigrationHubStrategyClient client;
    private final ListImportFileTaskRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImportFileTaskIterable(MigrationHubStrategyClient client, ListImportFileTaskRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImportFileTaskResponseFetcher();
    }

    public Iterator<ListImportFileTaskResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportFileTaskInformation> taskInfos() {
        Function<ListImportFileTaskResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskInfos() != null) {
                return response.taskInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImportFileTaskResponseFetcher
    implements SyncPageFetcher<ListImportFileTaskResponse> {
        private ListImportFileTaskResponseFetcher() {
        }

        public boolean hasNextPage(ListImportFileTaskResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImportFileTaskResponse nextPage(ListImportFileTaskResponse previousPage) {
            if (previousPage == null) {
                return ListImportFileTaskIterable.this.client.listImportFileTask(ListImportFileTaskIterable.this.firstRequest);
            }
            return ListImportFileTaskIterable.this.client.listImportFileTask((ListImportFileTaskRequest)((Object)ListImportFileTaskIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

