/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the server configured for source code analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoteSourceCodeAnalysisServerInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<RemoteSourceCodeAnalysisServerInfo.Builder, RemoteSourceCodeAnalysisServerInfo> {
    private static final SdkField<String> REMOTE_SOURCE_CODE_ANALYSIS_SERVER_CONFIGURATION_TIMESTAMP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("remoteSourceCodeAnalysisServerConfigurationTimestamp")
            .getter(getter(RemoteSourceCodeAnalysisServerInfo::remoteSourceCodeAnalysisServerConfigurationTimestamp))
            .setter(setter(Builder::remoteSourceCodeAnalysisServerConfigurationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("remoteSourceCodeAnalysisServerConfigurationTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REMOTE_SOURCE_CODE_ANALYSIS_SERVER_CONFIGURATION_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String remoteSourceCodeAnalysisServerConfigurationTimestamp;

    private RemoteSourceCodeAnalysisServerInfo(BuilderImpl builder) {
        this.remoteSourceCodeAnalysisServerConfigurationTimestamp = builder.remoteSourceCodeAnalysisServerConfigurationTimestamp;
    }

    /**
     * <p>
     * The time when the remote source code server was configured.
     * </p>
     * 
     * @return The time when the remote source code server was configured.
     */
    public final String remoteSourceCodeAnalysisServerConfigurationTimestamp() {
        return remoteSourceCodeAnalysisServerConfigurationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(remoteSourceCodeAnalysisServerConfigurationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteSourceCodeAnalysisServerInfo)) {
            return false;
        }
        RemoteSourceCodeAnalysisServerInfo other = (RemoteSourceCodeAnalysisServerInfo) obj;
        return Objects.equals(remoteSourceCodeAnalysisServerConfigurationTimestamp(),
                other.remoteSourceCodeAnalysisServerConfigurationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("RemoteSourceCodeAnalysisServerInfo")
                .add("RemoteSourceCodeAnalysisServerConfigurationTimestamp",
                        remoteSourceCodeAnalysisServerConfigurationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteSourceCodeAnalysisServerConfigurationTimestamp":
            return Optional.ofNullable(clazz.cast(remoteSourceCodeAnalysisServerConfigurationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoteSourceCodeAnalysisServerInfo, T> g) {
        return obj -> g.apply((RemoteSourceCodeAnalysisServerInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemoteSourceCodeAnalysisServerInfo> {
        /**
         * <p>
         * The time when the remote source code server was configured.
         * </p>
         * 
         * @param remoteSourceCodeAnalysisServerConfigurationTimestamp
         *        The time when the remote source code server was configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteSourceCodeAnalysisServerConfigurationTimestamp(String remoteSourceCodeAnalysisServerConfigurationTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String remoteSourceCodeAnalysisServerConfigurationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteSourceCodeAnalysisServerInfo model) {
            remoteSourceCodeAnalysisServerConfigurationTimestamp(model.remoteSourceCodeAnalysisServerConfigurationTimestamp);
        }

        public final String getRemoteSourceCodeAnalysisServerConfigurationTimestamp() {
            return remoteSourceCodeAnalysisServerConfigurationTimestamp;
        }

        public final void setRemoteSourceCodeAnalysisServerConfigurationTimestamp(
                String remoteSourceCodeAnalysisServerConfigurationTimestamp) {
            this.remoteSourceCodeAnalysisServerConfigurationTimestamp = remoteSourceCodeAnalysisServerConfigurationTimestamp;
        }

        @Override
        public final Builder remoteSourceCodeAnalysisServerConfigurationTimestamp(
                String remoteSourceCodeAnalysisServerConfigurationTimestamp) {
            this.remoteSourceCodeAnalysisServerConfigurationTimestamp = remoteSourceCodeAnalysisServerConfigurationTimestamp;
            return this;
        }

        @Override
        public RemoteSourceCodeAnalysisServerInfo build() {
            return new RemoteSourceCodeAnalysisServerInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
