/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the collector configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationSummary.Builder, ConfigurationSummary> {
    private static final SdkField<List<IPAddressBasedRemoteInfo>> IP_ADDRESS_BASED_REMOTE_INFO_LIST_FIELD = SdkField
            .<List<IPAddressBasedRemoteInfo>> builder(MarshallingType.LIST)
            .memberName("ipAddressBasedRemoteInfoList")
            .getter(getter(ConfigurationSummary::ipAddressBasedRemoteInfoList))
            .setter(setter(Builder::ipAddressBasedRemoteInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressBasedRemoteInfoList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IPAddressBasedRemoteInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPAddressBasedRemoteInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PipelineInfo>> PIPELINE_INFO_LIST_FIELD = SdkField
            .<List<PipelineInfo>> builder(MarshallingType.LIST)
            .memberName("pipelineInfoList")
            .getter(getter(ConfigurationSummary::pipelineInfoList))
            .setter(setter(Builder::pipelineInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RemoteSourceCodeAnalysisServerInfo> REMOTE_SOURCE_CODE_ANALYSIS_SERVER_INFO_FIELD = SdkField
            .<RemoteSourceCodeAnalysisServerInfo> builder(MarshallingType.SDK_POJO)
            .memberName("remoteSourceCodeAnalysisServerInfo")
            .getter(getter(ConfigurationSummary::remoteSourceCodeAnalysisServerInfo))
            .setter(setter(Builder::remoteSourceCodeAnalysisServerInfo))
            .constructor(RemoteSourceCodeAnalysisServerInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteSourceCodeAnalysisServerInfo")
                    .build()).build();

    private static final SdkField<List<VcenterBasedRemoteInfo>> VCENTER_BASED_REMOTE_INFO_LIST_FIELD = SdkField
            .<List<VcenterBasedRemoteInfo>> builder(MarshallingType.LIST)
            .memberName("vcenterBasedRemoteInfoList")
            .getter(getter(ConfigurationSummary::vcenterBasedRemoteInfoList))
            .setter(setter(Builder::vcenterBasedRemoteInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcenterBasedRemoteInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VcenterBasedRemoteInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(VcenterBasedRemoteInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VersionControlInfo>> VERSION_CONTROL_INFO_LIST_FIELD = SdkField
            .<List<VersionControlInfo>> builder(MarshallingType.LIST)
            .memberName("versionControlInfoList")
            .getter(getter(ConfigurationSummary::versionControlInfoList))
            .setter(setter(Builder::versionControlInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionControlInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VersionControlInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(VersionControlInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IP_ADDRESS_BASED_REMOTE_INFO_LIST_FIELD, PIPELINE_INFO_LIST_FIELD, REMOTE_SOURCE_CODE_ANALYSIS_SERVER_INFO_FIELD,
            VCENTER_BASED_REMOTE_INFO_LIST_FIELD, VERSION_CONTROL_INFO_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<IPAddressBasedRemoteInfo> ipAddressBasedRemoteInfoList;

    private final List<PipelineInfo> pipelineInfoList;

    private final RemoteSourceCodeAnalysisServerInfo remoteSourceCodeAnalysisServerInfo;

    private final List<VcenterBasedRemoteInfo> vcenterBasedRemoteInfoList;

    private final List<VersionControlInfo> versionControlInfoList;

    private ConfigurationSummary(BuilderImpl builder) {
        this.ipAddressBasedRemoteInfoList = builder.ipAddressBasedRemoteInfoList;
        this.pipelineInfoList = builder.pipelineInfoList;
        this.remoteSourceCodeAnalysisServerInfo = builder.remoteSourceCodeAnalysisServerInfo;
        this.vcenterBasedRemoteInfoList = builder.vcenterBasedRemoteInfoList;
        this.versionControlInfoList = builder.versionControlInfoList;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpAddressBasedRemoteInfoList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIpAddressBasedRemoteInfoList() {
        return ipAddressBasedRemoteInfoList != null && !(ipAddressBasedRemoteInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * IP address based configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpAddressBasedRemoteInfoList} method.
     * </p>
     * 
     * @return IP address based configurations.
     */
    public final List<IPAddressBasedRemoteInfo> ipAddressBasedRemoteInfoList() {
        return ipAddressBasedRemoteInfoList;
    }

    /**
     * For responses, this returns true if the service returned a value for the PipelineInfoList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPipelineInfoList() {
        return pipelineInfoList != null && !(pipelineInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of pipeline info configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelineInfoList} method.
     * </p>
     * 
     * @return The list of pipeline info configurations.
     */
    public final List<PipelineInfo> pipelineInfoList() {
        return pipelineInfoList;
    }

    /**
     * <p>
     * Info about the remote server source code configuration.
     * </p>
     * 
     * @return Info about the remote server source code configuration.
     */
    public final RemoteSourceCodeAnalysisServerInfo remoteSourceCodeAnalysisServerInfo() {
        return remoteSourceCodeAnalysisServerInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the VcenterBasedRemoteInfoList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVcenterBasedRemoteInfoList() {
        return vcenterBasedRemoteInfoList != null && !(vcenterBasedRemoteInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of vCenter configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVcenterBasedRemoteInfoList} method.
     * </p>
     * 
     * @return The list of vCenter configurations.
     */
    public final List<VcenterBasedRemoteInfo> vcenterBasedRemoteInfoList() {
        return vcenterBasedRemoteInfoList;
    }

    /**
     * For responses, this returns true if the service returned a value for the VersionControlInfoList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVersionControlInfoList() {
        return versionControlInfoList != null && !(versionControlInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the version control configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVersionControlInfoList} method.
     * </p>
     * 
     * @return The list of the version control configurations.
     */
    public final List<VersionControlInfo> versionControlInfoList() {
        return versionControlInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIpAddressBasedRemoteInfoList() ? ipAddressBasedRemoteInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineInfoList() ? pipelineInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(remoteSourceCodeAnalysisServerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasVcenterBasedRemoteInfoList() ? vcenterBasedRemoteInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVersionControlInfoList() ? versionControlInfoList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationSummary)) {
            return false;
        }
        ConfigurationSummary other = (ConfigurationSummary) obj;
        return hasIpAddressBasedRemoteInfoList() == other.hasIpAddressBasedRemoteInfoList()
                && Objects.equals(ipAddressBasedRemoteInfoList(), other.ipAddressBasedRemoteInfoList())
                && hasPipelineInfoList() == other.hasPipelineInfoList()
                && Objects.equals(pipelineInfoList(), other.pipelineInfoList())
                && Objects.equals(remoteSourceCodeAnalysisServerInfo(), other.remoteSourceCodeAnalysisServerInfo())
                && hasVcenterBasedRemoteInfoList() == other.hasVcenterBasedRemoteInfoList()
                && Objects.equals(vcenterBasedRemoteInfoList(), other.vcenterBasedRemoteInfoList())
                && hasVersionControlInfoList() == other.hasVersionControlInfoList()
                && Objects.equals(versionControlInfoList(), other.versionControlInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationSummary")
                .add("IpAddressBasedRemoteInfoList", hasIpAddressBasedRemoteInfoList() ? ipAddressBasedRemoteInfoList() : null)
                .add("PipelineInfoList", hasPipelineInfoList() ? pipelineInfoList() : null)
                .add("RemoteSourceCodeAnalysisServerInfo", remoteSourceCodeAnalysisServerInfo())
                .add("VcenterBasedRemoteInfoList", hasVcenterBasedRemoteInfoList() ? vcenterBasedRemoteInfoList() : null)
                .add("VersionControlInfoList", hasVersionControlInfoList() ? versionControlInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ipAddressBasedRemoteInfoList":
            return Optional.ofNullable(clazz.cast(ipAddressBasedRemoteInfoList()));
        case "pipelineInfoList":
            return Optional.ofNullable(clazz.cast(pipelineInfoList()));
        case "remoteSourceCodeAnalysisServerInfo":
            return Optional.ofNullable(clazz.cast(remoteSourceCodeAnalysisServerInfo()));
        case "vcenterBasedRemoteInfoList":
            return Optional.ofNullable(clazz.cast(vcenterBasedRemoteInfoList()));
        case "versionControlInfoList":
            return Optional.ofNullable(clazz.cast(versionControlInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationSummary, T> g) {
        return obj -> g.apply((ConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationSummary> {
        /**
         * <p>
         * IP address based configurations.
         * </p>
         * 
         * @param ipAddressBasedRemoteInfoList
         *        IP address based configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressBasedRemoteInfoList(Collection<IPAddressBasedRemoteInfo> ipAddressBasedRemoteInfoList);

        /**
         * <p>
         * IP address based configurations.
         * </p>
         * 
         * @param ipAddressBasedRemoteInfoList
         *        IP address based configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressBasedRemoteInfoList(IPAddressBasedRemoteInfo... ipAddressBasedRemoteInfoList);

        /**
         * <p>
         * IP address based configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.IPAddressBasedRemoteInfo.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.IPAddressBasedRemoteInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.IPAddressBasedRemoteInfo.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #ipAddressBasedRemoteInfoList(List<IPAddressBasedRemoteInfo>)}.
         * 
         * @param ipAddressBasedRemoteInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.IPAddressBasedRemoteInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipAddressBasedRemoteInfoList(java.util.Collection<IPAddressBasedRemoteInfo>)
         */
        Builder ipAddressBasedRemoteInfoList(Consumer<IPAddressBasedRemoteInfo.Builder>... ipAddressBasedRemoteInfoList);

        /**
         * <p>
         * The list of pipeline info configurations.
         * </p>
         * 
         * @param pipelineInfoList
         *        The list of pipeline info configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineInfoList(Collection<PipelineInfo> pipelineInfoList);

        /**
         * <p>
         * The list of pipeline info configurations.
         * </p>
         * 
         * @param pipelineInfoList
         *        The list of pipeline info configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineInfoList(PipelineInfo... pipelineInfoList);

        /**
         * <p>
         * The list of pipeline info configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.PipelineInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.PipelineInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.PipelineInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #pipelineInfoList(List<PipelineInfo>)}.
         * 
         * @param pipelineInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.PipelineInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineInfoList(java.util.Collection<PipelineInfo>)
         */
        Builder pipelineInfoList(Consumer<PipelineInfo.Builder>... pipelineInfoList);

        /**
         * <p>
         * Info about the remote server source code configuration.
         * </p>
         * 
         * @param remoteSourceCodeAnalysisServerInfo
         *        Info about the remote server source code configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteSourceCodeAnalysisServerInfo(RemoteSourceCodeAnalysisServerInfo remoteSourceCodeAnalysisServerInfo);

        /**
         * <p>
         * Info about the remote server source code configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RemoteSourceCodeAnalysisServerInfo.Builder} avoiding the need to create one manually via
         * {@link RemoteSourceCodeAnalysisServerInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemoteSourceCodeAnalysisServerInfo.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #remoteSourceCodeAnalysisServerInfo(RemoteSourceCodeAnalysisServerInfo)}.
         * 
         * @param remoteSourceCodeAnalysisServerInfo
         *        a consumer that will call methods on {@link RemoteSourceCodeAnalysisServerInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteSourceCodeAnalysisServerInfo(RemoteSourceCodeAnalysisServerInfo)
         */
        default Builder remoteSourceCodeAnalysisServerInfo(
                Consumer<RemoteSourceCodeAnalysisServerInfo.Builder> remoteSourceCodeAnalysisServerInfo) {
            return remoteSourceCodeAnalysisServerInfo(RemoteSourceCodeAnalysisServerInfo.builder()
                    .applyMutation(remoteSourceCodeAnalysisServerInfo).build());
        }

        /**
         * <p>
         * The list of vCenter configurations.
         * </p>
         * 
         * @param vcenterBasedRemoteInfoList
         *        The list of vCenter configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcenterBasedRemoteInfoList(Collection<VcenterBasedRemoteInfo> vcenterBasedRemoteInfoList);

        /**
         * <p>
         * The list of vCenter configurations.
         * </p>
         * 
         * @param vcenterBasedRemoteInfoList
         *        The list of vCenter configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcenterBasedRemoteInfoList(VcenterBasedRemoteInfo... vcenterBasedRemoteInfoList);

        /**
         * <p>
         * The list of vCenter configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.VcenterBasedRemoteInfo.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.VcenterBasedRemoteInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.VcenterBasedRemoteInfo.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #vcenterBasedRemoteInfoList(List<VcenterBasedRemoteInfo>)}.
         * 
         * @param vcenterBasedRemoteInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.VcenterBasedRemoteInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vcenterBasedRemoteInfoList(java.util.Collection<VcenterBasedRemoteInfo>)
         */
        Builder vcenterBasedRemoteInfoList(Consumer<VcenterBasedRemoteInfo.Builder>... vcenterBasedRemoteInfoList);

        /**
         * <p>
         * The list of the version control configurations.
         * </p>
         * 
         * @param versionControlInfoList
         *        The list of the version control configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionControlInfoList(Collection<VersionControlInfo> versionControlInfoList);

        /**
         * <p>
         * The list of the version control configurations.
         * </p>
         * 
         * @param versionControlInfoList
         *        The list of the version control configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionControlInfoList(VersionControlInfo... versionControlInfoList);

        /**
         * <p>
         * The list of the version control configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.VersionControlInfo.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.VersionControlInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.VersionControlInfo.Builder#build()} is
         * called immediately and its result is passed to {@link #versionControlInfoList(List<VersionControlInfo>)}.
         * 
         * @param versionControlInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.VersionControlInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versionControlInfoList(java.util.Collection<VersionControlInfo>)
         */
        Builder versionControlInfoList(Consumer<VersionControlInfo.Builder>... versionControlInfoList);
    }

    static final class BuilderImpl implements Builder {
        private List<IPAddressBasedRemoteInfo> ipAddressBasedRemoteInfoList = DefaultSdkAutoConstructList.getInstance();

        private List<PipelineInfo> pipelineInfoList = DefaultSdkAutoConstructList.getInstance();

        private RemoteSourceCodeAnalysisServerInfo remoteSourceCodeAnalysisServerInfo;

        private List<VcenterBasedRemoteInfo> vcenterBasedRemoteInfoList = DefaultSdkAutoConstructList.getInstance();

        private List<VersionControlInfo> versionControlInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationSummary model) {
            ipAddressBasedRemoteInfoList(model.ipAddressBasedRemoteInfoList);
            pipelineInfoList(model.pipelineInfoList);
            remoteSourceCodeAnalysisServerInfo(model.remoteSourceCodeAnalysisServerInfo);
            vcenterBasedRemoteInfoList(model.vcenterBasedRemoteInfoList);
            versionControlInfoList(model.versionControlInfoList);
        }

        public final List<IPAddressBasedRemoteInfo.Builder> getIpAddressBasedRemoteInfoList() {
            List<IPAddressBasedRemoteInfo.Builder> result = IPAddressBasedRemoteInfoListCopier
                    .copyToBuilder(this.ipAddressBasedRemoteInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpAddressBasedRemoteInfoList(
                Collection<IPAddressBasedRemoteInfo.BuilderImpl> ipAddressBasedRemoteInfoList) {
            this.ipAddressBasedRemoteInfoList = IPAddressBasedRemoteInfoListCopier.copyFromBuilder(ipAddressBasedRemoteInfoList);
        }

        @Override
        public final Builder ipAddressBasedRemoteInfoList(Collection<IPAddressBasedRemoteInfo> ipAddressBasedRemoteInfoList) {
            this.ipAddressBasedRemoteInfoList = IPAddressBasedRemoteInfoListCopier.copy(ipAddressBasedRemoteInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddressBasedRemoteInfoList(IPAddressBasedRemoteInfo... ipAddressBasedRemoteInfoList) {
            ipAddressBasedRemoteInfoList(Arrays.asList(ipAddressBasedRemoteInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddressBasedRemoteInfoList(
                Consumer<IPAddressBasedRemoteInfo.Builder>... ipAddressBasedRemoteInfoList) {
            ipAddressBasedRemoteInfoList(Stream.of(ipAddressBasedRemoteInfoList)
                    .map(c -> IPAddressBasedRemoteInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PipelineInfo.Builder> getPipelineInfoList() {
            List<PipelineInfo.Builder> result = PipelineInfoListCopier.copyToBuilder(this.pipelineInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineInfoList(Collection<PipelineInfo.BuilderImpl> pipelineInfoList) {
            this.pipelineInfoList = PipelineInfoListCopier.copyFromBuilder(pipelineInfoList);
        }

        @Override
        public final Builder pipelineInfoList(Collection<PipelineInfo> pipelineInfoList) {
            this.pipelineInfoList = PipelineInfoListCopier.copy(pipelineInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineInfoList(PipelineInfo... pipelineInfoList) {
            pipelineInfoList(Arrays.asList(pipelineInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineInfoList(Consumer<PipelineInfo.Builder>... pipelineInfoList) {
            pipelineInfoList(Stream.of(pipelineInfoList).map(c -> PipelineInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RemoteSourceCodeAnalysisServerInfo.Builder getRemoteSourceCodeAnalysisServerInfo() {
            return remoteSourceCodeAnalysisServerInfo != null ? remoteSourceCodeAnalysisServerInfo.toBuilder() : null;
        }

        public final void setRemoteSourceCodeAnalysisServerInfo(
                RemoteSourceCodeAnalysisServerInfo.BuilderImpl remoteSourceCodeAnalysisServerInfo) {
            this.remoteSourceCodeAnalysisServerInfo = remoteSourceCodeAnalysisServerInfo != null ? remoteSourceCodeAnalysisServerInfo
                    .build() : null;
        }

        @Override
        public final Builder remoteSourceCodeAnalysisServerInfo(
                RemoteSourceCodeAnalysisServerInfo remoteSourceCodeAnalysisServerInfo) {
            this.remoteSourceCodeAnalysisServerInfo = remoteSourceCodeAnalysisServerInfo;
            return this;
        }

        public final List<VcenterBasedRemoteInfo.Builder> getVcenterBasedRemoteInfoList() {
            List<VcenterBasedRemoteInfo.Builder> result = VcenterBasedRemoteInfoListCopier
                    .copyToBuilder(this.vcenterBasedRemoteInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVcenterBasedRemoteInfoList(Collection<VcenterBasedRemoteInfo.BuilderImpl> vcenterBasedRemoteInfoList) {
            this.vcenterBasedRemoteInfoList = VcenterBasedRemoteInfoListCopier.copyFromBuilder(vcenterBasedRemoteInfoList);
        }

        @Override
        public final Builder vcenterBasedRemoteInfoList(Collection<VcenterBasedRemoteInfo> vcenterBasedRemoteInfoList) {
            this.vcenterBasedRemoteInfoList = VcenterBasedRemoteInfoListCopier.copy(vcenterBasedRemoteInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vcenterBasedRemoteInfoList(VcenterBasedRemoteInfo... vcenterBasedRemoteInfoList) {
            vcenterBasedRemoteInfoList(Arrays.asList(vcenterBasedRemoteInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vcenterBasedRemoteInfoList(Consumer<VcenterBasedRemoteInfo.Builder>... vcenterBasedRemoteInfoList) {
            vcenterBasedRemoteInfoList(Stream.of(vcenterBasedRemoteInfoList)
                    .map(c -> VcenterBasedRemoteInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VersionControlInfo.Builder> getVersionControlInfoList() {
            List<VersionControlInfo.Builder> result = VersionControlInfoListCopier.copyToBuilder(this.versionControlInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVersionControlInfoList(Collection<VersionControlInfo.BuilderImpl> versionControlInfoList) {
            this.versionControlInfoList = VersionControlInfoListCopier.copyFromBuilder(versionControlInfoList);
        }

        @Override
        public final Builder versionControlInfoList(Collection<VersionControlInfo> versionControlInfoList) {
            this.versionControlInfoList = VersionControlInfoListCopier.copy(versionControlInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionControlInfoList(VersionControlInfo... versionControlInfoList) {
            versionControlInfoList(Arrays.asList(versionControlInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionControlInfoList(Consumer<VersionControlInfo.Builder>... versionControlInfoList) {
            versionControlInfoList(Stream.of(versionControlInfoList)
                    .map(c -> VersionControlInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConfigurationSummary build() {
            return new ConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
